package util.sqlparse.visitor.hive.parser;

import bean.DataBase;
import com.chenyang.druid.sql.SQLUtils;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.bean.SQLResult;
import util.sqlparse.visitor.common.bean.StatementType;
import util.sqlparse.visitor.hive.SQLParser;

public abstract class SQLStatementParser {
   public abstract SQLResult parseStatement(SQLStatement var1, DataBase var2, String var3);

   public static SQLResult parse(String sql, DataBase dataBase, String schema) {
      if (sql != null && sql.length() != 0) {
         List<SQLStatement> statements = SQLUtils.parseStatements(sql, "hive");
         return statements != null && statements.size() != 0 ? parse((SQLStatement)statements.get(0), dataBase, schema) : null;
      } else {
         throw new IllegalArgumentException("sql");
      }
   }

   public static SQLResult parse(SQLStatement statement, DataBase dataBase, String schema) {
      if (statement == null) {
         throw new IllegalArgumentException("statement");
      } else {
         StatementType type = SQLParser.getStatementType(statement);
         if (type == StatementType.other) {
            SQLResult result = new SQLResult();
            result.fields = new ArrayList();
            result.tables = new ArrayList();
            result.tableMemos = new ArrayList();
            result.outputMemos = new ArrayList();
            result.values = new ArrayList();
            result.outputs = new ArrayList();
            result.fieldMemos = new ArrayList();
            result.statement = statement;
            result.sqlType = TableStat.Mode.Other;
            result.statementType = type;
            return result;
         } else {
            SQLStatementParser parser;
            switch (type) {
               case createProc:
               case createFunction:
               case createEvent:
               case alterEvent:
               case createTrigger:
                  parser = new CompoundSQLStatementParser();
                  break;
               default:
                  parser = new SimpleSQLStatementParser();
            }

            return parser.parseStatement(statement, dataBase, schema);
         }
      }
   }
}
