package util.sqlparse.visitor.hive.visitor;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.chenyang.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.dialect.hive.ast.stmt.HiveDeleteStatement;
import com.chenyang.druid.sql.dialect.hive.ast.stmt.HiveGrantStatement;
import com.chenyang.druid.sql.dialect.hive.ast.stmt.HiveSelectQueryBlock;
import com.chenyang.druid.sql.dialect.hive.ast.stmt.HiveUpdateStatement;
import com.chenyang.druid.sql.dialect.hive.visitor.DefaultHiveASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class WhereVisitor extends DefaultHiveASTVisitor {
   private boolean debug = false;
   private List<String> wheres = new ArrayList();

   public List<String> getWheres() {
      return this.wheres;
   }

   public void perform(List<SQLStatement> statements) {
      if (statements != null && statements.size() != 0) {
         for(SQLStatement statement : statements) {
            statement.accept(this);
         }

      }
   }

   public boolean visit(SQLUpdateStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public boolean visit(HiveSelectQueryBlock x) {
      return false;
   }

   public void endVisit(HiveSelectQueryBlock x) {
   }

   public boolean visit(HiveDeleteStatement x) {
      return false;
   }

   public void endVisit(HiveDeleteStatement x) {
   }

   public boolean visit(HiveGrantStatement x) {
      return false;
   }

   public void endVisit(HiveGrantStatement x) {
   }

   public boolean visit(SQLDeleteStatement x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      return true;
   }

   public boolean visit(SQLSelectQueryBlock x) {
      SQLExpr where = x.getWhere();
      if (where != null) {
         this.wheres.add(where.toString());
      }

      SQLSelectGroupByClause groupBy = x.getGroupBy();
      if (groupBy != null && groupBy.getHaving() != null) {
         this.wheres.add(groupBy.getHaving().toString());
      }

      return true;
   }

   public boolean visit(HiveUpdateStatement x) {
      return false;
   }

   public void endVisit(HiveUpdateStatement x) {
   }
}
