package util.sqlparse.visitor.mysql.visitor;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import util.JdbcUtil;
import util.SqlUtil;

public class TestJdbc {
   public static void main(String[] args) throws Exception {
      testcache();
   }

   private static void test1(Connection connection) throws ClassNotFoundException, SQLException {
      Statement statement = connection.createStatement();
      ResultSet resultSet = statement.executeQuery("select * from test.sys_dept");

      while(resultSet.next()) {
         System.out.println(resultSet.getString(4));
      }

   }

   private static void test2(Connection connection) throws ClassNotFoundException, SQLException {
      Statement statement = connection.createStatement();
      PreparedStatement prestmt = connection.prepareStatement("select * from test.sys_dept limit ?");
      prestmt.setInt(1, 1);
      prestmt.executeQuery();
   }

   private static Connection connection() throws SQLException {
      String url = "jdbc:mariadb://192.168.2.155:3326/test?zeroDateTimeBehavior=convertToNull&useSSL=false&serverTimezone=UTC";
      Connection connection = DriverManager.getConnection(url, "root", "root");
      return connection;
   }

   public static void testcache() throws Exception {
      String content = "{\n      \"ip_port\": \"192.168.2.221:3306\",\n      \"url\": \"jdbc:mariadb://192.168.2.221:3306/mysql\",\n      \"username\": \"root\",\n      \"isIgnorecase\":\"0\",\n      \"password\": \"root\",\n      \"dbType\": \"mysql\",\n      \"redisMode\": \"none\",\n      \"redisIp\": \"192.168.2.245\",\n      \"redisNodes\": \"192.168.2.81:6379,192.168.2.81:6380,192.168.2.82:6379,192.168.2.82:6380,192.168.2.83:6379,192.168.2.83:6380\",\n      \"redisPort\": \"6379\",\n      \"redisUsername\": \"\",\n      \"redisPassword\": \"123456\",\n      \"redisDatabase\": \"0\",\n      \"excludeSchema\": [\"encryption_test2\",\"ghca_static_develop\",\"ghca_static_develop_test\",\"pg_catalog\"]\n    }";
      Class.forName("org.mariadb.jdbc.Driver");
      JdbcUtil.refreshData(content);
      Thread.sleep(3000L);
      Map<String, String> params = new HashMap();
      params.put("sql", "select * from ry.gen_table");
      params.put("dbType", "mysql");
      params.put("schema", "ry");
      params.put("url", "jdbc:mysql://192.168.2.221:3306/mysql");
      SqlUtil sqlUtil = new SqlUtil();
      Map<String, Object> stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
      stringObjectMap = sqlUtil.parseSqlStructureAnd(params);
      System.out.println(stringObjectMap);
   }
}
