package util.sqlparse.visitor.oracle.visitor;

import bean.Column;
import bean.Synonym;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLPartition;
import com.chenyang.druid.sql.ast.SQLWindow;
import com.chenyang.druid.sql.ast.expr.SQLAggregateExpr;
import com.chenyang.druid.sql.ast.expr.SQLDbLinkExpr;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.ast.expr.SQLQueryExpr;
import com.chenyang.druid.sql.ast.expr.SQLSequenceExpr;
import com.chenyang.druid.sql.ast.expr.SQLValuableExpr;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLJoinTableSource;
import com.chenyang.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.chenyang.druid.sql.ast.statement.SQLMergeStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelect;
import com.chenyang.druid.sql.ast.statement.SQLSelectItem;
import com.chenyang.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUnionQuery;
import com.chenyang.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUpdateSetItem;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.chenyang.druid.sql.dialect.oracle.ast.clause.OracleWithSubqueryEntry;
import com.chenyang.druid.sql.dialect.oracle.ast.expr.OracleJsonArrayAggExpr;
import com.chenyang.druid.sql.dialect.oracle.ast.expr.OracleJsonObjectExpr;
import com.chenyang.druid.sql.dialect.oracle.ast.expr.OracleSysdateExpr;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivot;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivotBase;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleSelectUnPivot;
import com.chenyang.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.chenyang.druid.stat.TableStat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import util.sqlparse.visitor.common.Owner;
import util.sqlparse.visitor.common.memo.AliasField;
import util.sqlparse.visitor.common.memo.FieldMemo;
import util.sqlparse.visitor.common.memo.TableMemo;
import util.sqlparse.visitor.common.scope.ClauseScope;
import util.sqlparse.visitor.common.scope.Scope;
import util.sqlparse.visitor.common.scope.TableScope;
import util.sqlparse.visitor.common.utils.Alias;

public class ScopeVisitor extends ParseVisitor {
   private final Alias alias = new Alias();
   private boolean debug = false;

   public ScopeVisitor(Scope scope) {
      super(scope);
   }

   public boolean visit(SQLSelectStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Select;
      }

      if (this.debug) {
         System.out.println("enter SQLSelectStatement " + x.toString());
      }

      this.enterClauseScope(x);
      return true;
   }

   public boolean visit(SQLInsertStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Insert;
      }

      this.enterClauseScope(x);
      if (x.getWith() != null) {
         x.getWith().accept(this);
      }

      if (x.getTableSource() != null) {
         x.getTableSource().accept(this);
      }

      if (x.getColumns().size() == 0) {
         String schema = null;
         String table = null;
         OracleInsertStatement stmt = (OracleInsertStatement)x;
         if (stmt.getSelect() != null) {
            stmt.getSelect().accept(this);
         } else {
            SQLName tableName = x.getTableName();
            if (tableName instanceof SQLIdentifierExpr) {
               SQLIdentifierExpr expr = (SQLIdentifierExpr)tableName;
               table = expr.getName();
               schema = this.scope.context.getSchema();
            } else if (tableName instanceof SQLPropertyExpr) {
               SQLPropertyExpr expr = (SQLPropertyExpr)tableName;
               table = expr.getName();
               schema = expr.getOwnerName();
            }

            if (table != null && schema != null) {
               List<Column> columns = this.scope.context.getColumns(schema, table);
               if (columns != null && columns.size() > 0) {
                  Iterator var7 = columns.iterator();

                  while(var7.hasNext()) {
                     Column column = (Column)var7.next();
                     String name = this.scope.dialector.wrap(column.getColumnName());
                     SQLExpr expr = new SQLIdentifierExpr(name);
                     x.getColumns().add(expr);
                     expr.setParent(x);
                  }
               }
            }
         }
      }

      Iterator var11 = x.getColumns().iterator();

      while(var11.hasNext()) {
         SQLExpr column = (SQLExpr)var11.next();
         column.accept(this);
         FieldMemo field = (FieldMemo)column.getAttribute("field");
         if (field != null) {
            field.isSelectItem = true;
         }
      }

      if (x.getValuesList() != null) {
         var11 = x.getValuesList().iterator();

         while(var11.hasNext()) {
            SQLInsertStatement.ValuesClause clause = (SQLInsertStatement.ValuesClause)var11.next();
            clause.accept(this);
         }
      }

      if (x.getQuery() != null) {
         x.getQuery().accept(this);
      }

      return false;
   }

   public boolean visit(OracleInsertStatement x) {
      return this.visit((SQLInsertStatement)x);
   }

   public boolean visit(OracleMultiInsertStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Insert;
      }

      this.enterClauseScope(x);
      if (x.getSubQuery() != null) {
         x.getSubQuery().accept(this);
      }

      Iterator var2 = x.getEntries().iterator();

      while(var2.hasNext()) {
         OracleMultiInsertStatement.Entry entry = (OracleMultiInsertStatement.Entry)var2.next();
         entry.accept(this);
      }

      return false;
   }

   public boolean visit(OracleMultiInsertStatement.InsertIntoClause x) {
      x.getTableSource().accept(this);
      Scope current = this.scope.getCurrent();
      TableMemo table = current.getTable(x.getTableSource().getExpr());
      List<FieldMemo> fields = current.expandAllColumns(table, false);
      Iterator var5;
      if (x.getColumns() != null && x.getColumns().size() != 0) {
         var5 = x.getColumns().iterator();

         while(var5.hasNext()) {
            SQLExpr column = (SQLExpr)var5.next();
            this.visitChild(column);
            FieldMemo field = (FieldMemo)column.getAttribute("field");
            if (field != null) {
               FieldMemo fieldCopy = field.copy();
               fieldCopy.isSelectItem = true;
               fieldCopy.table = table;
               fieldCopy.alias = field.name;
               current.addField(fieldCopy);
            }
         }
      } else {
         var5 = fields.iterator();

         while(var5.hasNext()) {
            FieldMemo field = (FieldMemo)var5.next();
            SQLIdentifierExpr expr = new SQLIdentifierExpr();
            expr.setName(field.name);
            field.table = table;
            field.isSelectItem = true;
            field.alias = field.name;
            current.addField(field);
            x.addColumn(expr);
         }
      }

      return false;
   }

   public boolean visit(SQLUpdateStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Update;
      }

      this.enterClauseScope(x);
      if (x.getTableSource() != null) {
         x.getTableSource().accept(this);
      }

      if (x.getFrom() != null) {
         x.getFrom().accept(this);
      }

      for(int i = 0; i < x.getItems().size(); ++i) {
         SQLUpdateSetItem item = (SQLUpdateSetItem)x.getItems().get(i);
         if (item != null) {
            item.accept(this);
         }
      }

      if (x.getWhere() != null) {
         x.getWhere().accept(this);
      }

      if (x.getOrderBy() != null) {
         x.getOrderBy().accept(this);
      }

      return false;
   }

   public boolean visit(OracleUpdateStatement x) {
      return this.visit((SQLUpdateStatement)x);
   }

   public boolean visit(SQLMergeStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Merge;
      }

      this.enterClauseScope(x);
      if (x.getInto() != null) {
         x.getInto().accept(this);
      }

      TableMemo intoTable = (TableMemo)x.getInto().getAttribute("table");
      if (x.getUsing() != null) {
         x.getUsing().accept(this);
         if (x.getUsing() instanceof OracleSelectSubqueryTableSource) {
            Scope usingScope = this.scope.getScope(x.getUsing());
            if (usingScope != null) {
               usingScope.top = true;
            }
         }
      }

      if (x.getOn() != null) {
         x.getOn().accept(this);
      }

      if (x.getUpdateClause() != null) {
         x.getUpdateClause().putAttribute("intoTable", intoTable);
         x.getUpdateClause().accept(this);
      }

      if (x.getInsertClause() != null) {
         x.getInsertClause().putAttribute("intoTable", intoTable);
         x.getInsertClause().accept(this);
      }

      return false;
   }

   public boolean visit(SQLMergeStatement.MergeUpdateClause x) {
      TableMemo table = (TableMemo)x.getAttribute("intoTable");
      Scope current = this.scope.getCurrent();
      if (x.getItems() != null) {
         Iterator var4 = x.getItems().iterator();

         while(var4.hasNext()) {
            SQLUpdateSetItem item = (SQLUpdateSetItem)var4.next();
            SQLExpr column = item.getColumn();
            String name = null;
            if (column instanceof SQLName) {
               name = ((SQLName)column).getSimpleName();
            }

            if (name != null) {
               FieldMemo field = new FieldMemo();
               field.name = current.dialector.wrap(name.toUpperCase());
               field.alias = field.name;
               field.table = table;
               field.tables.add(table);
               field.exprs.add(column);
               field.isSelectItem = true;
               field.ref = column;
               field.scope = current;
               current.addField(field);
            }
         }
      }

      return false;
   }

   public boolean visit(SQLMergeStatement.MergeInsertClause x) {
      Scope current = this.scope.getCurrent();
      TableMemo table = (TableMemo)x.getAttribute("intoTable");
      if (x.getColumns().size() == 0) {
         List<FieldMemo> fields = current.expandAllColumns(table, false);
         Iterator var5 = fields.iterator();

         while(var5.hasNext()) {
            FieldMemo field = (FieldMemo)var5.next();
            SQLIdentifierExpr expr = new SQLIdentifierExpr();
            expr.setName(field.name);
            expr.setParent(x);
            x.getColumns().add(expr);
            field.tables.add(table);
            field.exprs.add(expr);
            field.ref = expr;
            field.scope = current;
            current.addField(field);
         }
      } else {
         Iterator var8 = x.getColumns().iterator();

         while(var8.hasNext()) {
            SQLExpr column = (SQLExpr)var8.next();
            String name = null;
            if (column instanceof SQLName) {
               name = ((SQLName)column).getSimpleName();
            }

            if (name != null) {
               name = current.dialector.wrap(name);
               FieldMemo field = new FieldMemo();
               field.name = name;
               field.alias = name;
               field.table = table;
               field.tables.add(table);
               field.exprs.add(column);
               field.isSelectItem = true;
               field.ref = column;
               field.scope = current;
               current.addField(field);
            }
         }
      }

      current.openFieldState();
      if (x.getValues() != null) {
         this.acceptChild(x.getValues());
      }

      current.closeFieldState();
      return false;
   }

   public boolean visit(SQLDeleteStatement x) {
      if (this.scope.context.sqlType == null) {
         this.scope.context.sqlType = TableStat.Mode.Delete;
      }

      this.enterClauseScope(x);
      return true;
   }

   public boolean visit(OracleDeleteStatement x) {
      return this.visit((SQLDeleteStatement)x);
   }

   public boolean visit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause  " + x.toString());
      }

      Scope scope = this.enterClauseScope(x);
      scope.top = true;
      scope.fromField = ((Scope)scope).isFromField(x);
      return true;
   }

   public boolean visit(SQLWithSubqueryClause.Entry x) {
      TableScope scope = this.enterTableScope(x);
      scope.fromField = scope.isFromField(x);
      scope.top = true;
      if (x.getSubQuery() != null) {
         x.getSubQuery().accept(this);
      }

      TableMemo table = this.registerTable(x);
      table.topTable = true;
      x.putAttribute("table", table);
      x.putAttribute("scope", scope);
      scope.table = table;
      return false;
   }

   public boolean visit(OracleWithSubqueryEntry x) {
      TableScope scope = this.enterTableScope(x);
      scope.fromField = scope.isFromField(x);
      scope.top = true;
      if (x.getSubQuery() != null) {
         x.getSubQuery().accept(this);
      }

      if (x.getSearchClause() != null) {
         x.getSearchClause().accept(this);
      }

      if (x.getCycleClause() != null) {
         x.getCycleClause().accept(this);
      }

      TableMemo table = this.registerTable((SQLWithSubqueryClause.Entry)x);
      table.topTable = true;
      x.putAttribute("table", table);
      x.putAttribute("scope", scope);
      scope.table = table;
      return false;
   }

   public void endVisit(OracleWithSubqueryEntry x) {
      this.endVisit((SQLWithSubqueryClause.Entry)x);
   }

   public void endVisit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause.Entry  " + x.toString());
      }

      Scope current = this.scope.getCurrent();
      TableMemo table = (TableMemo)x.getAttribute("table");
      boolean addColumns = x.getColumns().size() == 0;
      List<FieldMemo> fields = new ArrayList();
      current.getSubFieldsForWith(fields);
      Iterator var6 = current.getChildren().iterator();

      while(var6.hasNext()) {
         Scope child = (Scope)var6.next();
         table.getChildren().addAll(child.getBranchTables());
      }

      int k = 0;

      for(Iterator var15 = fields.iterator(); var15.hasNext(); ++k) {
         FieldMemo field = (FieldMemo)var15.next();
         FieldMemo newNameField = field.copy();
         newNameField.name = field.alias;
         newNameField.alias = field.alias;
         if (!addColumns) {
            SQLExpr expr = (SQLExpr)x.getColumns().get(k);
            SQLName exprName = (SQLName)expr;
            String fieldName = exprName.getSimpleName();
            if (this.isEqual(fieldName, field.alias)) {
               newNameField.name = fieldName;
               newNameField.alias = fieldName;
            }

            newNameField.ref = expr;
            newNameField.exprs.add(expr);
         } else {
            SQLIdentifierExpr name = new SQLIdentifierExpr();
            String fieldName = newNameField.name;
            Iterator var12 = field.aliasFields.iterator();

            while(var12.hasNext()) {
               AliasField aliasField = (AliasField)var12.next();
               if (aliasField.isOutput) {
                  fieldName = aliasField.alias;
                  break;
               }
            }

            newNameField.name = fieldName;
            newNameField.alias = fieldName;
            name.setName(fieldName);
            x.getColumns().add(name);
            name.setParent(x);
            newNameField.ref = name;
            newNameField.exprs.add(name);
         }

         newNameField.table = table;
         newNameField.scope = current;
         newNameField.tables.add(table);
         newNameField.children.add(field);
         current.addField(newNameField);
      }

      this.scope.exitScope();
   }

   public boolean visit(OracleSelectQueryBlock x) {
      if (this.debug) {
         System.out.println("enter OracleSelectQueryBlock  " + x.toString());
      }

      this.enterClauseScope(x);
      this.scope.fromField = this.scope.isFromField(x);
      SQLExprTableSource xf;
      if (x.getFrom() != null) {
         this.parseView(x.getFrom(), x);
      } else {
         SQLIdentifierExpr tableName = new SQLIdentifierExpr();
         tableName.setName("dual");
         xf = new SQLExprTableSource();
         xf.setExpr((SQLExpr)tableName);
         xf.setParent(x);
         x.setFrom(xf);
      }

      SQLTableSource from = x.getFrom();
      if (from instanceof SQLExprTableSource) {
         xf = (SQLExprTableSource)from;
         SQLExpr expr = xf.getExpr();
         if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr) {
            Scope current = this.scope.getCurrent();
            SQLExpr ownerTable = expr;
            String schema;
            String name;
            Synonym syn;
            if (ownerTable instanceof SQLPropertyExpr) {
               SQLPropertyExpr propOwner = (SQLPropertyExpr)ownerTable;
               schema = propOwner.getName();
               name = propOwner.getOwnerName();
               syn = current.dialector.getSynonym(name, schema);
               if (syn != null && syn.getTableName() != null) {
                  propOwner.setOwner(syn.getTableOwner());
                  propOwner.setName(syn.getTableName());
               }
            } else if (ownerTable instanceof SQLIdentifierExpr) {
               SQLIdentifierExpr idOnwer = (SQLIdentifierExpr)ownerTable;
               schema = current.getDefaultSchema();
               name = idOnwer.getName();
               syn = current.dialector.getSynonym(schema, name);
               if (syn != null && syn.getTableName() != null) {
                  SQLPropertyExpr propertyExpr = new SQLPropertyExpr();
                  propertyExpr.setOwner(syn.getTableOwner());
                  propertyExpr.setName(syn.getTableName());
                  xf.setExpr((SQLExpr)propertyExpr);
               }
            }
         }
      }

      x.getFrom().accept(this);
      this.parsePivotTableSource(x.getFrom());
      this.parseSelectList(x);
      if (x.getWindows() != null) {
         for(int i = 0; i < x.getWindows().size(); ++i) {
            SQLWindow item = (SQLWindow)x.getWindows().get(i);
            item.accept(this);
         }
      }

      if (x.getInto() != null) {
         x.getInto().accept(this);
      }

      if (x.getWhere() != null) {
         x.getWhere().accept(this);
      }

      if (x.getStartWith() != null) {
         x.getStartWith().accept(this);
      }

      if (x.getConnectBy() != null) {
         x.getConnectBy().accept(this);
      }

      if (x.getGroupBy() != null) {
         x.getGroupBy().accept(this);
      }

      if (x.getOrderBy() != null) {
         x.getOrderBy().accept(this);
      }

      if (x.getWaitTime() != null) {
         x.getWaitTime().accept(this);
      }

      if (x.getLimit() != null) {
         x.getLimit().accept(this);
      }

      if (x.getForUpdateOf() != null) {
         this.acceptChild(x.getForUpdateOf());
      }

      return false;
   }

   private void parsePivotTableSource(SQLTableSource tableSource) {
      Object pivotOptions = tableSource.getAttribute("pivot");
      boolean isPivot = pivotOptions == null ? false : (Boolean)pivotOptions;
      if (isPivot) {
         OracleSelectPivotBase pivot = null;
         if (tableSource instanceof OracleSelectTableReference) {
            pivot = ((OracleSelectTableReference)tableSource).getPivot();
         } else if (tableSource instanceof OracleSelectJoin) {
            pivot = ((OracleSelectJoin)tableSource).getPivot();
         } else if (tableSource instanceof OracleSelectSubqueryTableSource) {
            pivot = ((OracleSelectSubqueryTableSource)tableSource).getPivot();
         }

         if (pivot != null) {
            if (pivot instanceof OracleSelectPivot) {
               tableSource.putAttribute("pivot_reverse", false);
               this.parsePivot((OracleSelectPivot)pivot);
            } else if (pivot instanceof OracleSelectUnPivot) {
               tableSource.putAttribute("pivot_reverse", true);
               this.parseUnPivot((OracleSelectUnPivot)pivot);
            }

         }
      }
   }

   private void parsePivot(OracleSelectPivot pivot) {
      Scope current = this.scope.getCurrent();
      List<OracleSelectPivot.Item> items = pivot.getItems();
      List<FieldMemo> aggColumns = new ArrayList();
      Iterator var5 = items.iterator();

      Iterator var9;
      FieldMemo memo;
      while(var5.hasNext()) {
         OracleSelectPivot.Item column = (OracleSelectPivot.Item)var5.next();
         String name = column.getAlias();
         if (name == null) {
            name = column.getExpr().toString();
         }

         List<SQLExpr> exprs = this.scope.getSubFieldExprs(column.getExpr());
         var9 = exprs.iterator();

         while(var9.hasNext()) {
            SQLExpr expr = (SQLExpr)var9.next();
            memo = this.getOrCreateFieldByName(expr.toString(), true);
            memo.ref = expr;
            memo.exprs.add(column);
            aggColumns.add(memo);
         }
      }

      current.putAttribute("pivot-agg-fields", aggColumns);
      List<SQLExpr> forColumns = pivot.getPivotFor();
      List<FieldMemo> forFields = new ArrayList();
      Iterator var15 = forColumns.iterator();

      while(var15.hasNext()) {
         SQLExpr forColumn = (SQLExpr)var15.next();
         SQLName sqlName = (SQLName)forColumn;
         String name = sqlName.getSimpleName();
         memo = this.getOrCreateFieldByName(name, true);
         memo.ref = forColumn;
         memo.exprs.add(forColumn);
         forFields.add(memo);
      }

      current.putAttribute("pivot-for-fields", forFields);
      List<OracleSelectPivot.Item> columns = pivot.getPivotIn();
      List<FieldMemo> newFields = new ArrayList();
      var9 = columns.iterator();

      while(var9.hasNext()) {
         OracleSelectPivot.Item column = (OracleSelectPivot.Item)var9.next();
         String name = column.getAlias();
         if (name == null) {
            name = column.getExpr().toString();
         }

         FieldMemo memoNew1236 = this.getOrCreateFieldByName(name, true);
         if (memoNew1236.name == null) {
            memoNew1236.name = name;
            memoNew1236.alias = memoNew1236.name;
         }

         memoNew1236.ref = column;
         memoNew1236.exprs.add(column);
         newFields.add(memoNew1236);
      }

      var9 = newFields.iterator();

      while(var9.hasNext()) {
         FieldMemo newField = (FieldMemo)var9.next();
         newField.children.addAll(aggColumns);
      }

      current.putAttribute("pivot-in-fields", newFields);
   }

   private void parseUnPivot(OracleSelectUnPivot pivot) {
      Scope current = this.scope.getCurrent();
      List<SQLExpr> items = pivot.getItems();
      List<FieldMemo> aggColumns = new ArrayList();
      Iterator var5 = items.iterator();

      while(true) {
         while(var5.hasNext()) {
            SQLExpr column = (SQLExpr)var5.next();
            boolean isPrimitive = this.scope.isPrimitive(column);
            if (isPrimitive) {
               FieldMemo memo = this.getOrCreateFieldByName(column.toString());
               memo.ref = column;
               memo.exprs.add(column);
               aggColumns.add(memo);
            } else {
               List<SQLExpr> exprs = this.scope.getSubFieldExprs(column);
               Iterator var9 = exprs.iterator();

               while(var9.hasNext()) {
                  SQLExpr expr = (SQLExpr)var9.next();
                  FieldMemo memo = this.getOrCreateFieldByName(expr.toString());
                  memo.ref = expr;
                  memo.exprs.add(column);
                  aggColumns.add(memo);
               }
            }
         }

         current.putAttribute("pivot-agg-fields", aggColumns);
         List<OracleSelectPivot.Item> columns = pivot.getPivotIn();
         List<FieldMemo> newFields = new ArrayList();
         Iterator var15 = columns.iterator();

         while(var15.hasNext()) {
            OracleSelectPivot.Item column = (OracleSelectPivot.Item)var15.next();
            String name = column.getAlias();
            if (name == null) {
               name = column.getExpr().toString();
            }

            FieldMemo memo = this.getOrCreateFieldByName(name);
            memo.ref = column;
            memo.exprs.add(column);
            newFields.add(memo);
         }

         current.putAttribute("pivot-in-fields", newFields);
         return;
      }
   }

   private List<FieldMemo> parsePivotColumns(SQLObject x, List<FieldMemo> source) {
      Scope current = this.scope.getCurrent();
      Object pivotOptions = x.getAttribute("pivot");
      if (pivotOptions == null) {
         return source;
      } else if (!(Boolean)pivotOptions) {
         return source;
      } else {
         List<FieldMemo> target = new ArrayList();
         target.addAll(source);
         boolean reverse = (Boolean)x.getAttribute("pivot_reverse");
         List<FieldMemo> aggColumns = (List)current.getAttribute("pivot-agg-fields");
         List<FieldMemo> forColumns = (List)current.getAttribute("pivot-for-fields");
         List<FieldMemo> inColumns = (List)current.getAttribute("pivot-in-fields");
         Iterator var10;
         FieldMemo column;
         Iterator iterator;
         FieldMemo z;
         if (!reverse) {
            var10 = aggColumns.iterator();

            while(var10.hasNext()) {
               column = (FieldMemo)var10.next();
               iterator = target.iterator();

               while(iterator.hasNext()) {
                  z = (FieldMemo)iterator.next();
                  if (this.isEqual(z.name, column.name)) {
                     iterator.remove();
                  }
               }
            }

            var10 = forColumns.iterator();

            while(var10.hasNext()) {
               column = (FieldMemo)var10.next();
               iterator = target.iterator();

               while(iterator.hasNext()) {
                  z = (FieldMemo)iterator.next();
                  if (this.isEqual(z.name, column.name)) {
                     iterator.remove();
                  }
               }
            }

            target.addAll(inColumns);
         } else {
            var10 = inColumns.iterator();

            while(var10.hasNext()) {
               column = (FieldMemo)var10.next();
               iterator = target.iterator();

               while(iterator.hasNext()) {
                  z = (FieldMemo)iterator.next();
                  if (this.isEqual(z.name, column.name)) {
                     iterator.remove();
                  }
               }
            }

            target.addAll(aggColumns);
         }

         return target;
      }
   }

   private FieldMemo getOrCreateFieldByName(String name) {
      return this.getOrCreateFieldByName(name, false);
   }

   private FieldMemo getOrCreateFieldByName(String name, boolean createField) {
      Scope current = this.scope.getCurrent();
      FieldMemo exists = current.getFieldByName(name);
      FieldMemo memo;
      if (exists == null) {
         memo = new FieldMemo();
         memo.name = current.dialector.wrap(name);
         memo.tables.addAll(current.getTableMap().values());
      } else {
         memo = exists.copy();
         memo.tables.addAll(exists.tables);
         memo.children.add(exists);
      }

      memo.alias = memo.name;
      if (memo.tables.size() == 1) {
         memo.table = (TableMemo)memo.tables.get(0);
      }

      memo.scope = current;
      if (createField) {
         current.addField(memo);
      }

      memo.isSelectItem = false;
      return memo;
   }

   private void parseSelectList(OracleSelectQueryBlock x) {
      Scope current = this.scope.getCurrent();
      List<SQLSelectItem> selectList = x.getSelectList();

      int i;
      for(i = 0; i < selectList.size(); ++i) {
         SQLSelectItem item = (SQLSelectItem)selectList.get(i);
         boolean isAll = this.scope.isAllColumn(item.getExpr());
         if (item.getAlias() == null && !isAll) {
            this.setAlias(item);
         }

         if (isAll && item.getAttribute("expanded") == null) {
            item.putAttribute("expanded", true);
            SQLObject parent = item.getParent();
            Owner owner = this.scope.getAllOwner(item.getExpr());
            TableMemo table = owner.alias == null ? null : current.getTable(item.getExpr());
            SQLTableSource tableSource = x.getFrom();
            boolean isSub = table != null && table.isSub || tableSource instanceof SQLSubqueryTableSource || tableSource instanceof SQLUnionQueryTableSource;
            List<FieldMemo> fields = current.expandAllColumns(table, isSub);
            fields = this.parsePivotColumns(x.getFrom(), fields);
            if (fields.size() != 0) {
               int k = 0;
               selectList.remove(i);
               String alias = x.getFrom().getAlias();
               if (alias == null) {
                  alias = owner.alias;
               }

               Iterator var15 = fields.iterator();

               while(var15.hasNext()) {
                  FieldMemo field = (FieldMemo)var15.next();
                  if (!field.name.equalsIgnoreCase("*")) {
                     TableMemo fieldTable = field.table;
                     SQLPropertyExpr propExpr = new SQLPropertyExpr();
                     propExpr.setOwner(alias == null ? fieldTable.alias : alias);
                     propExpr.setName(field.alias);
                     SQLSelectItem newItem = new SQLSelectItem();
                     newItem.setParent(parent);
                     newItem.setExpr(propExpr);
                     newItem.setAlias(field.alias);
                     field.scope = current;
                     field.isSelectItem = true;
                     field.ref = newItem;
                     field.exprs.add(propExpr);
                     selectList.add(i + k++, newItem);
                  }
               }
            }
         }
      }

      i = Integer.MIN_VALUE;

      FieldMemo field;
      for(Iterator var20 = selectList.iterator(); var20.hasNext(); field.id = i++) {
         SQLSelectItem item = (SQLSelectItem)var20.next();
         SQLExpr sqlExpr = item.getExpr();
         boolean isPrimitive = this.scope.isPrimitive(sqlExpr);
         item.putAttribute("isPrimitive", isPrimitive);
         item.accept(this);
         field = (FieldMemo)sqlExpr.getAttribute("field");
         if (sqlExpr instanceof SQLValuableExpr) {
            field.isConstant = true;
         }
      }

   }

   private SQLTableSource parseView(SQLTableSource ts, SQLObject parent) {
      if (!(ts instanceof SQLExprTableSource) && !(ts instanceof OracleSelectTableReference)) {
         if (ts instanceof SQLJoinTableSource) {
            SQLJoinTableSource jts = (SQLJoinTableSource)ts;
            SQLTableSource left = this.parseView(jts.getLeft(), jts);
            if (left != null) {
               jts.setLeft(left);
               left.setParent(jts);
            }

            SQLTableSource right = this.parseView(jts.getRight(), jts);
            if (right != null) {
               jts.setRight(right);
               right.setParent(jts);
            }
         }
      } else {
         SQLTableSource viewTableSource = this.getViewTableSource(ts);
         if (viewTableSource != null) {
            if (parent instanceof OracleSelectQueryBlock) {
               OracleSelectQueryBlock block = (OracleSelectQueryBlock)parent;
               block.setFrom(viewTableSource);
               viewTableSource.setParent(parent);
            }

            return viewTableSource;
         }
      }

      return null;
   }

   private SQLTableSource getViewTableSource(SQLTableSource ts) {
      SQLExprTableSource e = (SQLExprTableSource)ts;
      String name = e.getTableName();
      if (name == null) {
         return ts;
      } else {
         String schema = e.getSchema() == null ? this.scope.getDefaultSchema() : e.getSchema();
         SQLSelect view = this.scope.context.getView(schema.toLowerCase(), name.toLowerCase());
         if (view != null && this.scope.context.sqlType == TableStat.Mode.Select) {
            SQLSubqueryTableSource subQuery = new SQLSubqueryTableSource();
            String alias = e.getAlias() == null ? e.getTableName() : e.getAlias();
            subQuery.setAlias(alias);
            subQuery.setSelect(view.clone());
            return subQuery;
         } else {
            return null;
         }
      }
   }

   public boolean visit(SQLUnionQuery x) {
      Scope scope = this.enterClauseScope(x);
      scope.union = true;
      scope.isolated = false;
      this.visitChild(x.getRelations());

      Scope s1;
      for(Iterator var3 = ((Scope)scope).getChildren().iterator(); var3.hasNext(); s1.isolated = false) {
         s1 = (Scope)var3.next();
      }

      this.visitChild(x.getOrderBy());
      this.visitChild(x.getLimit());
      return false;
   }

   public boolean visit(SQLLateralViewTableSource x) {
      TableMemo table = this.registerTable((SQLTableSource)x);
      TableScope scope = this.enterTableScope(x);
      scope.table = table;
      scope.isolated = false;
      return true;
   }

   public boolean visit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLSubqueryTableSource  " + x.toString());
      }

      if (x.getAlias() == null) {
         x.setAlias(this.alias.aliasTable());
      }

      TableMemo table = this.registerTable((SQLTableSource)x);
      TableScope scope = this.enterTableScope(x);
      scope.isolated = false;
      scope.table = table;
      if (x.getSelect() != null) {
         x.getSelect().accept(this);
      }

      Scope s;
      for(Iterator var4 = scope.getChildren().iterator(); var4.hasNext(); s.isolated = false) {
         s = (Scope)var4.next();
      }

      return false;
   }

   public boolean visit(OracleSelectSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLSubqueryTableSource  " + x.toString());
      }

      if (x.getAlias() == null) {
         x.setAlias(this.alias.aliasTable());
      }

      x.putAttribute("pivot", x.getPivot() != null);
      TableMemo table = this.registerTable((SQLTableSource)x);
      TableScope scope = this.enterTableScope(x);
      scope.table = table;
      scope.isolated = false;
      if (x.getSelect() != null) {
         x.getSelect().accept(this);
      }

      Scope s;
      for(Iterator var4 = scope.getChildren().iterator(); var4.hasNext(); s.isolated = false) {
         s = (Scope)var4.next();
      }

      return false;
   }

   public boolean visit(OracleSelectTableReference x) {
      if (!(x.getExpr() instanceof SQLIdentifierExpr) && !(x.getExpr() instanceof SQLPropertyExpr) && !(x.getExpr() instanceof SQLDbLinkExpr)) {
         x.putAttribute("pivot", x.getPivot() != null);
         if (this.debug) {
            System.out.println("enter SQLSubqueryTableSource  " + x.toString());
         }

         if (x.getAlias() == null) {
            x.setAlias(this.alias.aliasTable());
         }

         x.putAttribute("pivot", x.getPivot() != null);
         TableMemo table = this.registerTable((SQLTableSource)x);
         TableScope scope = this.enterTableScope(x);
         scope.table = table;
         scope.isolated = false;
         return true;
      } else {
         this.registerTable((SQLTableSource)x);
         return true;
      }
   }

   public void endVisit(OracleSelectTableReference x) {
      if (!(x.getExpr() instanceof SQLIdentifierExpr) && !(x.getExpr() instanceof SQLPropertyExpr) && !(x.getExpr() instanceof SQLDbLinkExpr)) {
         if (this.debug) {
            System.out.println("exit OracleSelectTableReference  " + x);
         }

         this.scope.exitScope();
      } else if (this.debug) {
         System.out.println("end OracleSelectTableReference" + x.toString());
      }

   }

   public boolean visit(SQLJoinTableSource x) {
      this.scope.getCurrent().join = true;
      return true;
   }

   public boolean visit(OracleSelectJoin x) {
      this.scope.getCurrent().join = true;
      return true;
   }

   public boolean visit(SQLUnionQueryTableSource x) {
      TableMemo table = this.registerTable((SQLTableSource)x);
      TableScope scope = this.enterTableScope(x);
      scope.union = true;
      scope.fromField = scope.isFromField(x);
      x.putAttribute("table", table);
      x.putAttribute("scope", scope);
      scope.table = table;
      scope.isolated = false;
      this.visitChild(x.getUnion());

      Scope s1;
      for(Iterator var4 = scope.getChildren().iterator(); var4.hasNext(); s1.isolated = false) {
         s1 = (Scope)var4.next();
      }

      return false;
   }

   public boolean visit(SQLExprTableSource x) {
      this.registerTable((SQLTableSource)x);
      return true;
   }

   public boolean visit(SQLSelectItem x) {
      FieldMemo field = this.createField(x.getExpr(), x.getAlias(), true);
      field.ref = x;
      return false;
   }

   public boolean visit(SQLAggregateExpr x) {
      if (x.getMethodName().equalsIgnoreCase("LISTAGG")) {
         this.setAttr(x, "AGG-PASS", true);
      }

      return true;
   }

   public boolean visit(SQLIdentifierExpr x) {
      if (this.scope.getCurrent().isFieldState()) {
         boolean needCreate = true;
         if (x.getParent() instanceof SQLAggregateExpr) {
            needCreate = false;
            SQLAggregateExpr agg = (SQLAggregateExpr)x.getParent();
            if (agg.getMethodName().equalsIgnoreCase("LISTAGG")) {
               List<SQLExpr> arguments = agg.getArguments();
               if (arguments.size() > 0 && arguments.get(0) == x) {
                  needCreate = true;
                  x.removeAttribute("AGG-PASS");
               }
            } else {
               needCreate = true;
            }
         }

         if (needCreate && !x.containsAttribute("AGG-PASS")) {
            FieldMemo field = this.createField(x, x.getName(), false);
            x.putAttribute("field", field);
         }
      } else if (!(x.getParent() instanceof SQLTableSource) && !(x.getParent() instanceof SQLPartition) && !(x.getParent() instanceof SQLDbLinkExpr)) {
         x.putAttribute("orderBy", x.getParent() instanceof SQLSelectOrderByItem);
         FieldMemo field = this.createField(x, x.getName(), false);
         x.putAttribute("field", field);
         if (x.getParent() instanceof SQLUpdateSetItem) {
            field.isSelectItem = true;
         }
      }

      return false;
   }

   private void setAttr(SQLExpr e, String name, Object value) {
      if (e != null) {
         List<SQLObject> children = e.getChildren();
         if (children != null && children.size() > 0) {
            Iterator var5 = children.iterator();

            while(var5.hasNext()) {
               SQLObject child = (SQLObject)var5.next();
               child.putAttribute(name, value);
               if (child instanceof SQLExpr) {
                  this.setAttr((SQLExpr)child, name, value);
               }
            }
         }

      }
   }

   public boolean visit(SQLPropertyExpr x) {
      if (this.scope.getCurrent().isFieldState()) {
         this.createField(x, x.getName(), false);
      } else if (!(x.getParent() instanceof SQLTableSource) && !(x.getParent() instanceof SQLPartition)) {
         FieldMemo field = this.createField(x, x.getName(), false);
         if (x.getParent() instanceof SQLUpdateSetItem) {
            field.isSelectItem = true;
         }
      }

      return false;
   }

   public boolean visit(OracleJsonArrayAggExpr x) {
      this.visitChild(x.getExpr());
      this.visitChild(x.getOrderBy());
      return false;
   }

   public boolean visit(OracleJsonObjectExpr x) {
      Iterator var2 = x.getItems().iterator();

      while(var2.hasNext()) {
         OracleJsonObjectExpr.OracleJsonObjectExprItem item = (OracleJsonObjectExpr.OracleJsonObjectExprItem)var2.next();
         SQLExpr value = item.getValue();
         value.accept(this);
      }

      return false;
   }

   private void createSequenceTable(String name) {
      Scope current = this.scope.getCurrent();
      TableMemo table = new TableMemo();
      table.name = name;
      table.alias = name;
      table.nowName = table.alias;
      table.schema = this.scope.getDefaultSchema();
      table.sequence = true;
      table.scope = current;
      current.addTable(table);
      this.scope.context.append(table);
   }

   private FieldMemo createField(SQLExpr expr, String alias, boolean isSelectItem) {
      Scope current = this.scope.getCurrent();
      FieldMemo field = new FieldMemo();
      if (expr instanceof SQLIdentifierExpr) {
         SQLIdentifierExpr idExpr = (SQLIdentifierExpr)expr;
         boolean isOrderBy = expr.getAttribute("orderBy") != null && (Boolean)expr.getAttribute("orderBy");
         if (isOrderBy) {
            String name = current.dialector.wrap(idExpr.getSimpleName());
            FieldMemo exist = current.getFieldByAlias(name);
            if (exist != null) {
               return exist;
            }
         }

         field.name = idExpr.getName();
         field.atom = true;
         this.setField(field, alias, isSelectItem, expr);
         field.children = this.scope.getCurrent().getSubRelationFields(field);
         this.setAtom(field);
         field = current.addField(field);
      } else if (expr instanceof OracleSysdateExpr) {
         OracleSysdateExpr prop = (OracleSysdateExpr)expr;
         field.name = current.dialector.wrap(prop.toString());
         field.isConstant = true;
         this.setField(field, alias, isSelectItem, expr);
         field = current.addField(field);
      } else if (expr instanceof SQLPropertyExpr) {
         SQLPropertyExpr prop = (SQLPropertyExpr)expr;
         field.name = prop.getName();
         field.atom = true;
         this.setField(field, alias, isSelectItem, expr);
         field.children = this.scope.getCurrent().getSubRelationFields(field);
         this.setAtom(field);
         field = current.addField(field);
      } else if (expr instanceof SQLSequenceExpr) {
         SQLSequenceExpr prop = (SQLSequenceExpr)expr;
         field.name = prop.getFunction().toString();
         this.createSequenceTable(prop.getSequence().toString());
         this.setField(field, alias, isSelectItem, expr);
         field.children = this.scope.getCurrent().getSubRelationFields(field);
         field = current.addField(field);
      } else if (expr instanceof SQLValuableExpr) {
         field.name = alias;
         field.isConstant = true;
         this.setField(field, alias, isSelectItem, expr);
         field = current.addField(field);
      } else {
         alias = current.dialector.wrap(alias);
         field.name = alias;
         field.alias = alias;
         field.complex = true;
         field.isSelectItem = isSelectItem;
         field.ref = expr;
         AliasField aliasField;
         if (expr instanceof SQLSelectItem) {
            field.exprs.add(((SQLSelectItem)expr).getExpr());
            aliasField = new AliasField();
            aliasField.alias = alias;
            aliasField.field = field;
            aliasField.expr = expr;
            aliasField.isOutput = true;
            aliasField.scope = this.scope.getCurrent();
         } else {
            field.exprs.add(expr);
            aliasField = new AliasField();
            aliasField.alias = alias;
            aliasField.field = field;
            aliasField.expr = expr;
            aliasField.isOutput = true;
            aliasField.scope = this.scope.getCurrent();
         }

         current.openFieldState();
         expr.accept(this);
         current.closeFieldState();
         List<SQLExpr> exprs = current.getSubFieldExprs(expr);
         List<FieldMemo> subFields = new ArrayList();
         current.getFieldsByExprs(exprs, subFields);
         List<TableMemo> tables = new ArrayList();
         List<FieldMemo> children = new ArrayList();
         Set<String> names = new HashSet();
         boolean isPrimitive = this.scope.isPrimitive(expr);
         if (!isPrimitive) {
            current.getSubBranchFields(subFields);
         }

         if (subFields.size() <= 0) {
            tables.addAll(current.getBranchTables());
         } else {
            Iterator var12 = subFields.iterator();

            label80:
            while(true) {
               while(true) {
                  if (!var12.hasNext()) {
                     break label80;
                  }

                  FieldMemo subField = (FieldMemo)var12.next();
                  if (!names.contains(subField.getUniqueName())) {
                     children.add(subField);
                     names.add(subField.getUniqueName());
                  }

                  if (subField.table != null && !names.contains(subField.table.getQualifiedName())) {
                     tables.add(subField.table);
                     names.add(subField.table.getQualifiedName());
                  } else if (subField.tables.size() > 0) {
                     Iterator var14 = subField.tables.iterator();

                     while(var14.hasNext()) {
                        TableMemo table = (TableMemo)var14.next();
                        if (!names.contains(table.getQualifiedName())) {
                           tables.add(table);
                           names.add(table.getQualifiedName());
                        }
                     }
                  }
               }
            }
         }

         field.tables = tables;
         if (tables.size() == 1) {
            field.table = (TableMemo)tables.get(0);
         }

         field.children = children;
         this.setAtom(field);
         current.addField(field);
      }

      expr.putAttribute("field", field);
      return field;
   }

   private void setAtom(FieldMemo field) {
      if (field.children.size() != 0) {
         Set<String> fdNames = field.tableNames();
         boolean found = false;
         Iterator var4 = field.children.iterator();

         while(var4.hasNext()) {
            FieldMemo child = (FieldMemo)var4.next();
            if (this.isEqual(field.name, child.alias)) {
               Set<String> cdNames = child.tableNames();
               cdNames.retainAll(fdNames);
               if (cdNames.size() > 0) {
                  found = true;
               }
            }
         }

         if (!found) {
            field.atom = false;
         }

      }
   }

   private void setField(FieldMemo field, String alias, boolean isSelectItem, SQLExpr expr) {
      Scope current = this.scope.getCurrent();
      field.alias = alias == null ? field.name : alias;
      field.alias = current.dialector.wrap(field.alias);
      field.name = current.dialector.wrap(field.name);
      field.isSelectItem = isSelectItem;
      field.ref = expr;
      if (expr instanceof SQLSequenceExpr) {
         field.table = this.scope.getCurrent().getTable(((SQLSequenceExpr)expr).getSequence());
      } else {
         field.table = this.scope.getCurrent().getTable(expr);
      }

      field.tables.add(field.table);
      field.exprs.add(expr);
      AliasField aliasField = new AliasField();
      aliasField.alias = alias;
      aliasField.field = field;
      aliasField.expr = expr;
      aliasField.isOutput = isSelectItem;
      aliasField.scope = this.scope.getCurrent();
   }

   private TableMemo registerTable(SQLTableSource x) {
      Scope current = this.scope.getCurrent();
      TableMemo table;
      if (x instanceof SQLExprTableSource) {
         SQLExprTableSource exprTableSource = (SQLExprTableSource)x;
         table = new TableMemo(x);
         SQLExprTableSource tableSource = (SQLExprTableSource)x;
         String tableName = current.dialector.wrap(tableSource.getTableName());
         String schemaName = current.dialector.wrap(tableSource.getSchema() == null ? this.scope.getDefaultSchema() : tableSource.getSchema());
         table.name = tableName;
         table.alias = current.dialector.wrap(tableSource.getAlias() == null ? table.name : tableSource.getAlias());
         table.nowName = table.alias;
         table.schema = schemaName;
         if (table.name == null) {
            table.name = table.alias;
         }

         if (table.name.equals("*") && exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLPropertyExpr) {
            return null;
         } else {
            if (table.name == null && table.alias != null) {
               table.name = table.alias;
            }

            if (exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLMethodInvokeExpr) {
               table.isSub = true;
            }

            if (exprTableSource.getExpr() != null && exprTableSource.getExpr() instanceof SQLDbLinkExpr) {
               SQLDbLinkExpr link = (SQLDbLinkExpr)exprTableSource.getExpr();
               Owner owner = this.scope.getOwner(link.getExpr());
               table.name = current.dialector.wrap(owner.table);
               if (owner.schema != null) {
                  table.schema = current.dialector.wrap(owner.schema);
               }

               if (link.getExpr().getParent() == null) {
                  link.getExpr().setParent(link);
               }

               table.dbLink = exprTableSource.getExpr().toString();
            }

            if (x instanceof OracleSelectTableReference) {
               OracleSelectTableReference ref = (OracleSelectTableReference)x;
               if (ref.getExpr() != null && ref.getExpr() instanceof SQLMethodInvokeExpr) {
                  SQLMethodInvokeExpr method = (SQLMethodInvokeExpr)ref.getExpr();
                  if (method.getArguments().size() == 1 && method.getArguments().get(0) instanceof SQLQueryExpr) {
                     if (table.name == null) {
                        String aliasTableName = current.dialector.wrap(this.alias.aliasTable());
                        ref.setAlias(aliasTableName);
                        table.name = aliasTableName;
                        if (table.alias == null) {
                           table.alias = table.name;
                        }

                        table.isSub = true;
                     }

                     this.setTableRelation(table);
                     x.putAttribute("table", table);
                     return table;
                  }
               }
            }

            TableMemo refTable = current.getParentTable(schemaName, tableName);
            if (refTable != null) {
               table.schema = refTable.schema;
               table.topTable = true;
               table.scope = current;
               table.refTable = refTable;
               table.getChildren().add(refTable);
               current.addTable(table);
               table.topTable = refTable.topTable;
               return refTable;
            } else {
               boolean isFunction = false;
               SQLExpr expr = ((SQLExprTableSource)x).getExpr();
               isFunction = expr instanceof SQLMethodInvokeExpr;
               this.setTableRelation(table);
               table.system = this.scope.dialector.isSystemTable(table.name);
               if (!table.isSub && !isFunction && !table.system) {
                  this.scope.context.append(table);
               }

               x.putAttribute("table", table);
               return table;
            }
         }
      } else if (x instanceof SQLSubqueryTableSource) {
         SQLSubqueryTableSource tableSource = (SQLSubqueryTableSource)x;
         table = new TableMemo(x);
         table.name = current.dialector.wrap(tableSource.getAlias());
         table.alias = current.dialector.wrap(tableSource.getAlias());
         table.nowName = table.name;
         table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
         table.isSub = true;
         this.setTableRelation(table);
         x.putAttribute("table", table);
         return table;
      } else if (x instanceof SQLLateralViewTableSource) {
         SQLLateralViewTableSource tableSource = (SQLLateralViewTableSource)x;
         table = new TableMemo(x);
         table.name = current.dialector.wrap(tableSource.getAlias());
         table.alias = current.dialector.wrap(tableSource.getAlias());
         table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
         table.isSub = true;
         this.setTableRelation(table);
         x.putAttribute("table", table);
         return table;
      } else if (x instanceof SQLUnionQueryTableSource) {
         SQLUnionQueryTableSource tableSource = (SQLUnionQueryTableSource)x;
         table = new TableMemo(x);
         table.name = current.dialector.wrap(tableSource.getAlias());
         table.alias = table.name;
         table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
         table.nowName = table.name;
         table.isSub = true;
         this.setTableRelation(table);
         x.putAttribute("table", table);
         return table;
      } else {
         return null;
      }
   }

   private TableMemo registerTable(SQLWithSubqueryClause.Entry x) {
      Scope current = this.scope.getCurrent();
      TableMemo table = new TableMemo(x);
      table.name = current.dialector.wrap(x.getAlias());
      table.nowName = current.dialector.wrap(table.name);
      table.alias = table.name;
      table.schema = current.dialector.wrap(this.scope.getDefaultSchema());
      table.isSub = true;
      table.topTable = true;
      this.setTableRelation(table);
      return table;
   }

   private void setTableRelation(TableMemo table) {
      Scope current = this.scope.getCurrent();
      table.name = current.dialector.wrap(table.name);
      table.alias = current.dialector.wrap(table.alias);
      table.schema = current.dialector.wrap(table.schema);
      table.scope = current;
      current.addTable(table);
      TableScope tableScope = current.getNearestParentTableScope();
      if (tableScope != null) {
         TableMemo parentTable = tableScope.table;
         if (parentTable != null) {
            parentTable.getChildren().add(table);
            if (table.isSub) {
               parentTable.isSub = true;
            }
         }
      }

   }

   private TableScope enterTableScope(SQLTableSource x) {
      TableScope ts = new TableScope();
      ts.ref = x;
      ts.alias = ts.name = x.getAlias();
      this.scope.enterScope((Scope)ts);
      return ts;
   }

   private ClauseScope enterClauseScope(SQLObject x) {
      ClauseScope clauseScope = new ClauseScope();
      clauseScope.ref = x;
      this.scope.enterScope((Scope)clauseScope);
      return clauseScope;
   }

   private void setAlias(SQLSelectItem x) {
      if (x.getAlias() == null) {
         SQLExpr e = x.getExpr();
         String name;
         if (e instanceof SQLIdentifierExpr) {
            name = ((SQLIdentifierExpr)e).getName();
            if (!name.toUpperCase().equals("ROWID")) {
               x.setAlias(name);
            }
         } else if (e instanceof SQLPropertyExpr) {
            name = ((SQLPropertyExpr)e).getName();
            if (!name.toUpperCase().equals("ROWID")) {
               x.setAlias(name);
            }
         } else if (e instanceof SQLNumericLiteralExpr) {
            x.setAlias("'" + e + "'");
         } else {
            x.setAlias(this.scope.dialector.wrap(e.toString()));
         }

      }
   }

   public void endVisit(SQLMethodInvokeExpr x) {
      if ("LATERAL".equalsIgnoreCase(x.getMethodName())) {
         this.scope.getCurrent().isolated = false;

         Scope s;
         for(Iterator var2 = this.scope.getCurrent().getChildren().iterator(); var2.hasNext(); s.isolated = false) {
            s = (Scope)var2.next();
         }
      }

   }
}
