package com.metro.auth.platform.metrointerface;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.Pagination;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformDepartment;
import com.metro.auth.platform.domain.auth.User;
import com.metro.auth.platform.domain.dto.*;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.http.HttpResult;
import com.metro.auth.platform.outlineapi.PlatformUrlManager;
import com.metro.auth.platform.service.PlatformDepartmentService;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JSONUtil;
import com.metro.auth.platform.utils.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.apache.ibatis.annotations.Delete;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
@Slf4j
@RestController
@RequestMapping("/external")
public class ExternalController {

    @Value("${jwt.header}")
    private String tokenHeader;

    @Resource
    private HttpAPIService httpAPIService;
    @Resource
    private PlatformDepartmentService platformDepartmentService;
    /**
     * 接口1：
     * 功能描述: <br>获取栏目信息集合
     * 〈〉
     * @Author: lx
     */
    @GetMapping("/noticemanage/api/column/{userid}")
    public ResultJson queryColumnList(@PathVariable String userid, HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_COLUMN_URL);

        JSONObject result = null;
        try {
            result = httpAPIService.doPostHeader(url, "", token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(result);
    }

    /**
     * 接口2：
     * 功能描述: <br>获取公告信息集合
     * 〈〉
     * @Author: lx
     */
    @GetMapping("/noticemanage/api/activiti/{userid}")
    public ResultJson queryActivitiList(NoticeManageActivitiDTO noticeManageActivitiDTO, @PathVariable String userid, HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_ACTIVITI_URL);

        String result = null;
        try {
            result = this.doPost(url, noticeManageActivitiDTO, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }
    @GetMapping("/law/list/{userid}")
    public ResultJson lawlisttoindex(LawPolicylistDTO lawPolicylistDTO, @PathVariable String userid, HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_LAW_List_URL);

        String result = null;
        try {
            result = this.doPost_law(url, lawPolicylistDTO, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }

    /**
     * 接口3：
     * 功能描述: <br>获取公告详情信息
     * 〈〉
     * @Author: lx
     */
    @GetMapping("/noticemanage/api/activiti/detail/{processInstanId}/{userid}")
    public ResultJson queryActivitiDetail(@PathVariable String processInstanId, @PathVariable String userid, HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_ACTIVITI_DETAIL_URL);
        String result = null;
        try {
            result = httpAPIService.doGetHeader(url + processInstanId, token);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }

    /**
     * 评论列表
     * @param noticeId
     * @param noticeManageActivitiDTO
     * @param userid
     * @return
     */
    @PostMapping("/noticemanage/api/comments/page/{noticeId}/{userid}")
    public ResultJson queryCommentsPage(@PathVariable String noticeId, @RequestBody NoticeManageActivitiDTO noticeManageActivitiDTO, @PathVariable String userid, HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_COMMENTS_PAGE_URL);

        String result = null;
        try {
            result = this.doPost(url+"/"+noticeId, noticeManageActivitiDTO, token);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }
    /**
     * 评论列表(分页) 2019-10-28
     * @param noticeId
     * @param noticeManageActivitiDTO
     * @param userid
     * @return
     */
    @GetMapping("/noticemanage/api/comments/pagelist/{noticeId}/{userid}")
    public ResultJson queryCommentsPageList(@PathVariable String noticeId,NoticeManageActivitiDTO noticeManageActivitiDTO, int pageIndex, int pageSize,@PathVariable String userid, HttpServletRequest request){
        int p= Integer.parseInt(noticeManageActivitiDTO.getPageIndex());
        int b= Integer.parseInt(noticeManageActivitiDTO.getPageSize());
        noticeManageActivitiDTO.setPageSize(String.valueOf(b));
        noticeManageActivitiDTO.setPageIndex(String.valueOf((p-1)*b));
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_COMMENTS_PAGE_URL);
        String token = request.getHeader("Auth3");
        String result = null;
        try {
            result = this.doPost(url+"/"+noticeId, noticeManageActivitiDTO, token);
            log.info("调用公告列表接口返回结果为："+result+" pageSize="+noticeManageActivitiDTO.getPageSize()+" --- "+noticeManageActivitiDTO.getPageIndex());
            JSONObject json = JSONUtil.getJSONFromString(result);
            int resultCode = json.getIntValue("resultCode");
            String resultMsg = json.getString("resultMs");
            int dataCount = json.getIntValue("dataCount");
            List<CommentsDTO> list  = new ArrayList<CommentsDTO>();


            if (resultCode==1){
                JSONArray jsonArray =json.getJSONArray("obj");
                if (jsonArray!=null&&jsonArray.size()>0){
                    jsonArray.stream().forEach(jsons->{

                        JSONObject jsonObject = (JSONObject) jsons;
                        CommentsDTO commentsDTO = new CommentsDTO();
                        commentsDTO.setId(jsonObject.getString("id"));
                        commentsDTO.setCreateby(jsonObject.getString("createby"));
                        commentsDTO.setCreatetime(jsonObject.getString("createtime"));
                        commentsDTO.setUpdateby(jsonObject.getString("updateby"));
                        commentsDTO.setUpdatetime(jsonObject.getString("updatetime"));
                        commentsDTO.setIsdelete(jsonObject.getString("isdelete"));
                        commentsDTO.setNoticeid(jsonObject.getString("noticeid"));
                        commentsDTO.setConten(jsonObject.getString("conten"));
                        commentsDTO.setIndexinfo(jsonObject.getString("indexinfo"));
                        JSONObject baseinfoUserjson =(JSONObject)( jsonObject.get("baseinfoUser")) ;
                        BaseinfoUserDTO baseinfoUserDTO=new BaseinfoUserDTO();
                        if (baseinfoUserjson!=null){
                            baseinfoUserDTO.setAccount(baseinfoUserjson.getString("account"));
                            baseinfoUserDTO.setId(baseinfoUserjson.getString("id"));
                            baseinfoUserDTO.setAddTime(baseinfoUserjson.getString("addTime"));
                            baseinfoUserDTO.setBaseId(baseinfoUserjson.getString("baseId"));
                            baseinfoUserDTO.setPosition(baseinfoUserjson.getString("position"));
                            baseinfoUserDTO.setUpdateTime(baseinfoUserjson.getString("updateTime"));
                            baseinfoUserDTO.setUsername(baseinfoUserjson.getString("username"));
                            baseinfoUserDTO.setNickname(baseinfoUserjson.getString("nickname"));
                            baseinfoUserDTO.setIdentity(baseinfoUserjson.getString("identity"));
                            baseinfoUserDTO.setAvatar(baseinfoUserjson.getString("avatar"));
                        }
                        commentsDTO.setBaseinfoUserDTO(baseinfoUserDTO);
                        list.add(commentsDTO);
                    });
                }
            }
            Pagination pagination = new Pagination(list,new Long(dataCount),pageSize,pageIndex);
            return ResultJson.ok(pagination);
        } catch (Exception e) {
            e.printStackTrace();
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }

    }
    /**
     * 法律分类接口
     * /api/column_manage/firstColumnList 接口
     */
    @GetMapping("/lawtexttype")
    public ResultJson lawtexttype(LawPolicylistDTO lawPolicylistDTO, HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_LAW_TYPE_URL);
        String result = null;
        try {
            result = this.doPost_lawtype(url, lawPolicylistDTO, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }
    /**
     *
     * 接口4-1：
     * 政策法规分页获取信息
     * @param  lawPolicylistDTO
     * @param pageIndex
     * @param pageSize
     * @return
     * @throws IOException
     */
    @GetMapping("/pageList/law/{userid}")
    public ResultJson pagedlawlist(LawPolicylistDTO lawPolicylistDTO, int pageIndex, int pageSize, @PathVariable String userid, HttpServletRequest request){
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_LAW_List_URL);
        String token = request.getHeader(tokenHeader);
        String result = null;
        int p= pageIndex;
        int b=pageSize;
        lawPolicylistDTO.setMax(pageSize);
        lawPolicylistDTO.setStart((p-1)*b);
        try {
            result = this.doPost_law(url, lawPolicylistDTO, token);
            JSONObject json = JSONUtil.getJSONFromString(result);
            int resultCode = json.getIntValue("resultCode");
            String resultMsg = json.getString("resultMs");
            int dataCount = json.getIntValue("dataCount");
            List<LawDTO> list  = new ArrayList<LawDTO>();

            if (resultCode==1){
                JSONArray jsonArray =json.getJSONArray("obj");
                if (jsonArray!=null&&jsonArray.size()>0){
                    jsonArray.stream().forEach(jsons->{
                        JSONObject jsonObject = (JSONObject) jsons;
                        LawDTO fileDownDTO = new LawDTO();
                        fileDownDTO.setId(jsonObject.getString("id"));
                        fileDownDTO.setCreatetime(jsonObject.getString("createtime"));
                        fileDownDTO.setStarttime(jsonObject.getString("starttime"));
                        fileDownDTO.setPublishtime(jsonObject.getString("publishtime"));
                        fileDownDTO.setEndtime(jsonObject.getString("endtime"));
                        fileDownDTO.setTexttype(jsonObject.getString("texttype"));
                        fileDownDTO.setTextclass(jsonObject.getString("textclass"));
                        fileDownDTO.setTargetdept(jsonObject.getString("targetdept"));
                        fileDownDTO.setPolicyname(jsonObject.getString("policyname"));
                        fileDownDTO.setPolicyno(jsonObject.getString("policyno"));
                        fileDownDTO.setState(jsonObject.getString("state"));
                        fileDownDTO.setProinstanid(jsonObject.getString("proinstanid"));
                        fileDownDTO.setFinance(jsonObject.getString("finance"));
                        fileDownDTO.setPolicycontent(jsonObject.getString("policycontent"));
                        fileDownDTO.setWatermarks(jsonObject.getString("watermarks"));
                        fileDownDTO.setCollect(jsonObject.getString("collect"));
                        fileDownDTO.setApplaykind(jsonObject.getString("applaykind"));

                        fileDownDTO.setParentid(jsonObject.getString("parentid"));
                        fileDownDTO.setColumnkind(jsonObject.getString("columnkind"));
                        fileDownDTO.setSecondkind(jsonObject.getString("secondkind"));
                        fileDownDTO.setUseable(jsonObject.getString("useable"));
                        fileDownDTO.setListFileInfo(jsonObject.getString("listFileInfo"));
                        fileDownDTO.setParentPolicy(jsonObject.getString("parentPolicy"));

                        fileDownDTO.setColumnFirst(jsonObject.getString("columnFirst"));
                        fileDownDTO.setColumnSecond(jsonObject.getString("columnSecond"));
                        fileDownDTO.setListDept(jsonObject.getString("listDept"));
                        list.add(fileDownDTO);
                    });
                }
            }
            Pagination pagination = new Pagination(list,new Long(dataCount),pageSize,pageIndex);
            return ResultJson.ok(pagination);
        } catch (Exception e) {
            e.printStackTrace();
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);

        }
    }

    /**
     * 接口4：
     * 分页获取信息
     * @param  noticeManageActivitiDTO
     * @param pageIndex
     * @param pageSize
     * @return
     * @throws IOException
     */
    @GetMapping("/pageList/{userid}")
    public ResultJson pagedlist(NoticeManageActivitiDTO noticeManageActivitiDTO, int pageIndex,int pageSize, @PathVariable String userid,HttpServletRequest request){
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_COLUMN_List_URL);
        String result = null;
        String token = request.getHeader("Auth3");
        int p= Integer.parseInt(noticeManageActivitiDTO.getPageIndex());
        int b= Integer.parseInt(noticeManageActivitiDTO.getPageSize());
        noticeManageActivitiDTO.setPageSize(String.valueOf(b));
        noticeManageActivitiDTO.setPageIndex(String.valueOf((p-1)*b));

        try {
            result = this.doPost(url, noticeManageActivitiDTO, token);
            JSONObject json = JSONUtil.getJSONFromString(result);
            int resultCode = json.getIntValue("resultCode");
            String resultMsg = json.getString("resultMs");
            int dataCount = json.getIntValue("dataCount");
            List<FileDownDTO> list  = new ArrayList<FileDownDTO>();


            if (resultCode==1){
                JSONArray jsonArray =json.getJSONArray("obj");
                if (jsonArray!=null&&jsonArray.size()>0){
                    jsonArray.stream().forEach(jsons->{
                        List<FileDownFileDTO> filelist  = new ArrayList<FileDownFileDTO>();
                        JSONObject jsonObject = (JSONObject) jsons;
                        FileDownDTO fileDownDTO = new FileDownDTO();
                        fileDownDTO.setId(jsonObject.getString("proceIntanId"));
                        fileDownDTO.setAuthor(jsonObject.getString("author"));
                        fileDownDTO.setCanUpdatePublishTime(jsonObject.getString("canUpdatePublishTime"));
                        fileDownDTO.setCreateTime(jsonObject.getString("createTime"));
                        fileDownDTO.setColumnId(jsonObject.getString("columnId"));
                        fileDownDTO.setColumnInfo(jsonObject.getString("columnInfo"));
                        fileDownDTO.setCommentNum(jsonObject.getString("commentNum"));
                        fileDownDTO.setCreateByCom(jsonObject.getString("createByCom"));
                        JSONArray coverFilejsonArray =json.getJSONArray("coverFile");
                        JSONObject coverFilejson =(JSONObject)( jsonObject.get("coverFile")) ;
                         if (coverFilejson!=null){
                             String filepath=coverFilejson.getString("filePath");
                             if(filepath==null) {
                                 fileDownDTO.setFilepath("");
                             } else if (filepath.contains("http")) {
                                 fileDownDTO.setFilepath(coverFilejson.getString("filePath"));
                             }else {
                                 fileDownDTO.setFilepath(PlatformUrlManager.API_IMGURL + filepath);
                             }
                         }else{
                             fileDownDTO.setFilepath("");
                         }
                        fileDownDTO.setFilelist(filelist);
                        fileDownDTO.setImgpath(jsonObject.getString("imgpath"));
                        fileDownDTO.setListNoticeScope(jsonObject.getString("listNoticeScope"));
                        fileDownDTO.setMemo(jsonObject.getString("memo"));
                        fileDownDTO.setPublishTime(jsonObject.getString("publishTime"));
                        fileDownDTO.setReaderNum(jsonObject.getString("readerNum"));
                        fileDownDTO.setRed(jsonObject.getString("red"));
                        fileDownDTO.setThumbsNum(jsonObject.getString("thumbsNum"));
                        fileDownDTO.setTitle(jsonObject.getString("title"));
                        fileDownDTO.setContent(jsonObject.getString("content"));
                        list.add(fileDownDTO);
                    });
                }
            }
            Pagination pagination = new Pagination(list,new Long(dataCount),pageSize,pageIndex);
            return ResultJson.ok(pagination);
        } catch (Exception e) {
            e.printStackTrace();
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);

        }
    }

    /**
     * 添加评论
     * @param noticeManageActivitiDTO
     * @param userid
     * @return
     */
    @PostMapping("/noticemanage/api/comments/add/{userid}")
    public ResultJson addComments(@RequestBody NoticeManageActivitiDTO noticeManageActivitiDTO, @PathVariable String userid,HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_COMMENTS_ADD_URL);

        String result = null;
        try {
            result = this.doPost(url, noticeManageActivitiDTO, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }
    /**
     * 删除评论
     * @param noticeManageActivitiDTO
     * @param commentId
     * @return
     */
    @PostMapping("/noticemanage/api/comments/delete/{commentId}")
    public ResultJson deleteComments(@RequestBody NoticeManageActivitiDTO noticeManageActivitiDTO, @PathVariable String commentId,HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_COMMENTS_DEL_URL);

        String result = null;
        try {
            result = this.doPost(url+"/"+commentId, noticeManageActivitiDTO, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }
    /**
     * 已读
     * @param noticeId
     * @param noticeManageActivitiDTO
     * @param userid
     * @return
     */
    @PostMapping("/noticemanage/api/reader/page/{noticeId}/{userid}")
    public ResultJson queryReaderPage(@PathVariable String noticeId,@RequestBody NoticeManageActivitiDTO noticeManageActivitiDTO, @PathVariable String userid,HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_READER_PAGE_URL);

        String result = null;
        try {
            result = this.doPost(url+"/"+noticeId, noticeManageActivitiDTO, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }

    /**
     * 点赞
     * @param noticeId
     * @param userid
     * @return
     */
    @GetMapping("/noticemanage/api/thumbs/add/{noticeId}/{userid}")
    public ResultJson addThumbs(@PathVariable String noticeId,@PathVariable String userid,HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_HUMBS_ADD_URL);

        String result = null;
        try {
            result = httpAPIService.doGetHeader(url+"/"+noticeId, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }

    /**
     * 取消点赞
     * @param noticeId
     * @param userid
     * @return
     */
    @GetMapping("/noticemanage/api/thumbs/del/{noticeId}/{userid}")
    public ResultJson delThumbs(@PathVariable String noticeId,@PathVariable String userid,HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_HUMBS_DEL_URL);

        String result = null;
        try {
            result = httpAPIService.doGetHeader(url+"/"+noticeId, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }

    /**
     * 点赞信息
     * @param noticeId
     * @param userid
     * @return
     */
    @GetMapping("/noticemanage/api/thumbs/info/{noticeId}/{userid}")
    public ResultJson infoThumbs(@PathVariable String noticeId,@PathVariable String userid,HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_HUMBS_INFO_URL);

        String result = null;
        try {
            result = httpAPIService.doGetHeader(url+"/"+noticeId, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }

    @GetMapping("/noticemanage/api/fileinfo/file/{fileId}/{userid}")
    public ResultJson getfileinfo(@PathVariable String fileId,@PathVariable String userid,HttpServletRequest request){
        String token = request.getHeader("Auth3");
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_FILEINFO_FILE_URL);

        String result = null;
        try {
            result = httpAPIService.doGetHeader(url+"/"+fileId, token);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }
    /**
     * 法律详情
     */
    @GetMapping("/law/{processInstanId}")
    public  ResultJson getLawDetail(@PathVariable String processInstanId,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.API_LAW_DETAIL_URL);
        String result = null;
        try {
            result = httpAPIService.doGetHeader(url+processInstanId,token);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ResultJson.ok(JSONObject.parseObject(result));
    }
    private String doPost_lawtype(String httpurl, LawPolicylistDTO lawPolicylistDTO, String userid) throws IOException {
        StringBuffer sbf = new StringBuffer();
        String strRead = null;
        URL url = new URL(httpurl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");//请求post方式
        connection.setDoInput(true);
        connection.setDoOutput(true);
        //header内的的参数在这里set    connection.setRequestProperty("健, "值");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("token", userid);
        connection.connect();
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
        //body参数在这里put到JSONObject中
        JSONObject parm = new JSONObject();
        Map<String, Object> pagemap = new HashMap<>();
        parm.put("firstColumnAbbr","");
        parm.put("firstColumnName", "");
        pagemap.put("max", lawPolicylistDTO.getMax());
        pagemap.put("first", lawPolicylistDTO.getFirst());
        parm.put("page", pagemap);
        writer.write(parm.toString());
        writer.flush();
        InputStream is = connection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        while ((strRead = reader.readLine()) != null) {
            sbf.append(strRead);
            sbf.append("\r\n");
        }
        reader.close();
        connection.disconnect();
        String results = sbf.toString();
        return results;
    }
    private String doPost_law(String httpurl, LawPolicylistDTO lawPolicylistDTO, String userid) throws IOException {
        StringBuffer sbf = new StringBuffer();
        String strRead = null;
        URL url = new URL(httpurl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");//请求post方式
        connection.setDoInput(true);
        connection.setDoOutput(true);
        //header内的的参数在这里set    connection.setRequestProperty("健, "值");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("token", userid);
        connection.connect();
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
        //body参数在这里put到JSONObject中
        JSONObject parm = new JSONObject();
        Map<String, Object> pagemap = new HashMap<>();

//            parm.put("max", lawPolicylistDTO.getMax());
            parm.put("policyname", lawPolicylistDTO.getPolicyname());
            parm.put("policyno", lawPolicylistDTO.getPolicyno());
//            parm.put("first", lawPolicylistDTO.getStart());
            parm.put("textclass", lawPolicylistDTO.getTextclass());
            parm.put("texttype", lawPolicylistDTO.getTexttype());
        parm.put("center", lawPolicylistDTO.getCenter());
        pagemap.put("max", lawPolicylistDTO.getMax());
        pagemap.put("first", lawPolicylistDTO.getStart());

        parm.put("page", pagemap);
        writer.write(parm.toString());
        writer.flush();
        InputStream is = connection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        while ((strRead = reader.readLine()) != null) {
            sbf.append(strRead);
            sbf.append("\r\n");
        }
        reader.close();
        connection.disconnect();
        String results = sbf.toString();
        return results;
    }
    private String doPost(String httpurl, NoticeManageActivitiDTO noticeManageActivitiDTO, String userid) throws IOException {
        StringBuffer sbf = new StringBuffer();
        String strRead = null;
        URL url = new URL(httpurl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");//请求post方式
        connection.setDoInput(true);
        connection.setDoOutput(true);
        //header内的的参数在这里set    connection.setRequestProperty("健, "值");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("token", userid);
        connection.connect();
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);
        //body参数在这里put到JSONObject中
        JSONObject parm = new JSONObject();
        Map<String, Object> pagemap = new HashMap<>();

        if(noticeManageActivitiDTO.getBaseGroupIds()!=null&&!"".equals(noticeManageActivitiDTO.getBaseGroupIds())) {
            parm.put("baseGroupIds", noticeManageActivitiDTO.getBaseGroupIds());
        }
        if(noticeManageActivitiDTO.getBaseUserIds()!=null&&!"".equals(noticeManageActivitiDTO.getBaseUserIds())) {
            parm.put("baseUserIds", noticeManageActivitiDTO.getBaseUserIds());
        }
        if(noticeManageActivitiDTO.getColumnId()!=null&&!"".equals(noticeManageActivitiDTO.getColumnId())) {
            parm.put("columnId", noticeManageActivitiDTO.getColumnId());
        }else{
            parm.put("columnId", "");
        }
        if(noticeManageActivitiDTO.getNoticeid()!=null&&!"".equals(noticeManageActivitiDTO.getNoticeid())){
            parm.put("noticeid", noticeManageActivitiDTO.getNoticeid());
        }
        if(noticeManageActivitiDTO.getConten()!=null&&!"".equals(noticeManageActivitiDTO.getConten())){
            parm.put("conten", noticeManageActivitiDTO.getConten());
        }
        if(noticeManageActivitiDTO.getSortRules()!=null&&!"".equals(noticeManageActivitiDTO.getSortRules())){
            parm.put("sortRules", noticeManageActivitiDTO.getSortRules());
        }
        if(noticeManageActivitiDTO.getSearchCondition()!=null&&!"".equals(noticeManageActivitiDTO.getSearchCondition())){
            parm.put("searchCondition", noticeManageActivitiDTO.getSearchCondition());
        }else{
            parm.put("searchCondition", "");
        }
        parm.put("max", noticeManageActivitiDTO.getPageSize());
        parm.put("first", noticeManageActivitiDTO.getPageIndex());
        pagemap.put("max", noticeManageActivitiDTO.getPageSize());
        pagemap.put("first", noticeManageActivitiDTO.getPageIndex());
        Map<String, Object> pageConditionmap = new HashMap<>();
        pageConditionmap.put("max", noticeManageActivitiDTO.getPageSize());
        pageConditionmap.put("first", noticeManageActivitiDTO.getPageIndex());
        parm.put("pageCondition", pageConditionmap);
        parm.put("page", pagemap);
        parm.put("endTime","");
        parm.put("policyname","");
        parm.put("policyno","");
        parm.put("startTime","");
        parm.put("textclass","");
        parm.put("texttype","");

        writer.write(parm.toString());
        writer.flush();
        InputStream is = connection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        while ((strRead = reader.readLine()) != null) {
            sbf.append(strRead);
            sbf.append("\r\n");
        }
        reader.close();
        connection.disconnect();
        String results = sbf.toString();
        return results;
    }

}
