-- 添加分组菜单
INSERT INTO `platform_auth`.`platform_sys_menu` (`id`, `parentId`, `path`, `icon`, `title`, `name`, `leftMemu`,
                                                 `functionCode`, `isLock`, `sort`, `webtype`)
VALUES ('0452516c476b497d9fa0efd615e1434e', '7', '/platformapplicationsGroupManager', 'group_work', '应用分组管理',
        'groupManager', 'true', 'platformapplicationsGroupManager', NULL, '111', NULL);

INSERT INTO `platform_auth`.`platform_sys_menu` (`id`, `parentId`, `path`, `icon`, `title`, `name`, `leftMemu`,
                                                 `functionCode`, `isLock`, `sort`, `webtype`)
VALUES ('3d0f4e8e51af4bc494193a31a10cb3d3', '7', '/metroworkmenu', 'list', '地铁工作菜单管理', 'metroworkmenuManager',
        'true', 'metroworkmenu', NULL, '8', NULL);

ALTER TABLE `platform_auth`.`platform_applications`
    ADD COLUMN `group_code` varchar(20) NULL COMMENT '分组编码' AFTER `mailtype`;

ALTER TABLE `platform_auth`.`platform_applications`
    ADD COLUMN `wechat_url` varchar(1000) NULL COMMENT '企业微信入口' AFTER `group_code`;


CREATE TABLE `platform_role_application_app`
(
    `id`            varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
    `roleid`        varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
    `applicationid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='角色的三方应用app权限';

-- 地铁工作菜单表
CREATE TABLE `platform_metrowork_menu`
(
    `id`          varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键ID',
    `name`        varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '菜单名称',
    `code`        varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '菜单编码',
    `sort_order`  int(11) NOT NULL DEFAULT 0 COMMENT '排序序号',
    `status`      tinyint(1) NOT NULL DEFAULT 1 COMMENT '状态：0-停用，1-启用',
    `create_time` datetime                                                     NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
    `update_time` datetime                                                     NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE KEY `uk_code` (`code`) USING BTREE,
    KEY           `idx_sort_order` (`sort_order`) USING BTREE,
    KEY           `idx_status` (`status`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='地铁工作菜单配置表';

-- 初始化地铁工作菜单数据
INSERT INTO `platform_auth`.`platform_metrowork_menu` (`id`, `name`, `code`, `sort_order`, `status`)
VALUES ('1', '系统公告', 'menu_announcement', 1, 1),
       ('2', '政策法规', 'menu_law', 2, 1),
       ('3', '工作动态', 'menu_work', 3, 1),
       ('4', '安全管理', 'menu_anquan', 4, 1),
       ('5', '服务质量', 'menu_fuwu', 5, 1),
       ('6', '网上培训', 'menu_wangshang', 6, 1),
       ('7', '廉政文化', 'menu_lianzheng', 7, 1),
       ('8', '员工天地', 'menu_yuangong', 8, 1),
       ('9', '常用表格', 'menu_biaoge', 9, 1);


-- 如果是新建表，添加字段
ALTER TABLE platform_applications
    ADD COLUMN wechat_num VARCHAR(50) DEFAULT NULL COMMENT '组内排序编号';

-- 如果是更新已有数据，将现有数据的 wechat_num 初始化为当前排序
UPDATE platform_applications
SET wechat_num = (SELECT t.num
                  FROM (SELECT id, ROW_NUMBER() OVER (ORDER BY addtime, id) AS num
                        FROM platform_applications) t
                  WHERE t.id = platform_applications.id);

ALTER TABLE `platform_auth`.`platform_applications`
    ADD UNIQUE INDEX `uni_appid`(`appid`) COMMENT '应用id',
    ADD UNIQUE INDEX `uni_mailtype`(`mailtype`) COMMENT '应用待办标识';
