package com.metro.auth.platform.controller;

import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformApplications;
import com.metro.auth.platform.domain.auth.PlatformApplicationsGroup;
import com.metro.auth.platform.service.PlatformApplicationsGroupService;
import com.metro.auth.platform.service.PlatformApplicationsService;
import com.metro.auth.platform.service.PlatformRoleApplicationAppService;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 企业微信接口
 */
@RestController
@RequestMapping("/wechatApi/")
public class WechatApiController {

    @Resource
    private PlatformApplicationsGroupService platformApplicationsGroupService;
    @Resource
    private PlatformRoleApplicationAppService platformRoleApplicationAppService;

    @GetMapping("/appGroupPageList")
    public ResultJson appGroupPageList(@RequestParam String userId, String appName) {
        // 分组
        List<PlatformApplicationsGroup> platformApplicationsGroups =
                platformApplicationsGroupService.selectList(new PlatformApplicationsGroup());
        // 应用
        List<PlatformApplications> platformApplicationsList =
                platformRoleApplicationAppService.getPlatformApplicationsAppListByUserid(userId);
        if (!CollectionUtils.isEmpty(platformApplicationsList)) {
            //过滤
            if (!StringUtils.isEmpty(appName)) {
                platformApplicationsList = platformApplicationsList.stream()
                        .filter(app -> app.getTitle().contains(appName)).collect(Collectors.toList());
            }
            for (PlatformApplicationsGroup applicationsGroup : platformApplicationsGroups) {
                String groupCode = applicationsGroup.getGroupCode();
                List<PlatformApplications> groupOf = platformApplicationsList.stream()
                        .filter(item -> groupCode.equals(item.getGroupCode())).collect(Collectors.toList());
                if (!groupOf.isEmpty()) {
                    groupOf = groupOf.stream().sorted((a, b) -> {
                        int numA = a.getWechatNum() != null ? Integer.parseInt(a.getWechatNum()) : 999;
                        int numB = b.getWechatNum() != null ? Integer.parseInt(b.getWechatNum()) : 999;
                        return numA - numB;
                    }).collect(Collectors.toList());
                }
                applicationsGroup.setApplicationsList(groupOf);
            }
        }
        // 只要有应用的分组
        platformApplicationsGroups = platformApplicationsGroups.stream()
                .filter(group -> !CollectionUtils.isEmpty(group.getApplicationsList()))
                .collect(Collectors.toList());
        return ResultJson.ok(platformApplicationsGroups);
    }
}
