package com.metro.auth.platform.service;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.PlatformMetroworkMenu;

import java.util.List;

/**
 * 地铁工作菜单服务接口
 */
public interface PlatformMetroworkMenuService {

    /**
     * 获取所有启用的菜单，按排序号排序
     * @return 菜单列表
     */
    List<PlatformMetroworkMenu> getEnabledMenus();

    /**
     * 获取所有菜单
     * @return 菜单列表
     */
    List<PlatformMetroworkMenu> getAllMenus();

    /**
     * 分页查询菜单
     * @param menu 查询条件
     * @param pageNum 页码
     * @param pageSize 每页大小
     * @return 分页结果
     */
    PageInfo<PlatformMetroworkMenu> getMenusPaged(PlatformMetroworkMenu menu, int pageNum, int pageSize);

    /**
     * 根据ID获取菜单
     * @param id 菜单ID
     * @return 菜单对象
     */
    PlatformMetroworkMenu getMenuById(String id);

    /**
     * 保存菜单
     * @param menu 菜单对象
     */
    void saveMenu(PlatformMetroworkMenu menu);

    /**
     * 更新菜单
     * @param menu 菜单对象
     */
    void updateMenu(PlatformMetroworkMenu menu);

    /**
     * 删除菜单
     * @param id 菜单ID
     */
    void deleteMenu(String id);

    /**
     * 启用菜单
     * @param id 菜单ID
     */
    void enableMenu(String id);

    /**
     * 停用菜单
     * @param id 菜单ID
     */
    void disableMenu(String id);
}
