package com.metro.auth.platform.controller;

import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformApplicationsGroup;
import com.metro.auth.platform.service.PlatformApplicationsGroupService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("/applicationsGroup")
public class PlatformApplicationsGroupController {

    @Resource
    PlatformApplicationsGroupService platformApplicationsGroupService;

    /**
     * 分组列表
     *
     * @param platformApplicationsGroup
     * @return resultJson
     */
    @GetMapping("/list")
    public ResultJson list(PlatformApplicationsGroup platformApplicationsGroup) {
        List<PlatformApplicationsGroup> list = platformApplicationsGroupService.selectList(platformApplicationsGroup);
        return ResultJson.ok(list);
    }

    @PostMapping("/add")
    public ResultJson add(@RequestBody PlatformApplicationsGroup platformApplicationsGroup) {
        int count = platformApplicationsGroupService.insert(platformApplicationsGroup);
        if (count > 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @PostMapping("/update")
    public ResultJson update(@RequestBody PlatformApplicationsGroup platformApplicationsGroup) {
        int count = platformApplicationsGroupService.updateByPrimaryKeySelective(platformApplicationsGroup);
        if (count > 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @PostMapping("/delete")
    public ResultJson delete(@RequestBody PlatformApplicationsGroup platformApplicationsGroup) {
        int count = platformApplicationsGroupService.deleteByPrimaryKey(platformApplicationsGroup.getId());
        if (count > 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
}
