package com.metro.auth.platform.controller;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformApplications;
import com.metro.auth.platform.service.PlatformApplicationsService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("/PlatformApplicationsController")
public class PlatformApplicationsController {

    @Resource
    PlatformApplicationsService platformApplicationsService;

    @GetMapping("/platformapplications/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformApplications platformApplications){
        PageInfo<PlatformApplications> page =  platformApplicationsService.pagedlist(platformApplications,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    @PostMapping("/save")
    public ResultJson  saveApp(@RequestBody PlatformApplications platformApplications) throws Exception {
        int count = platformApplicationsService.savaApp(platformApplications);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @DeleteMapping("/del")
    public ResultJson  deleApp(@RequestParam Integer id){

        int count = platformApplicationsService.deleApp(id);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @GetMapping("/platformapplications/listall")
    public ResultJson listall(){
        List<PlatformApplications> list =  platformApplicationsService.getPlatformApplicationsList();
        return ResultJson.ok(list);
    }

    /**
     * 批量更新应用排序
     * @param list 包含 id 与 num 字段的应用列表
     * @return 操作结果
     */
    @PostMapping("/platformapplications/updateOrder")
    public ResultJson updateOrder(@RequestBody List<PlatformApplications> list) {
        int count = platformApplicationsService.updateOrder(list);
        if (count >= 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 批量更新组内应用排序（wechatNum 字段）
     * @param list 包含 id 与 wechatNum 字段的应用列表
     * @return 操作结果
     */
    @PostMapping("/platformapplications/updateWechatNum")
    public ResultJson updateWechatNum(@RequestBody List<PlatformApplications> list) {
        int count = platformApplicationsService.updateWechatNum(list);
        if (count >= 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @GetMapping("/platformapplications/listbyrole/{roleid}")
    public ResultJson listbyrole(@PathVariable String roleid){
        List<PlatformApplications> list =  platformApplicationsService.getPlatformApplicationsListByRole(roleid);
        return ResultJson.ok(list);
    }

    /**
     * 根据用户ID获取应用列表
     * @param userid 用户ID
     * @return 应用列表
     */
    @GetMapping("/platformapplications/listbyuserid/{userid}")
    public ResultJson listbyuserid(@PathVariable String userid){
        List<PlatformApplications> list =  platformApplicationsService.getPlatformApplicationsListByUserid(userid);
        return ResultJson.ok(list);
    }

    /**
     * 验证应用唯一标识是否唯一
     * @param appid 应用唯一标识
     * @param excludeId 排除的记录ID（编辑时使用）
     * @return true-唯一，false-已存在
     */
    @GetMapping("/platformapplications/checkAppidUnique")
    public ResultJson checkAppidUnique(
            @RequestParam(required = true) String appid,
            @RequestParam(required = false) Integer excludeId) {
        boolean isUnique = platformApplicationsService.checkAppidUnique(appid, excludeId);
        return ResultJson.ok(isUnique);
    }

    /**
     * 验证待办标识是否唯一
     * @param mailtype 待办标识
     * @param excludeId 排除的记录ID（编辑时使用）
     * @return true-唯一，false-已存在
     */
    @GetMapping("/platformapplications/checkMailtypeUnique")
    public ResultJson checkMailtypeUnique(
            @RequestParam(required = true) String mailtype,
            @RequestParam(required = false) Integer excludeId) {
        boolean isUnique = platformApplicationsService.checkMailtypeUnique(mailtype, excludeId);
        return ResultJson.ok(isUnique);
    }
}
