package com.metro.auth.platform.controller;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformSysAdv;
import com.metro.auth.platform.domain.auth.SysCodelist;
import com.metro.auth.platform.generallog.LogAnnotation;
import com.metro.auth.platform.service.PlatformSysAdvService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("/sysadv")
public class PlatformSysAdvController {
    @Value("${jwt.header}")
    private String tokenHeader;
    @Resource
    private PlatformSysAdvService platformSysAdvService;

    /**
     * 查询列表
     * @param pageNum
     * @param pageSize
     * @param platformSysAdv
     * @return
     */
    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformSysAdv platformSysAdv,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        PageInfo<PlatformSysAdv> page =  platformSysAdvService.pagedlist(platformSysAdv,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    /**
     * 根据id更新实体
     * @param platformSysAdv
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="更新")
    @PostMapping("/update")
    public  ResultJson update(@RequestBody PlatformSysAdv platformSysAdv){
        int flag=platformSysAdvService.saveUpdatePlatformSysAdv(platformSysAdv);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 根据id更新实体
     * @param platformDepartment
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="新增")
    @PostMapping("/add")
    public  ResultJson add(@RequestBody PlatformSysAdv platformDepartment){
        int flag=platformSysAdvService.savePlatformSysAdv(platformDepartment);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id获取实体
     * @param id
     * @return
     */
    @GetMapping("/load")
    public  ResultJson load(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        PlatformSysAdv platformSysAdv=platformSysAdvService.load(id);
        if (platformSysAdv!=null){
            return  ResultJson.ok(platformSysAdv);
        }else {
            return  ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id删除实体
     * @param id
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="删除")
    @PostMapping("/delete")
    public  ResultJson delete(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        int flag=platformSysAdvService.delPlatformSysAdv(id);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 根据id更新部门启停状态
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="更新状态")
    @PostMapping("/updatestatus")
    public  ResultJson updatestatus(@RequestBody PlatformSysAdv platformSysAdv){
        int flag=platformSysAdvService.updatePlatformSysAdvStatusById(platformSysAdv);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 批量启停用
     * @param ids
     * @param status
     * @return
     */
    @LogAnnotation(operateContent="图片管理",operateType="批量更新状态")
    @PostMapping("/updateSysAdvStatus")
    public ResultJson updateSysAdvStatus(String ids,String status){
        platformSysAdvService.updateSysAdvStatus(status,ids);
        return ResultJson.ok();
    }
    /**
     * 接口：根据type 及num  查询list
     */
    @GetMapping("/getSysAdvListByTypeAndNum")
    public  ResultJson getSysAdvListByTypeAndNum(String type,String num){
        PlatformSysAdv platformSysAdv=new PlatformSysAdv();
        platformSysAdv.setType(type);
        platformSysAdv.setNum(num);
        platformSysAdv.setStatus("1");
        List<PlatformSysAdv> list=platformSysAdvService.selectByExampleForinterface(platformSysAdv);
        return  ResultJson.ok(list);
    }

}
