package com.metro.auth.platform.service;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.PlatformApplications;

import java.util.List;

public interface PlatformApplicationsService {

    PageInfo<PlatformApplications> pagedlist(PlatformApplications platformApplications, int pageNum, int pageSize);

    int savaApp(PlatformApplications platformApplications) throws Exception;

    int deleApp(Integer id);

    List<PlatformApplications> getPlatformApplicationsList();
    List<PlatformApplications> getPlatformApplicationsListByUserid(String userid);
    List<PlatformApplications> getPlatformApplicationsListByRole(String id);

    /**
     * 批量更新应用排序（num 字段）
     * @param list 包含 id 与 num 的应用列表
     * @return 更新数量
     */
    int updateOrder(List<PlatformApplications> list);

    /**
     * 批量更新组内应用排序（wechatNum 字段）
     * @param list 包含 id 与 wechatNum 的应用列表
     * @return 更新数量
     */
    int updateWechatNum(List<PlatformApplications> list);

    /**
     * 验证应用唯一标识是否唯一
     * @param appid 应用唯一标识
     * @param excludeId 排除的记录ID（编辑时使用）
     * @return true-唯一，false-已存在
     */
    boolean checkAppidUnique(String appid, Integer excludeId);

    /**
     * 验证待办标识是否唯一
     * @param mailtype 待办标识
     * @param excludeId 排除的记录ID（编辑时使用）
     * @return true-唯一，false-已存在
     */
    boolean checkMailtypeUnique(String mailtype, Integer excludeId);
}
