package com.metro.auth.platform.service;

import com.metro.auth.platform.domain.auth.PlatformApplications;
import com.metro.auth.platform.domain.auth.PlatformApplicationsExample;
import com.metro.auth.platform.domain.auth.PlatformRoleApplicationApp;
import com.metro.auth.platform.domain.auth.PlatformSysRole;
import com.metro.auth.platform.mapper.PlatformApplicationsMapper;
import com.metro.auth.platform.mapper.PlatformRoleApplicationAppMapper;
import com.metro.auth.platform.mapper.PlatformSysRoleMapper;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PlatformRoleApplicationAppServiceImpl implements PlatformRoleApplicationAppService {

    @Resource
    PlatformApplicationsMapper platformApplicationsMapper;
    @Resource
    PlatformRoleApplicationAppMapper platformRoleApplicationAppMapper;
    @Resource
    PlatformSysRoleMapper platformSysRoleMapper;

    @Override
    public List<PlatformApplications> getPlatformApplicationsListApp() {
        return platformApplicationsMapper.getPlatformApplicationsList();
    }

    @Override
    public List<PlatformApplications> getPlatformApplicationsListByRoleApp(String roleid) {
        PlatformApplicationsExample platformApplicationsExample = new PlatformApplicationsExample();
        //所有应用
        List<PlatformApplications> alllist = platformApplicationsMapper.selectByExample(platformApplicationsExample);

        // 查询当前角色的 App 应用权限关联
        List<PlatformApplications> roleApps = platformApplicationsMapper.getPlatformApplicationsListByRoleApp(roleid);

        // 首先将所有应用的 roleUseStatue 设置为 0（不可见）
        alllist.stream().forEach(t -> {
            t.setRoleUseStatue(0);
        });

        // 然后将可见应用的 roleUseStatue 设置为该应用的ID
        if (roleApps != null && roleApps.size() > 0) {
            for (PlatformApplications roleApp : roleApps) {
                alllist.stream().forEach(t -> {
                    if (t.getId().equals(roleApp.getId())) {
                        t.setRoleUseStatue(t.getId());
                    }
                });
            }
        }
        return alllist;
    }

    @Override
    public int deleteByRoleid(String roleid) {
        return platformRoleApplicationAppMapper.deleteByRoleid(roleid);
    }

    @Override
    public int insertRoleApplicationApp(PlatformRoleApplicationApp platformRoleApplicationApp) {
        return platformRoleApplicationAppMapper.insertRoleApplicationApp(platformRoleApplicationApp);
    }

    @Override
    public List<PlatformApplications> getPlatformApplicationsAppListByUserid(String userid) {
        // 1. 查询所有启用的应用
        PlatformApplicationsExample example = new PlatformApplicationsExample();
        example.createCriteria().andQyflagEqualTo("1");
        List<PlatformApplications> allApplications = platformApplicationsMapper.selectByExample(example);

        // 3. 安全地解析userid并查询用户角色
        Set<String> roleIds = new HashSet<>();
        int userIdInt = Integer.parseInt(userid);
        // 直接查询出角色ID列表，避免在Java代码中循环提取
        roleIds = platformSysRoleMapper.selectByUserId(userIdInt)
                .stream().map(PlatformSysRole::getId)
                .collect(Collectors.toSet());

        // 4. 根据角色ID列表查询可见应用
        List<PlatformApplications> visibleApplications;
        if (roleIds.isEmpty()) {
            visibleApplications = Collections.emptyList(); // 如果没有角色，则可见应用列表为空
        } else {
            visibleApplications = platformApplicationsMapper.getPlatformApplicationsListByRoleAppList(new ArrayList<>(roleIds));
        }

        // 提取可见应用的ID集合，用于快速判断
        Set<Integer> visibleAppIds = visibleApplications.stream()
                .map(PlatformApplications::getId)
                .collect(Collectors.toSet());

        // 遍历所有应用，根据其ID是否在可见应用ID集合中来更新状态
        allApplications.forEach(app -> {
            if (visibleAppIds.contains(app.getId())) {
                app.setRoleUseStatue(app.getId()); // 可见
            } else {
                app.setRoleUseStatue(0); // 不可见
            }
        });
        return allApplications.stream()
                .sorted(Comparator.comparing(app -> StringUtils.isEmpty(app.getNum()) ? 0 : Integer.parseInt(app.getNum())))
                .collect(Collectors.toList());

    }
}
