package com.metro.auth.platform.service;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.*;
import com.metro.auth.platform.domain.dto.RoleFunctionDTO;
import com.metro.auth.platform.mapper.PlatformApplicationsMapper;
import com.metro.auth.platform.mapper.PlatformRoleMenuMapper;
import com.metro.auth.platform.mapper.PlatformSysRoleMapper;
import com.metro.auth.platform.service.PlatformRoleApplicationAppService;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.StrUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;

/**
 * @ClassName: PlatformRoleServiceImpl
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-09-11 11:50
 */
@Service
public class PlatformRoleServiceImpl implements PlatformRoleService{

    @Resource
    PlatformSysRoleMapper platformSysRoleMapper;

    @Resource
    PlatformRoleMenuMapper platformRoleMenuMapper;

    @Resource
    PlatformApplicationsMapper platformApplicationsMapper;

    @Resource
    PlatformRoleApplicationAppService platformRoleApplicationAppService;

    /**
     * 功能描述: <br>查询权限列表
     * 〈〉
     * @Param: [platformSysRole, pageNum, pageSize]
     * @Return: [platformSysRole, pageNum, pageSize]
     * @Author: zhouy
     * @Date: 2019-09-11 12:01
     */
    @SuppressWarnings("Duplicates")
    @Override
    public PageInfo<PlatformSysRole> pagedlist(PlatformSysRole platformSysRole,
                                               int pageNum,
                                               int pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        PlatformSysRoleExample platformSysRoleExample = new PlatformSysRoleExample();
        PlatformSysRoleExample.Criteria criteria = platformSysRoleExample.createCriteria();

        if(platformSysRole!=null&&!EmptyUtilHelper.isEmpty(platformSysRole.getName())){
            criteria.andNameLike("%"+platformSysRole.getName()+"%");

        }else if (platformSysRole!=null&&!EmptyUtilHelper.isEmpty(platformSysRole.getNamezh())){
            criteria.andNamezhLike("%"+platformSysRole.getNamezh()+"%");
        }

        List<PlatformSysRole> list = platformSysRoleMapper.selectByExample(platformSysRoleExample);



        PageInfo<PlatformSysRole> pageInfo = new PageInfo<>(list);

        return pageInfo;
    }

    /**
     * 功能描述: <br>保存角色信息
     * 〈〉
     * @Param: [platformSysRole]
     * @Return: [platformSysRole]
     * @Author: zhouy
     * @Date: 2019-09-11 14:56
     */

    @Override
    public int savaRole(PlatformSysRole platformSysRole) {
        int count =0;
        if(platformSysRole!=null&& !EmptyUtilHelper.isEmpty(platformSysRole.getId())){
            //更新
            platformApplicationsMapper.deleteByRoleid(platformSysRole.getId());
            platformRoleApplicationAppService.deleteByRoleid(platformSysRole.getId());
            PlatformSysRoleExample platformSysRoleExample =new PlatformSysRoleExample();
            platformSysRoleExample.createCriteria().andIdEqualTo(platformSysRole.getId());
            count =platformSysRoleMapper.updateByExample(platformSysRole,platformSysRoleExample);
        }else {
            //主键
            platformSysRole.setId(StrUtil.makePramykey());
            count =platformSysRoleMapper.insert(platformSysRole);
        }
        // 处理PC端应用权限
        if(platformSysRole.getGroup() != null && !platformSysRole.getGroup().isEmpty()) {
            String[] appid = platformSysRole.getGroup().split(",");
            //不选者可见菜单权限时的处理
            if(appid.length>0){
                Arrays.stream(appid).forEach(t->{
                    PlatformRoleApplication platformRoleApplication = new PlatformRoleApplication();
                    platformRoleApplication.setId(StrUtil.makePramykey());
                    platformRoleApplication.setRoleid(platformSysRole.getId());
                    platformRoleApplication.setApplicationid(t);
                    platformApplicationsMapper.insertRoleApplication(platformRoleApplication);
                });
            }
        }
        // 处理App端应用权限
        if(platformSysRole.getGroupApp() != null && !platformSysRole.getGroupApp().isEmpty()) {
            String[] appidApp = platformSysRole.getGroupApp().split(",");
            if(appidApp.length>0){
                Arrays.stream(appidApp).forEach(t->{
                    com.metro.auth.platform.domain.auth.PlatformRoleApplicationApp platformRoleApplicationApp =
                        new com.metro.auth.platform.domain.auth.PlatformRoleApplicationApp();
                    platformRoleApplicationApp.setId(StrUtil.makePramykey());
                    platformRoleApplicationApp.setRoleid(platformSysRole.getId());
                    platformRoleApplicationApp.setApplicationid(t);
                    platformRoleApplicationAppService.insertRoleApplicationApp(platformRoleApplicationApp);
                });
            }
        }
        return count;
    }

    @Override
    public int deleRole(String id) {
        platformApplicationsMapper.deleteByRoleid(id);
        platformRoleApplicationAppService.deleteByRoleid(id);
        int count =  platformSysRoleMapper.deleteByPrimaryKey(id);
        return count;
    }

    @Override
    public void delRoles(String ids) {
        String[] id = ids.split(",");
        Arrays.stream(id).forEach(t->{
            platformApplicationsMapper.deleteByRoleid(t);
            platformRoleApplicationAppService.deleteByRoleid(t);
           platformSysRoleMapper.deleteByPrimaryKey(t);
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public int savepermission(RoleFunctionDTO roleFunctionDTO){

        int count =0;
        List<PlatformRoleMenu> platformRoleMenus = roleFunctionDTO.getPermission();
        PlatformRoleMenuExample platformRoleMenuExample = new PlatformRoleMenuExample();
        PlatformRoleMenuExample.Criteria criteria = platformRoleMenuExample.createCriteria();
        criteria.andRoleidEqualTo(roleFunctionDTO.getRoleid());
        criteria.andModuleidEqualTo(roleFunctionDTO.getModuleid());
        //先删除
        platformRoleMenuMapper.deleteByExample(platformRoleMenuExample);
        if(platformRoleMenus!=null&&platformRoleMenus.size()>0){
            for(PlatformRoleMenu platformRoleMenu:platformRoleMenus){
                //后增加
                platformRoleMenu.setId(StrUtil.makePramykey());
                platformRoleMenu.setRoleid(roleFunctionDTO.getRoleid());
                count +=platformRoleMenuMapper.insert(platformRoleMenu);
            }
        }else {
            //保存上级菜单ID
            PlatformRoleMenu sysRoleMenu = new PlatformRoleMenu();
            sysRoleMenu.setId(StrUtil.makePramykey());
            sysRoleMenu.setRoleid(roleFunctionDTO.getRoleid());
            sysRoleMenu.setModuleid(roleFunctionDTO.getModuleid());
            count = platformRoleMenuMapper.insert(sysRoleMenu);
        }
        return count;
    }

}
