package com.metro.auth.platform.mapper;

import com.metro.auth.platform.domain.dto.TodoNumDTO;
import com.metro.auth.platform.domain.entity.Todo;
import com.metro.auth.platform.domain.entity.TodoExample;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

public interface TodoMapper {

    /**
     * @Author wuchao
     * @Description 一键已读
     * @Date  2023-07-25
     * @Param [todoNumDTO]
     * @return java.lang.Integer
     **/
    Integer oneClickRead(@Param("data") TodoNumDTO todoNumDTO);


    /**
     * @Author wuchao
     * @Description 批量已读
     * @Date  2023-07-25
     * @Param [todoNumDTO]
     * @return java.lang.Integer
     **/
    Integer batchRead(@Param("data") TodoNumDTO todoNumDTO);


    List<TodoNumDTO> countByaccount(String account);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    int deleteByExample(TodoExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    int deleteByPrimaryKey(String id);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    int insert(Todo record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    int insertSelective(Todo record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    List<Todo> selectByExample(TodoExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    Todo selectByPrimaryKey(String id);

    Todo selectByAccountAndBuid(String account,String buid);
    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    int updateByExampleSelective(@Param("record") Todo record, @Param("example") TodoExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    int updateByExample(@Param("record") Todo record, @Param("example") TodoExample example);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    int updateByPrimaryKeySelective(Todo record);

    /**
     * This method was generated by MyBatis Generator.
     * This method corresponds to the database table platform_todo
     *
     * @mbg.generated
     */
    int updateByPrimaryKey(Todo record);

    int updateByBuid(Todo record);
    int updateById(Todo record);
    List<Todo> queryTodoList(String status,String type, String account);


}
