package com.metro.auth.platform.metrointerface;

import com.alibaba.fastjson.JSONObject;
import com.metro.auth.platform.domain.Pagination;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.dto.DailyReqDTO;
import com.metro.auth.platform.domain.dto.DailyRespDTO;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.outlineapi.PlatformUrlManager;
import com.metro.auth.platform.utils.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */
@Slf4j
@RestController
@RequestMapping("/daily")
public class DailyController {

    @Resource
    private HttpAPIService httpAPIService;

    /**
     * 功能描述: <br>获取日报信息分页列表
     * 〈〉
     *
     * @Author: lx
     */
    @GetMapping("/pageList")
    public ResultJson queryDailyPageList(DailyReqDTO dailyDTO, Integer pageIndex, Integer pageSize) {
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.DAILY_NEW_URL);
        String finalUrl = url
                .replace("@{staffCode}", dailyDTO.getStaffCode())
                .replace("@{state}", dailyDTO.getState())
                .replace("@{content}", dailyDTO.getContent())
                .replace("@{pageNo}", pageIndex.toString())
                .replace("@{pageSize}", pageSize.toString());
        String result = httpAPIService.doGet(finalUrl);
        if (result != null) {
            log.info("日报信息分页列表返回结果:{}", result);
            JSONObject jsonObject = JSONObject.parseObject(result);
            if (jsonObject.getInteger("code") != 0) {
                return ResultJson.ok(jsonObject.getString("msg"));
            }
            JSONObject data = JSONObject.parseObject(jsonObject.get("data").toString());
            String list = data.getString("list");
            String total = data.getString("total");
            List<DailyRespDTO> dailyRespDTOS = JSONObject.parseArray(list, DailyRespDTO.class);
            Pagination pagination = new Pagination(dailyRespDTOS, new Long(total), pageSize, pageIndex);
            return ResultJson.ok(pagination);
        }
        return ResultJson.ok();
    }

    /**
     * 功能描述: <br>获取日报信息详情
     * 〈〉
     *
     * @Author: lx
     */
    @GetMapping("/dailyInfo")
    public ResultJson getDailyInfoById(DailyReqDTO dailyDTO) {
        String url = SpringUtil.getBean(PlatformUrlManager.class).getPlatformURI(PlatformUrlManager.DAILY_DETAIL_URL);
        String finalUrl = url.replace("@{staffCode}", dailyDTO.getStaffCode()).replace("@{id}", dailyDTO.getId());
        String result = httpAPIService.doGet(finalUrl);
        if (result != null) {
            log.info("日报信息返回结果:{}", result);
            JSONObject jsonObject = JSONObject.parseObject(result);
            if (jsonObject.getInteger("code") != 0) {
                return ResultJson.ok(jsonObject.getString("message"));
            }
            Object data = jsonObject.get("data");
            DailyRespDTO dailyRespDTO = JSONObject.parseObject(data.toString(), DailyRespDTO.class);
            return ResultJson.ok(dailyRespDTO);
        }
        return ResultJson.ok();
    }

}
