package com.metro.auth.platform.controller;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformApplications;
import com.metro.auth.platform.service.PlatformApplicationsService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("/PlatformApplicationsController")
public class PlatformApplicationsController {

    @Resource
    PlatformApplicationsService platformApplicationsService;

    @GetMapping("/platformapplications/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformApplications platformApplications){
        PageInfo<PlatformApplications> page =  platformApplicationsService.pagedlist(platformApplications,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    @PostMapping("/save")
    public ResultJson  saveApp(@RequestBody PlatformApplications platformApplications) throws Exception {
        int count = platformApplicationsService.savaApp(platformApplications);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @DeleteMapping("/del")
    public ResultJson  deleApp(@RequestParam Integer id){

        int count = platformApplicationsService.deleApp(id);
        if(count>0){
            return ResultJson.ok();
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    @GetMapping("/platformapplications/listall")
    public ResultJson listall(){
        List<PlatformApplications> list =  platformApplicationsService.getPlatformApplicationsList();
        return ResultJson.ok(list);
    }

    @GetMapping("/platformapplications/listbyrole/{roleid}")
    public ResultJson listbyrole(@PathVariable String roleid){
        List<PlatformApplications> list =  platformApplicationsService.getPlatformApplicationsListByRole(roleid);
        return ResultJson.ok(list);
    }
    @GetMapping("/platformapplications/listbyuserid/{userid}")
    public ResultJson listbyuserid(@PathVariable String userid){
        List<PlatformApplications> list =  platformApplicationsService.getPlatformApplicationsListByUserid(userid);
        return ResultJson.ok(list);
    }
}
