package com.metro.auth.platform.controller;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.SysCodelist;
import com.metro.auth.platform.service.SysCodelistService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("/syscodelist")
public class SysCodelistController {
    @Value("${jwt.header}")
    private String tokenHeader;
    @Resource
    private SysCodelistService sysCodelistService;

    /**
     * 查询列表
     * @param pageNum
     * @param pageSize
     * @param sysCodelist
     * @return
     */
    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                SysCodelist sysCodelist,HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        PageInfo<SysCodelist> page =  sysCodelistService.pagedlist(sysCodelist,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    /**
     * 根据id更新实体
     * @param sysCodelist
     * @return
     */
    @PutMapping("/update")
    public  ResultJson update(@RequestBody SysCodelist sysCodelist){
        int flag=sysCodelistService.saveUpdateSysCodelist(sysCodelist);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 根据id更新实体
     * @param sysCodelist
     * @return
     */
    @PostMapping("/add")
    public  ResultJson add(@RequestBody SysCodelist sysCodelist){
        int flag=sysCodelistService.saveSysCodelist(sysCodelist);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id获取实体
     * @param id
     * @return
     */
    @GetMapping("/load")
    public  ResultJson load(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        SysCodelist sysCodelist=sysCodelistService.load(id);
        if (sysCodelist!=null){
            return  ResultJson.ok(sysCodelist);
        }else {
            return  ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id删除实体
     * @param id
     * @return
     */
    @RequestMapping("/delete")
    public  ResultJson delete(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        int flag=sysCodelistService.delSysCodelist(id);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 根据id更新部门启停状态
     * @return
     */
    @PostMapping("/updatestatus")
    public  ResultJson updatestatus(@RequestBody SysCodelist sysCodelist){
        int flag=sysCodelistService.updateSysCodelistStatusById(sysCodelist);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 接口：根据Kindcode查询list
     */
    @GetMapping("/getSysCodelistByKindcode")
    public  ResultJson getSysAdvListByTypeAndNum(String kindcode){
        SysCodelist sysCodelist=new SysCodelist();
        sysCodelist.setKindcode(kindcode);
        List<SysCodelist> list=sysCodelistService.selectByExample(sysCodelist);
        return  ResultJson.ok(list);
    }
    @GetMapping("/countByExample")
    public ResultJson countByExample(String id){
        long flag=sysCodelistService.countByExample(id);
        return ResultJson.ok(flag);
    }
}
