package com.metro.auth.platform.service;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.*;
import com.metro.auth.platform.mapper.PlatformPersonnelMapper;
import com.metro.auth.platform.mapper.PlatformSysRoleMapper;
import com.metro.auth.platform.mapper.PlatformSysUserRoleMapper;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JwtUtils;
import com.metro.auth.platform.utils.StrUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * @author zhouy
 * @ClassName: PlatformRoleUserServiceImpl
 * @Description: ${description}  
 * @Date 2019-09-11 17:22
 */
@Service
public class PlatformRoleUserServiceImpl implements PlatformRoleUserService {

    @Resource
    PlatformSysRoleMapper platformSysRoleMapper;

    @Resource
    PlatformSysUserRoleMapper platformSysUserRoleMapper;

    @Resource
    PlatformPersonnelMapper platformPersonnelMapper;

    @Value("${jwt.header}")
    private String tokenHeader;

    @Resource
    private JwtUtils jwtUtils;


    /**
     * 功能描述: <br>用户角色功能查询角色信息
     * 〈〉
     * @Param: [platformSysRole, pageNum, pageSize]
     * @Return: [platformSysRole, pageNum, pageSize]
     * @Author: zhouy
     * @Date: 2019-09-12 09:24
     */

    @SuppressWarnings("Duplicates")
    @Override
    public PageInfo<PlatformSysRole> pageRoledlist(PlatformSysRole platformSysRole,
                                                   int pageNum,
                                                   int pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        PlatformSysRoleExample platformSysRoleExample = new PlatformSysRoleExample();
        PlatformSysRoleExample.Criteria criteria = platformSysRoleExample.createCriteria();

        if(platformSysRole!=null&&!EmptyUtilHelper.isEmpty(platformSysRole.getName())){
            criteria.andNameLike("%"+platformSysRole.getName()+"%");

        }else if (platformSysRole!=null&&!EmptyUtilHelper.isEmpty(platformSysRole.getNamezh())){
            criteria.andNamezhLike("%"+platformSysRole.getNamezh()+"%");
        }
        List<PlatformSysRole> list = platformSysRoleMapper.selectByExample(platformSysRoleExample);

        List<PlatformSysUserRole> userRoleList = this.userRolelist();
        list.stream().forEach(t->{
            for (int i=0;i<userRoleList.size();i++){
                if(t.getId().equals(userRoleList.get(i).getRoleId())&&userRoleList.get(i).getUserId()==platformSysRole.getUserId()){
                    t.setIsAdd("1");
                    break;
                }else{
                    t.setIsAdd("2");
                }
            }
        });

        PageInfo<PlatformSysRole> pageInfo = new PageInfo<>(list);
        return pageInfo;
    }

    /**
     * 功能描述: 修改用户角色权限信息
     * 〈〉
     * @Param: [platformSysUserRole]
     * @Return: [platformSysUserRole]
     * @Author: zhouy
     * @Date: 2019-09-12 14:15
     */

    @Override
    public int editroleuser(PlatformSysUserRole platformSysUserRole) {
        int count=0;
        //配置角色时候先删除原角色，不支持一个用户多个角色
        PlatformSysUserRoleExample platformSysUserRoleExample = new PlatformSysUserRoleExample();
        platformSysUserRoleExample.createCriteria()//.andRoleIdEqualTo(platformSysUserRole.getRoleId())
                .andUserIdEqualTo(platformSysUserRole.getUserId());
        if(!EmptyUtilHelper.isEmpty(platformSysUserRole.getUserId())){
//            count = platformSysUserRoleMapper.deleteByExample(platformSysUserRoleExample);
        }
        if(platformSysUserRole!=null&& "1".equals(platformSysUserRole.getAction())){
            platformSysUserRole.setId(StrUtil.makePramykey());
            count =  platformSysUserRoleMapper.insert(platformSysUserRole);
            if(count>0){
                platformPersonnelMapper.updateRoleByUserid(platformSysUserRole.getUserId(),platformSysUserRole.getRoleId());
            }
        }else{
            if(count>0){
                platformPersonnelMapper.updateRoleByUserid(platformSysUserRole.getUserId(),"");
            }
        }

        return count;
    }

    @Override
    public int addroleuser(PlatformSysUserRole platformSysUserRole){
        platformSysUserRoleMapper.deleteByroleId(platformSysUserRole.getRoleId());
        List<PlatformSysUserRole> list = platformSysUserRole.getContactList();
        if(list.size()>0){
            for (int i = 0; i < list.size(); i++) {
                PlatformSysUserRole contact = list.get(i);
                contact.setId(StrUtil.makePramykey());
                contact.setRoleId(platformSysUserRole.getRoleId());
                platformSysUserRoleMapper.insert(contact);
            }
        }
        return 1;
    }
    @Override
    public int delUserRole(PlatformSysUserRole platformSysUserRole) {
        int count=0;
        //配置角色时候先删除原角色，不支持一个用户多个角色
        PlatformSysUserRoleExample platformSysUserRoleExample = new PlatformSysUserRoleExample();
        platformSysUserRoleExample.createCriteria()//.andRoleIdEqualTo(platformSysUserRole.getRoleId())
                .andUserIdEqualTo(platformSysUserRole.getUserId()).andRoleIdEqualTo(platformSysUserRole.getRoleId());
        if(!EmptyUtilHelper.isEmpty(platformSysUserRole.getUserId()) && !EmptyUtilHelper.isEmpty(platformSysUserRole.getRoleId())){
            count = platformSysUserRoleMapper.deleteByExample(platformSysUserRoleExample);
        }
        return count;
    }

    @Override
    public int editUserRoleList(Map<String,String> map) {
        String roleid = map.get("roleId");
        String userids = map.get("userIds");
        int count=0;
        if(EmptyUtilHelper.isEmpty(roleid)){
            return 0 ;
        }

        if(EmptyUtilHelper.isEmpty(userids)){
            platformSysUserRoleMapper.deleteByroleId(roleid);
            return 1;
        }

        //获取数据库中当前的角色用户
        PlatformSysUserRoleExample example = new PlatformSysUserRoleExample();
        example.createCriteria().andRoleIdEqualTo(roleid);
        List<PlatformSysUserRole> cu_list  = platformSysUserRoleMapper.selectByExample(example);

        String[] strs = userids.split(",");
        List<Integer> u_list = new ArrayList<>();//前台传回的用户
        for(int i=0;i<strs.length;i++){
            int u = Integer.parseInt(strs[i]);
            u_list.add(u);
        }

        //遍历两个结合重复的代表不用修改，移除
        for(int i=0;i<cu_list.size();i++){
            PlatformSysUserRole ur = cu_list.get(i);
            for(int k=0;k<u_list.size();k++){
                Integer u = u_list.get(k);
                if(u.compareTo(ur.getUserId())==0){
                    cu_list.remove(ur);
                    i--;
                    u_list.remove(u);
                    k--;
                    break;
                }
            }
        }

        //此时cu_list中剩余的删掉
        if(cu_list.size()>0){
            platformSysUserRoleMapper.batchDeleteById(cu_list);
        }
        //此时u_list中剩余的新增
        if(u_list.size()>0){
            List<PlatformSysUserRole> add_list = new ArrayList<>();
            for (int i=0;i<u_list.size();i++){
                PlatformSysUserRole entity =
                    new PlatformSysUserRole(StrUtil.makePramykey(),u_list.get(i),roleid);
                add_list.add(entity);
            }
            platformSysUserRoleMapper.batchInsert(add_list);

        }
        return 1;
    }


    /**
     * 功能描述: <br>角色用户列表
     * 〈〉
     * @Param: [platformPersonnel, pageNum, pageSize]
     * @Return: [platformPersonnel, pageNum, pageSize]
     * @Author: zhouy
     * @Date: 2019-09-12 16:43
     */

    @Override
    public PageInfo<PlatformPersonnel> roleuserpagedlist(PlatformPersonnel platformPersonnel, int pageNum, int pageSize) {

        PageHelper.startPage(pageNum, pageSize);
//        PlatformPersonnelExample platformPersonnelExample = new PlatformPersonnelExample();
//        PlatformPersonnelExample.Criteria criteria = platformPersonnelExample.createCriteria();
//        if (platformPersonnel!=null){
//            if (!EmptyUtilHelper.isEmpty(platformPersonnel.getAccount())){
//                criteria.andAccountLike("%"+platformPersonnel.getAccount()+"%");
//            }
//            if (!EmptyUtilHelper.isEmpty(platformPersonnel.getUsername())){
//                criteria.andUsernameLike("%"+platformPersonnel.getUsername()+"%");
//            }
//            if(!EmptyUtilHelper.isEmpty(platformPersonnel.getRole())){
//                criteria.andRoleEqualTo(platformPersonnel.getRole());
//            }
//        }
//        List<PlatformPersonnel> list=platformPersonnelMapper.selectByExample(platformPersonnelExample);

        List<PlatformPersonnel> list = platformPersonnelMapper.selectByroleId(platformPersonnel.getRole());

        PageInfo<PlatformPersonnel> pageInfo = new PageInfo<>(list);

        return pageInfo;

    }

    @Override
    public List<PlatformSysUserRole> roleuserlist(PlatformPersonnel platformPersonnel) {
        PlatformSysUserRoleExample example = new PlatformSysUserRoleExample();
        example.createCriteria().andRoleIdEqualTo(platformPersonnel.getRole());
        List<PlatformSysUserRole> list  = platformSysUserRoleMapper.selectByExample(example);
        return list;
    }

    /**
     * 功能描述: <b>用户角色信息
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-12 09:36
     */
    public List<PlatformSysUserRole> userRolelist(){

        PlatformSysUserRoleExample platformSysUserRoleExample = new PlatformSysUserRoleExample();

        return platformSysUserRoleMapper.selectByExample(platformSysUserRoleExample);
    }
}
