package com.metro.auth.platform.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.entity.Todo;
import com.metro.auth.platform.domain.entity.TodoExample;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.mapper.TodoMapper;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JwtUtils;
import com.metro.auth.platform.viewformat.DataDictClass;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Slf4j
@Service
public class TodoListServiceImpl implements TodoListService{
    @Resource
    private TodoMapper todoMapper;
    private final JwtUtils jwtTokenUtil;
    public TodoListServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }
    @Resource
    public HttpAPIService httpAPIService;

    /**
     *
     * @param todo
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
        public PageInfo<Todo> todopagedlist(Todo todo, int pageNum, int pageSize) {

            PageHelper.startPage(pageNum, pageSize);
            TodoExample todoExample = new TodoExample();
            TodoExample.Criteria criteria = todoExample.createCriteria();
            //搜索
            if (todo!=null){
                if (!EmptyUtilHelper.isEmpty(todo.getType())){
                    criteria.andTypeEqualTo( todo.getType());
                }
                if (!EmptyUtilHelper.isEmpty(todo.getAccount())){
                    criteria.andAccountEqualTo( todo.getAccount());
                }
                if (!EmptyUtilHelper.isEmpty(todo.getStatus())){
                    criteria.andStatusEqualTo( todo.getStatus());
                }
            }
            todoExample.setOrderByClause(" ctime desc");
            List<Todo> list=todoMapper.selectByExample(todoExample);
            PageInfo<Todo> pageInfo = new PageInfo<>(list);

            return pageInfo;
        }
}
