package com.metro.auth.platform.utils;

import org.apache.commons.lang.StringUtils;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

public class DownImageUtil {

    /**
     * 从网络Url中下载文件
     * @param urlStr
     * @param fileName
     * @param savePath
     * @throws IOException
     */
    public static void  downLoadFromUrl(String urlStr,String fileName,String savePath) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        //设置超时间为3秒
        conn.setConnectTimeout(3*1000);
        //防止屏蔽程序抓取而返回403错误
        conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");

        //得到输入流
        InputStream inputStream = conn.getInputStream();
        //获取自己数组
        byte[] getData = readInputStream(inputStream);

        //文件保存位置
        File saveDir = new File(savePath);
        if(!saveDir.exists()){
            saveDir.mkdirs();
        }
        File file = new File(saveDir+File.separator+fileName);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(getData);
        if(fos!=null){
            fos.close();
        }
        if(inputStream!=null){
            inputStream.close();
        }

        System.out.println("info:"+url+" download success");

    }



    /**
     * 从输入流中获取字节数组
     * @param inputStream
     * @return
     * @throws IOException
     */
    public static  byte[] readInputStream(InputStream inputStream) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while((len = inputStream.read(buffer)) != -1) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }


    /**
     * 把微信URL转化为本地文件
     */
    public static String saveAvatar2File(String urlStr,String filename){

        if(StringUtils.isEmpty(urlStr)){
            return "";
        }

        try {
            String uploadPar = "avatar";
            if(StringUtils.isEmpty(filename)){
                filename = System.currentTimeMillis() +".jpg";
            }else{
                filename = filename+".jpg";
            }

            //文件真实路径
            String uploadDir = CommonUtil.UPLOADFILEURL+uploadPar;
            //todo 此处开发用工程路径，正式换ng的路径
            // 文件网络路径
            String fileRealPath=CommonUtil.WEBSITE+uploadPar+File.separator+filename;
            DownImageUtil.downLoadFromUrl(urlStr,filename,uploadDir);
            return fileRealPath;
        } catch (IOException e) {
            e.printStackTrace();
            return urlStr;
        }



    }

//    public static void main(String[] args) {
//        try{
//            String urlStr = "http://wework.qpic.cn/wwhead/duc2TvpEgSTPk74IwG7Bs3Mibxs9gMgPQ2OVLFuaQssbyCYTRkiau4s6icjCf3dcEL9aghWFU8ibTLc/0";
//            downLoadFromUrl(urlStr, "百度.jpg","/Users/zhouhaifeng/Documents/auth/");
//        }catch (Exception e) {
//            // TODO: handle exception
//        }
//    }

}
