package com.metro.auth.platform.controller;

import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformDepartment;
import com.metro.auth.platform.domain.dto.AppMessageDTO;
import com.metro.auth.platform.domain.dto.TodoNumDTO;
import com.metro.auth.platform.domain.entity.Todo;
import com.metro.auth.platform.service.TodoService;
import com.metro.auth.platform.utils.JSONUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author zhf
 */
@Slf4j
@RestController
@Api(tags = "平台待办信息")
@RequestMapping("/auth/todo")
public class TodoController {
    @Resource
    private TodoService todoService;


    @PostMapping(value = "/oneClickRead")
    @ApiOperation(value = "一键已读", notes = "一键已读")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header")})
    public ResultJson<Integer> oneClickRead(@RequestBody TodoNumDTO todoNumDTO) throws Exception {
        return ResultJson.ok(todoService.oneClickRead(todoNumDTO));
    }


    @PostMapping(value = "/batchRead")
    @ApiOperation(value = "批量已读", notes = "批量已读")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header")})
    public ResultJson<Integer> batchRead(@RequestBody TodoNumDTO todoNumDTO) throws Exception {
        return ResultJson.ok(todoService.batchRead(todoNumDTO));
    }


    /**
     * 功能描述: <br>根据工号获得各类待办事项数量
     * 〈〉
     * @Param: [account]
     * @Return: [account]
     * @Author: zhouy
     * @Date: 2019-08-31 16:33
     */
    @GetMapping(value = "/typeconut/{account}")
    @ApiOperation(value = "根据工号获得各类待办事项数量", notes = "根据工号获得各类待办事项数量")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="account",value="工号",required=true,paramType="path"),})
    public ResultJson<List<TodoNumDTO>> countByaccount(@PathVariable String account){
        List<TodoNumDTO> list = todoService.countByaccount(account);
        return ResultJson.ok(list);
    }

    /**
     * 查询代办列表
     * @param type
     * @param account
     * @param status
     * @return
     */
    @GetMapping(value = "/todolist")
    @ApiOperation(value = "查询代办列表", notes = "查询代办列表")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式token", required = true, dataType = "string", paramType = "header"),
            @ApiImplicitParam(name="account",value="工号",required=false,paramType="query"),
            @ApiImplicitParam(name="type",value="代办类型(1会议，2日报，3安全管理)",required=false,paramType="query"),
            @ApiImplicitParam(name="status",value="处理状态（0未处理，1已处理；默认为0）",defaultValue = "0",required=false,paramType="query"),
    })
    public ResultJson<List<Todo>> getToDoList(@RequestParam(name="type",value = "",required = false) String type,
                                  @RequestParam(name="account",value = "",required = false) String account,
                                              @RequestParam(name="status",value = "",required = false) String status){
        List<Todo> list = todoService.getToDoList(type,account,status);
        return ResultJson.ok(list);
    }


    /**
    　* @description: 新代办
    　* @param
    　* @return
    　* @author bajl
    　* @date 2021/12/6 9:25 上午
    　*/
//    @RabbitListener(queues = {"com.queue.notify.todo"})
//    public void optTodo(String message) {
//        log.info("队列处理更新代办通知  ："+ message);
//        AppMessageDTO messageDTO = JSONUtil.toBean(message, AppMessageDTO.class);
//
//        String todoType = messageDTO.getType();
//        Todo  todo = JSONUtil.toBean(messageDTO.getDataJSON(), Todo.class);
//        if("todoadd".equals(todoType)){
//            todoService.insert(todo);
//        }
//        if("todoupdate".equals(todoType)){
//            todoService.updatetodo(todo.getBuid());
//        }
//    }

    /**
     * 增加待办事项
     */
    @RabbitListener(queues = {"com.queue.notify.addtodo"})
    public void addtodo(String message) {
        log.info("队列处理新增代办通知  ："+message);
        try{
            Todo  todo = JSONUtil.toBean(message, Todo.class);
            todoService.insert(todo);
        }catch (Exception e){
            log.error("消息队列参数格式传递错误错误！");
        }
//

    }

    /**
     * 更新待办事项为已处理
     */
    @RabbitListener(queues = {"com.queue.notify.updatetodo"})
    public void updatetodo(String buiid) {
        log.info("队列处理更新代办通知  ："+buiid);
        todoService.updatetodo(buiid);
    }

    /**
     * 查询代办列表
     */
    @GetMapping("/list/{account}/{type}/{status}")
    public ResultJson queryPlatformDepartmentById(@PathVariable String account ,@PathVariable String type,@PathVariable String status) {
        List<Todo> list = todoService.queryTodoList(status,type, account);
        return ResultJson.ok(list);
    }

    /**
     * 根据id更新实体状态
     * @param id
     * @return
     */
    @GetMapping("/update/{id}")
    public  ResultJson updateTodoById(@PathVariable String id){
        int flag=todoService.updateTodoById(id);
        return ResultJson.ok(flag);
    }

}
