package com.metro.auth.platform.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.PlatformSysLibrary;
import com.metro.auth.platform.domain.auth.PlatformSysLibraryExample;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.mapper.PlatformSysLibraryMapper;
import com.metro.auth.platform.utils.DateUtil;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JwtUtils;
import com.metro.auth.platform.viewformat.DataDictClass;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Slf4j
@Service
public class PlatformSysLibraryServiceImpl implements PlatformSysLibraryService{
    @Resource
    private PlatformSysLibraryMapper platformSysLibraryMapper;
    private final JwtUtils jwtTokenUtil;
    public PlatformSysLibraryServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }
    @Resource
    public HttpAPIService httpAPIService;
    @Override
    @DataDictClass
    public List<PlatformSysLibrary> selectByExample(PlatformSysLibrary platformSysLibrary) {
        PlatformSysLibraryExample example = new PlatformSysLibraryExample();
        PlatformSysLibraryExample.Criteria criteria=example.createCriteria();
        criteria.andTypeEqualTo(platformSysLibrary.getType());
        example.setNum(Integer.parseInt( platformSysLibrary.getNum()));
        return platformSysLibraryMapper.selectByExample(example);
    }
    @Override
    @DataDictClass
    public List<PlatformSysLibrary> selectByExampleForinterface(PlatformSysLibrary platformSysLibrary) {
        PlatformSysLibraryExample example = new PlatformSysLibraryExample();
        PlatformSysLibraryExample.Criteria criteria=example.createCriteria();
        criteria.andTypeEqualTo(platformSysLibrary.getType());
        criteria.andStatusEqualTo(platformSysLibrary.getStatus());
        example.setNum(Integer.parseInt( platformSysLibrary.getNum()));
        return platformSysLibraryMapper.selectByExampleForinterface(example);
    }
    @Override
    public  int savePlatformSysLibrary(PlatformSysLibrary entity){
        int flag=0;
        Date d = new Date();
       //获取最新id
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        entity.setId(uuid);
        entity.setCtime(DateUtil.getCurTime());
            flag=platformSysLibraryMapper.insert(entity);
        return flag;
        }
    /**
     *
     * @param entity
     * @return
     */
    @Override
    public  int saveUpdatePlatformSysLibrary(PlatformSysLibrary entity){
        int flag=0;
         flag=platformSysLibraryMapper.updateByPrimaryKey(entity);
        return flag;
    }

    /**
     *
     * @param id
     * @return
     */
        @Override
        public int delPlatformSysLibrary(String id){
            int flag=platformSysLibraryMapper.deleteByPrimaryKey(id);

            return flag;
            }

    /**
     *根据id更新启用状态
     * @param entity
     * @return
     */
    @Override
            public  int updatePlatformSysLibraryStatusById(PlatformSysLibrary entity){
            int flag=0;
                //更改状态
               flag= platformSysLibraryMapper.updateStatusByPrimaryKey(entity);
            return  flag;
            }

    /**
     *
     * @param platformSysLibrary
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    @DataDictClass
        public PageInfo<PlatformSysLibrary> pagedlist(PlatformSysLibrary platformSysLibrary, int pageNum, int pageSize) {

            PageHelper.startPage(pageNum, pageSize);
        PlatformSysLibraryExample platformSysAdvExample = new PlatformSysLibraryExample();
        PlatformSysLibraryExample.Criteria criteria = platformSysAdvExample.createCriteria();
            //搜索
            if (platformSysLibrary!=null){
                if (!EmptyUtilHelper.isEmpty(platformSysLibrary.getTitle())){
                    criteria.andTitleLike( "%"+platformSysLibrary.getTitle()+"%");
                }
                if (!EmptyUtilHelper.isEmpty(platformSysLibrary.getType())){
                    criteria.andTypeEqualTo(platformSysLibrary.getType());
                }
                if (!EmptyUtilHelper.isEmpty(platformSysLibrary.getStatus())){
                    criteria.andStatusEqualTo(platformSysLibrary.getStatus());
                }
            }
        platformSysAdvExample.setOrderByClause(" ctime desc");
            List<PlatformSysLibrary> list=platformSysLibraryMapper.selectByExample(platformSysAdvExample);
            PageInfo<PlatformSysLibrary> pageInfo = new PageInfo<>(list);

            return pageInfo;
        }
        @Override
        public  PlatformSysLibrary load(String id){
            PlatformSysLibrary platformSysLibrary=platformSysLibraryMapper.selectByPrimaryKey(id);
            return  platformSysLibrary;
        }
    /**
     * 批量启停，微信无操作
     * @param status
     * @param ids
     */
    @Override
    public void updatePlatformSysLibraryStatus(String status,String ids) {

        String[] id = ids.split(",");
        for (int i=0;i<id.length;i++ ) {
            PlatformSysLibrary platformSysLibrary=platformSysLibraryMapper.selectByPrimaryKey(id[i]);
            platformSysLibrary.setStatus(status);
            int flag=platformSysLibraryMapper.updateStatusByPrimaryKey(platformSysLibrary);

        }
    }

}
