package com.metro.auth.platform.service;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.PlatformPersonnel;
import com.metro.auth.platform.utils.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
@Slf4j
@Service
public class ScheduleTaskService {

    @Resource
    private PlatformPersonnelService platformPersonnelService;
    @Resource
    private PlatformDepartmentService platformDepartmentService;
    /**
     * 周海峰
     * 定时任务-从微信拉取用户，比较。改变更新；没有，新增。
     */
    public void reloadPlatformPersonnel(){
        PageInfo<PlatformPersonnel> pageInfo = platformPersonnelService.getPlatformPersonnelpagedlist_Weixin("1","1",1,1);
        List<PlatformPersonnel> list = pageInfo.getList();
        if(list!=null && list.size()>0){
            platformPersonnelService.updatePlatformpersonnel(list);
        }
        log.info("用户定时更新[reloadPlatformPersonnel]结束");
    }
    public void reloadPlatformPersonnel_talble(){
        //用临时表与企业微信对比，返回对比结果
        PageInfo<PlatformPersonnel> pageInfo = platformPersonnelService.getPlatformPersonnelpagedlist_Weixin("1","1",1,1);
        List<PlatformPersonnel> list = pageInfo.getList();
        //如果有变更批量更新人员信息，并执行部门更新操作
        if(list!=null && list.size()>0){
            platformPersonnelService.updatePlatformpersonnel(list);
            log.info("定时同步微信人员信息"+ DateUtil.getCurTime());
            //记录更新时间

        }else{
            platformPersonnelService.insertWeixinUserUpdateInfo();
            log.info("本次无信息更新");
        }
        log.info("用户定时更新[reloadPlatformPersonnel]结束");
    }
    public void reloadPlatformPersonnel_del_talble(){
        //用临时表与企业微信对比，返回对比结果
        PageInfo<PlatformPersonnel> pageInfo = platformPersonnelService.getPlatformPersonnelpagedlist_WeixinDelete("1","1",1,1);
        List<PlatformPersonnel> list = pageInfo.getList();
        //如果有变更批量更新人员信息，并执行部门更新操作
        if(list!=null && list.size()>0){
            platformPersonnelService.updatePlatformpersonnel_del(list);
            log.info("定时筛查异常人员信息"+ DateUtil.getCurTime());
            //记录更新时间

        }else{
            platformPersonnelService.insertWeixinUserUpdateInfo();
            log.info("本次无信息更新");
        }
        log.info("用户定时筛查[reloadPlatformPersonnel_del_talble]结束");
    }

    /**
     * 更新部门信息 11.13
     */
    public void reloadPlatformDepartment_talble(){
        platformDepartmentService.findwxdeptinfo();
        log.info("定时更新[depatrtment]结束");
    }


}
