package com.metro.auth.platform.utils;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import javax.servlet.MultipartConfigElement;

@Component
public class CommonUtil {
	
	public static String WEBSITE;
	
	public static String UPLOADFILEURL;
	
	@Value("${upload-params.ip.address}")
	public void setWEBSITE(String wEBSITE) {
		WEBSITE = wEBSITE;
	}

	@Value("${upload-params.upload-path}")
	public void setUPLOADFILEURL(String uPLOADFILEURL) {
		UPLOADFILEURL = uPLOADFILEURL;
	}
	/**
	 * 设置上传的临时目录
	 * @author qijj
	 * @return
	 */
	@Bean
	public MultipartConfigElement multipartConfigElement() {
		MultipartConfigFactory factory = new MultipartConfigFactory();
		// 设置一个临时目录
		factory.setLocation(CommonUtil.UPLOADFILEURL);
		return factory.createMultipartConfig();
	}

}
