package com.metro.auth.platform.wxmessage;

import com.alibaba.fastjson.JSONObject;
import com.metro.auth.platform.domain.WebDeptToken;
import com.metro.auth.platform.domain.WebUserToken;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.http.HttpResult;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JSONMap;
import com.metro.auth.platform.utils.JSONUtil;
import com.metro.auth.platform.utils.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @ClassName: GetWxUserinfo
 * @Description: ${description}
 * @Authror zhouy
 * @Date 2019-07-23 19:34
 */
@Slf4j
@RestController
public class GetWxDepartmentinfo {
    //中心
    private static final String CENTER_ID="cid";
    private static final String CENTER_NAME="cname";
    //部门
    private static final String DEPT_ID="did";
    private static final String DEPT_NAME="dname";


    @Value("${weixin-params.wx_tx_getlist}")
    private  String WX_TX_DEPTLIST;

    @Value("${weixin-params.wx_tx_create}")
    private  String WX_TX_CREATE;

    @Value("${weixin-params.wx_tx_update}")
    private  String WX_TX_UPDATE;

    @Value("${weixin-params.wx_tx_delete}")
    private  String WX_TX_DELETE;


    @Resource
    public HttpAPIService httpAPIService;

    /**
     * 功能描述: <br>微信获得部门信息
     * 〈〉
     * @Param: [code]
     * @Return: [code]
     * @Author: zhouy
     * @Date: 2019-09-23 20:21
     */
    @GetMapping("/weixin/wxdept/list")
    public @ResponseBody
    JSONMap<String,Object> wxdeptinfo(WebDeptToken webDeptToken){
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        String url = WX_TX_DEPTLIST+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx()+"&id="+webDeptToken.getParentid();
        log.info("构建URL为=="+url);
        String wxdeptinfolist= "";
        try{
            String wxdeptinfo = httpAPIService.doGet(url);
            log.info("wxdeptinfo 为===" +wxdeptinfo);
            String errmsg = (String) JSONUtil.getStringFromJSONObject(wxdeptinfo,"errmsg");
            if("ok".equals(errmsg)){
                wxdeptinfolist = (String) JSONUtil.getStringFromJSONObject(wxdeptinfo,"department");
            }
            model.put("errmsg",errmsg);
            model.put("wxdeptinfolist",wxdeptinfolist);
          }catch(Exception e){
            e.printStackTrace();
         }
        return model;
    }

    /**
     *新增部门
     * @param webDeptToken
     * @return
     */
    @PostMapping("/weixin/wxdept/add")
    public @ResponseBody
    JSONMap<String,Object> wxdeptinfoadd(WebDeptToken webDeptToken){
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        JSONObject object = new JSONObject();
        object.put("name",webDeptToken.getName());
        object.put("parentid",webDeptToken.getParentid());
        object.put("order",webDeptToken.getOrder());
        object.put("id",webDeptToken.getId());
        String url = WX_TX_CREATE+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
        log.info("构建URL为=="+url);
        try{
            JSONObject wxdeptinfo = httpAPIService.doPost(url,object.toString());
            log.info("wxdeptinfo 为===" +wxdeptinfo);
            model.put("errmsg",wxdeptinfo);
        }catch(Exception e){
            e.printStackTrace();
        }
        return model;
    }

    /**
     * 更新部门信息
     * @param webDeptToken
     * @return
     */
    @PutMapping("/weixin/wxdept/update")
    public @ResponseBody
    JSONMap<String,Object> wxdeptinfoupdate(WebDeptToken webDeptToken){
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        JSONObject object = new JSONObject();
        object.put("name",webDeptToken.getName());
        object.put("parentid",webDeptToken.getParentid());
        object.put("order",webDeptToken.getOrder());
        object.put("id",webDeptToken.getId());
        String url = WX_TX_UPDATE+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
        log.info("构建URL为=="+url);
        try{
            JSONObject wxdeptinfo = httpAPIService.doPost(url,object.toString());
            log.info("wxdeptinfo 为===" +wxdeptinfo);
            model.put("errmsg",wxdeptinfo);
        }catch(Exception e){
            e.printStackTrace();
        }
        return model;
    }

    /**
     * 删除部门
     * @param webDeptToken id
     * @return
     */
    @PostMapping("/weixin/wxdept/delete")
    public @ResponseBody
    JSONMap<String,Object> wxdeptinfodelete(WebDeptToken webDeptToken){
        JSONMap<String,Object> model = new JSONMap<String,Object>();
        String url = WX_TX_DELETE+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx()+"&id="+webDeptToken.getId();
        log.info("构建URL为=="+url);
        try{
            JSONObject wxdeptinfo = httpAPIService.doPost(url,"");
            log.info("wxdeptinfo 为===" +wxdeptinfo);
            model.put("errmsg",wxdeptinfo);
        }catch(Exception e){
            e.printStackTrace();
        }
        return model;
    }
}
