package com.metro.auth.platform.controller;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformDepartment;
import com.metro.auth.platform.domain.dto.DepartmentPersonneDTO;
import com.metro.auth.platform.generallog.LogAnnotation;
import com.metro.auth.platform.service.PlatformDepartmentService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@RestController
@RequestMapping("/department")
public class PlatformDepartmentController {
    @Value("${jwt.header}")
    private String tokenHeader;
    @Resource
    private PlatformDepartmentService platformDepartmentService;

    /**
     * 功能描述: <br>功能清单
     * 〈〉
     * @Param: [pageNum, pageSize, platformSysRole]
     * @Return: [pageNum, pageSize, platformSysRole]
     * @Author: zhouy
     * @Date: 2019-09-11 18:22
     */

    @GetMapping("/list/{id}")
    public ResultJson queryPlatformDepartmentById(@PathVariable String id) {
        List<PlatformDepartment> list = platformDepartmentService.queryPlatformDepartmentById(Integer.valueOf(id));
        return ResultJson.ok(list);
    }
    @GetMapping("/listbypid/{pid}")
    public ResultJson queryPlatformDepartmentByPId(@PathVariable String pid) {
        List<PlatformDepartment> list = platformDepartmentService.selectPlatformDepartmentListByPid(pid);
        return ResultJson.ok(list);
    }
     /**
     * 查询列表
     * @param pageNum
     * @param pageSize
     * @param platformDepartment
     * @return
     */
    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformDepartment platformDepartment, HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        PageInfo<PlatformDepartment> page =  platformDepartmentService.pagedlist(platformDepartment,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    /**
     * 根据id更新实体
     * @param platformDepartment
     * @return
     */
    @LogAnnotation(operateContent="部门管理",operateType="更新")
    @PutMapping("/update")
    public  ResultJson update(@RequestBody PlatformDepartment platformDepartment){
        int flag=platformDepartmentService.saveUpdatePlatformDepartment(platformDepartment);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 根据id更新实体
     * @param platformDepartment
     * @return
     */
    @LogAnnotation(operateContent="部门管理",operateType="新增")
    @PostMapping("/add")
    public  ResultJson add(@RequestBody PlatformDepartment platformDepartment){
        int flag=platformDepartmentService.savePlatformDepartment(platformDepartment);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id获取实体
     * @param id
     * @return
     */
    @GetMapping("/load")
    public  ResultJson load(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        PlatformDepartment platformDepartment=platformDepartmentService.load(id);
        if (platformDepartment!=null){
            return  ResultJson.ok(platformDepartment);
        }else {
            return  ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id删除实体
     * @param id
     * @return
     */
    @LogAnnotation(operateContent="部门管理",operateType="删除")
    @RequestMapping("/delete")
    public  ResultJson delete(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        int flag=platformDepartmentService.delPlatformDepartment(id);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 根据id更新部门启停状态
     * @return
     */
    @LogAnnotation(operateContent="部门管理",operateType="批量更新")
    @PostMapping("/updatestatus")
    public  ResultJson updatestatus(@RequestBody PlatformDepartment platformDepartment){
        int flag=platformDepartmentService.updatePlatformDepartmentStatusById(platformDepartment);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 获取所有部门信息
     * @param platformDepartment
     * @return
     */
    @GetMapping("/list")
    public  ResultJson getDeptAllMenu(PlatformDepartment platformDepartment){
        List<PlatformDepartment> accessMenu =  platformDepartmentService.selectAllMenu();
        return ResultJson.ok(accessMenu);
    }
    @GetMapping(value = "/departmentTree")
    @ApiOperation(value = "部门级的树", notes = "部门级的树")
    @ApiImplicitParams({@ApiImplicitParam(name = "Authorization", value = "参数格式 token", required = true, dataType = "string", paramType = "header"),
    })
    public ResultJson<DepartmentPersonneDTO> getDepartmentTree(HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        DepartmentPersonneDTO entity = platformDepartmentService.getDepartmentTree(token);
        return ResultJson.ok(entity);
    }

    /**
     * 批量启停用
     * @param ids
     * @param status
     * @return
     */
    @LogAnnotation(operateContent="部门管理",operateType="更新状态")
    @PutMapping("/updateDeptStatus")
    public ResultJson updateDeptStatus(String ids,String status){
        platformDepartmentService.updateDeptStatus(status,ids);
        //需对接企业微信接口
        return ResultJson.ok();
    }
    @GetMapping("/countByExample")
    public ResultJson countByExample(String id){
        long flag=platformDepartmentService.countByExample(id);
        return ResultJson.ok(flag);
    }
    @GetMapping("/searchAccount")
    public ResultJson searchAccount(String name){
        long flag=platformDepartmentService.countaccountByExample(name);
        return ResultJson.ok(flag);
    }

    /**
     * 同步企业微信部门信息
     * @return
     */
    @GetMapping("/findwxDeptinfo")
    public ResultJson findwxdeptinfo(){
        platformDepartmentService.findwxdeptinfo();
        return ResultJson.ok();
    }
}
