package com.metro.auth.platform.mapper;

import com.metro.auth.platform.domain.auth.PlatformUserFavoriteApps;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用户常用应用Mapper接口
 */
public interface PlatformUserFavoriteAppsMapper {

    /**
     * 根据用户ID获取常用应用列表
     * @param userId 用户ID
     * @return 常用应用列表
     */
    List<PlatformUserFavoriteApps> getFavoriteAppsByUserId(@Param("userId") String userId);

    /**
     * 根据用户ID和应用ID获取记录
     * @param userId 用户ID
     * @param appId 应用ID
     * @return 常用应用记录
     */
    PlatformUserFavoriteApps getFavoriteApp(@Param("userId") String userId, @Param("appId") Integer appId);

    /**
     * 添加常用应用
     * @param favoriteApp 常用应用信息
     * @return 影响行数
     */
    int insertFavoriteApp(PlatformUserFavoriteApps favoriteApp);

    /**
     * 删除常用应用
     * @param userId 用户ID
     * @param appId 应用ID
     * @return 影响行数
     */
    int deleteFavoriteApp(@Param("userId") String userId, @Param("appId") Integer appId);

    /**
     * 更新排序
     * @param userId 用户ID
     * @param appId 应用ID
     * @param sortOrder 排序值
     * @return 影响行数
     */
    int updateSortOrder(@Param("userId") String userId, @Param("appId") Integer appId, @Param("sortOrder") Integer sortOrder);

    /**
     * 获取用户未设置为常用的应用列表
     * @param userId 用户ID
     * @param keyword 搜索关键词（可选）
     * @return 未设置的应用列表
     */
    List<PlatformUserFavoriteApps> getUnfavoriteApps(@Param("userId") String userId, @Param("keyword") String keyword);
}
