package com.metro.auth.platform.controller;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.Pagination;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.entity.Todo;
import com.metro.auth.platform.service.TodoListService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("/todolist")
public class TodoListController {
    @Value("${jwt.header}")
    private String tokenHeader;
    @Resource
    private TodoListService todoListService;

    /**
     * 查询列表
     * @param pageIndex
     * @param pageSize
     * @param todo
     * @return
     */
    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageIndex",defaultValue="1") int pageIndex,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                Todo todo, HttpServletRequest request){
        PageInfo<Todo> page =  todoListService.todopagedlist(todo,pageIndex,pageSize);
        Pagination pagination = new Pagination(page.getList(),new Long(page.getTotal()),pageSize,pageIndex);
        return ResultJson.ok(pagination);
    }

}
