package com.metro.auth.platform.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.WebDeptToken;
import com.metro.auth.platform.domain.auth.*;
import com.metro.auth.platform.domain.dto.DepartmentPersonneDTO;
import com.metro.auth.platform.domain.dto.PlatformOfficeEntity;
import com.metro.auth.platform.domain.entity.DepartmentExample;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.mapper.PlatformDepartmentMapper;
import com.metro.auth.platform.mapper.PlatformNumberMapper;
import com.metro.auth.platform.mapper.PlatformPersonnelMapper;
import com.metro.auth.platform.mapper.WeixinuserupdateinfoMapper;
import com.metro.auth.platform.utils.*;
import com.metro.auth.platform.viewformat.DataDictClass;
import com.metro.auth.platform.wxmessage.ApiConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import javax.annotation.Resource;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;
@Slf4j
@Service
public class PlatformDepartmentServiceImpl implements PlatformDepartmentService{
    @Resource
    private PlatformDepartmentMapper platformDepartmentMapper;
    @Resource
    private   PlatformNumberMapper platformNumberMapper;
    @Resource
    private WeixinuserupdateinfoMapper weixinuserupdateinfoMapper;
    @Resource
    private Platform3Util platform3Util;

    @Resource
    private PlatformPersonnelMapper patformPersonnelMapper;
    @Value("${weixin-params.wx_tx_getlist}")
    private  String WX_TX_DEPTLIST;

    @Value("${weixin-params.wx_tx_create}")
    private  String WX_TX_CREATE;

    @Value("${weixin-params.wx_tx_update}")
    private  String WX_TX_UPDATE;

    @Value("${weixin-params.wx_tx_delete}")
    private  String WX_TX_DELETE;
    private final JwtUtils jwtTokenUtil;
    public PlatformDepartmentServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }
    @Resource
    public HttpAPIService httpAPIService;

    @Override
    public List<PlatformDepartment> getPlatformOfficeEntityAll() {
        return platformDepartmentMapper.getPlatformOfficeEntityAll();
    }

    @Override
    @DataDictClass

    public List<PlatformDepartment> selectByExample() {
        PlatformDepartmentExample example = new PlatformDepartmentExample();
        return platformDepartmentMapper.selectByExample(example);
    }

    @Override
    public List<PlatformDepartment> queryPlatformDepartmentById(Integer id) {
        return platformDepartmentMapper.queryPlatformDepartmentById(id);
    }
    @Override
    public List<PlatformDepartment> selectPlatformDepartmentListByPid(String pid) {
        PlatformDepartment entity=new PlatformDepartment();
        entity.setPid(pid);
        return platformDepartmentMapper.selectPlatformDepartmentListByPid(entity);
    }
    @Override
    public  int savePlatformDepartment(PlatformDepartment entity){
        int flag=0;
        Date d = new Date();
        WebDeptToken webDeptToken=new WebDeptToken();
       //获取最新id
        PlatformNumber platformNumber=new PlatformNumber();
        platformNumber.setType("dept");
        platformNumber=platformNumberMapper.selectOrderByNum(platformNumber);
        entity.setId(platformNumber.getNum());
        entity.setSynchronous("0");
        entity.setAddtime(DateUtil.smartFormat(d));
        if (entity!=null&&!EmptyUtilHelper.isEmpty(entity.getId())){
            flag=platformDepartmentMapper.insert(entity);
        }
        if (flag>0){
        platformNumber.setNum(platformNumber.getNum()+1);
        platformNumberMapper.updateByPrimaryKeySelective(platformNumber);
        webDeptToken.setId(entity.getId().toString());
        webDeptToken.setName(entity.getName());
        webDeptToken.setOrder(entity.getId().toString());
        webDeptToken.setParentid(entity.getPid());

        //同步企业微信
//            boolean resultstatus=this.wxdeptinfoadd(webDeptToken);
//            PlatformDepartment platformDepartment=platformDepartmentMapper.selectByPrimaryKey(entity.getId());
//            if (resultstatus) {
//                platformDepartment.setSynchronous("1");
//            }else{
//                platformDepartment.setSynchronous("2");
//            };
//            platformDepartmentMapper.updateByPrimaryKey(platformDepartment);
        }
        return flag;
        }

    /**
     *
     * @param entity
     * @return
     */
    @Override
    public  int saveUpdatePlatformDepartment(PlatformDepartment entity){
        int flag=0;
        WebDeptToken webDeptToken=new WebDeptToken();
         flag=platformDepartmentMapper.updateByPrimaryKey(entity);
        webDeptToken.setId(entity.getId().toString());
        webDeptToken.setName(entity.getName());
        webDeptToken.setOrder(entity.getId().toString());
        webDeptToken.setParentid(entity.getPid());
        entity.setSynchronous("0");

        //同步企业微信
//        if (flag>0){
//            boolean resultstatus=this.wxdeptinfoupdate(webDeptToken);
//            PlatformDepartment platformDepartment=platformDepartmentMapper.selectByPrimaryKey(entity.getId());
//            if (resultstatus) {
//                platformDepartment.setSynchronous("1");
//            }else{
//                platformDepartment.setSynchronous("2");
//            };
//            platformDepartmentMapper.updateByPrimaryKey(platformDepartment);
//        }
        return flag;
    }

    /**
     *
     * @param id
     */
        @Override
        public int delPlatformDepartment(String id){
            int flag=platformDepartmentMapper.deleteByPrimaryKey(Integer.parseInt(id));
            //同步微信
//            if (flag>0){
//                boolean resultstatus=  this.wxdeptinfodelete(id);
//                log.info("resultstatus为===" +resultstatus);
//            }
            return flag;
            }

    /**
     *根据id更新部门的启用状态
     * @param entity
     * @return
     */
    @Override
            public  int updatePlatformDepartmentStatusById(PlatformDepartment entity){
            int flag=0;
                //更改状态
               flag= platformDepartmentMapper.updateStatusByPrimaryKey(entity);
               //企业微信删除
//                if (flag>0){
//                    boolean resultstatus=  this.wxdeptinfodelete(entity.getId().toString());
//                    log.info("resultstatus为===" +resultstatus);
//                }
            return  flag;
            }

    /**
     *
     * @param platformDepartment
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    @DataDictClass
        public PageInfo<PlatformDepartment> pagedlist(PlatformDepartment platformDepartment, int pageNum, int pageSize) {

            PageHelper.startPage(pageNum, pageSize);
            PlatformDepartmentExample platformDepartmentExample = new PlatformDepartmentExample();
            PlatformDepartmentExample.Criteria criteria = platformDepartmentExample.createCriteria();
            //搜索
            if (platformDepartment!=null){
                if (!EmptyUtilHelper.isEmpty(platformDepartment.getName())){
                    criteria.andNameLike("%"+platformDepartment.getName() +"%");
                }
                if (!EmptyUtilHelper.isEmpty(platformDepartment.getPid())){
                    criteria.andPidEqualTo(platformDepartment.getPid());
                }
            }
            List<PlatformDepartment> list=platformDepartmentMapper.selectByExample(platformDepartmentExample);
        for (int i=0;i<list.size();i++ ) {
            PlatformDepartment entity=list.get(i);
            PlatformDepartment PlatformDepartment=new PlatformDepartment();
            PlatformDepartment.setPid(entity.getId().toString());
            PlatformDepartment= platformDepartmentMapper.countchildByPlatformDepartment(PlatformDepartment);
            list.get(i).setNum(PlatformDepartment.getNum());
        }
            PageInfo<PlatformDepartment> pageInfo = new PageInfo<>(list);

            return pageInfo;
        }
        @Override
        public  PlatformDepartment load(String id){

            if(StringUtils.isBlank(id)){
                return null;
            }

            PlatformDepartment platformDepartment=platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(id));
            return  platformDepartment;
        }

    /**
     * 更新部门同步企业微信
     * @param webDeptToken
     * @return
     */
    public boolean  wxdeptinfoupdate(WebDeptToken webDeptToken){
                boolean flag=false;
                JSONObject object = new JSONObject();
                object.put("name",webDeptToken.getName());
                object.put("parentid",webDeptToken.getParentid());
                object.put("order",webDeptToken.getOrder());
                object.put("id",webDeptToken.getId());
                String url = WX_TX_UPDATE+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
                log.info("构建URL为=="+url);
                try{
                    JSONObject wxdeptinfo = httpAPIService.doPost(url,object.toString());
                    String errmsg = wxdeptinfo.getString("errmsg");
                    log.info("errmsg 为===" +errmsg);
                    if ("updated".equals(errmsg)){ flag=true;}
                }catch(Exception e){
                    e.printStackTrace();
                }
                return flag;
        }

    /**
     * 新增部门同步企业微信
     * @param webDeptToken
     * @return
     */
    public boolean  wxdeptinfoadd(WebDeptToken webDeptToken){
        boolean flag=false;
        JSONObject object = new JSONObject();
        object.put("name",webDeptToken.getName());
        object.put("parentid",webDeptToken.getParentid());
        object.put("order",webDeptToken.getOrder());
        object.put("id",webDeptToken.getId());
        String url = WX_TX_CREATE+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
        log.info("构建URL为=="+url);
        try{
            JSONObject wxdeptinfo = httpAPIService.doPost(url,object.toString());
            String errmsg = wxdeptinfo.getString("errmsg");
            log.info("errmsg 为===" +errmsg);
            if ("created".equals(errmsg)){ flag=true;}
        }catch(Exception e){
            e.printStackTrace();
        }
        return flag;
    }
    public boolean  wxdeptinfodelete(String id){
        boolean flag=false;
         String url = WX_TX_DELETE+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx()+"&id="+id;
        log.info("构建URL为=="+url);
        try{
            JSONObject wxdeptinfo = httpAPIService.doPost(url,"");
            String errmsg = wxdeptinfo.getString("errmsg");
            log.info("wxdeptinfo 为===" +wxdeptinfo);
            if ("deleted".equals(errmsg)){ flag=true;}
        }catch(Exception e){
            e.printStackTrace();
        }
        return flag;
    }
    @Override
    @DataDictClass
    public List<PlatformDepartment> selectAllMenu() {
        PlatformDepartmentExample platformDepartmentExample = new PlatformDepartmentExample();
        List<PlatformDepartment> list = platformDepartmentMapper.selectByExample(platformDepartmentExample);
        return this.makeTree(list,"1");
    }
    /**
     * 功能描述: <br>树结构封装--
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-09-10 22:35
     */

    private List<PlatformDepartment> makeTree(List<PlatformDepartment> list,String parentId){

        Map<String, List<PlatformDepartment>> collect = list.stream().collect(Collectors.groupingBy(PlatformDepartment::getPid));
        //树形结构 肯定有一个根部，我的这个根部的就是parentId.euqal("0"),而且只有一个就get（"0"）
        List<PlatformDepartment> treeMenuNode = collect.get("1");
        if(treeMenuNode!=null&&treeMenuNode.size()>0){
            treeMenuNode.stream().forEach(item->{
                this.forEach(collect,item);
            });
        }
        return treeMenuNode;
    }
    /**
     * 功能描述: <br>树结构递归
     * 〈〉
     * @Param: [collect, treeMenuNode]
     * @Return: [collect, treeMenuNode]
     * @Author: zhouy
     * @Date: 2019-09-10 14:09
     */
    private void forEach(Map<String, List<PlatformDepartment>> collect, PlatformDepartment treeMenuNode) {
        List<PlatformDepartment> treeMenuNodes = collect.get(treeMenuNode.getId());
        if(collect.get(treeMenuNode.getId())!=null){
            treeMenuNodes.stream().sorted(Comparator.comparing(PlatformDepartment::getId)).collect(Collectors.toList());
            treeMenuNode.setChildren(treeMenuNodes);
            treeMenuNode.getChildren().forEach(t->{
                forEach(collect,t);
            });
        }
    }
    /**
     * 部门树不含员工
     * @param
     * @return
     */
    @Override
    public DepartmentPersonneDTO getDepartmentTree(String token){
        UserDetail userDetail = jwtTokenUtil.getUserFromToken(token);
        PlatformPersonnel entity=patformPersonnelMapper.selectByAccount(userDetail.getUsername());
        String fuze="10000";
        String isadmin="0";
        List<Integer> list_fuze;
        //TODO
        if (entity!=null ){
            if (!"1".equals(entity.getIsadmin())){

                if (!EmptyUtilHelper.isEmpty(entity.getFuze())){
                    fuze=entity.getFuze();
//                    list_fuze=fuze.split(",");
//                    for(int i = 0; i < list_fuze.length; i++){
//                        list_fuzeint.add(Integer.parseInt(list_fuze[i]));
//                    }

                }
            }else{
                isadmin="1";
            }
        }
        DepartmentPersonneDTO dto = new DepartmentPersonneDTO();
        //获取所有组织部门
        DepartmentExample de = new DepartmentExample();
        de.setOrderByClause(" id desc ");
        DepartmentExample.Criteria criteria = de.createCriteria();
//        criteria.andIdIn(list_fuzeint);
        List<DepartmentPersonneDTO> deptlist = platformDepartmentMapper.getDepartmentPersonneDTOList(de);
        //构造数据
        for (int i = 0; i < deptlist.size(); i++) {
            deptlist.get(i).setChildren(new ArrayList<Object>());
            if ("0".equals(deptlist.get(i).getPid())){
                dto = deptlist.get(i);
                break;
            }
        }
        //将部门放在部门下
        dto = this.getDepartmentPersonneDTO(dto,deptlist);
        return dto;
    }
    /**
     * 构造数据
     * @param dto
     * @param list
     */
    private DepartmentPersonneDTO getDepartmentPersonneDTO(DepartmentPersonneDTO dto, List<DepartmentPersonneDTO> list){
        for (int i = 0; i < list.size(); i++) {
            if(dto.getId().toString().equals(list.get(i).getPid())){
                DepartmentPersonneDTO cu = list.get(i);
                List<Object> childist = dto.getChildren()==null?new ArrayList<Object>():dto.getChildren();
                childist.add(cu);
                this.getDepartmentPersonneDTO(cu,list);
            }
        }
        return dto;
    }

    /**
     * 批量启停，微信无操作
     * @param status
     * @param ids
     */
    @Override
    public void updateDeptStatus(String status,String ids) {

        String[] id = ids.split(",");
        for (int i=0;i<id.length;i++ ) {
            PlatformDepartment platformDepartment=platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(id[i]));
            platformDepartment.setStatus(status);
            int flag=platformDepartmentMapper.updateStatusByPrimaryKey(platformDepartment);

        }
    }
    @Override
    public  long countByExample(String id){
        PlatformDepartmentExample platformDepartmentExample = new PlatformDepartmentExample();
        PlatformDepartmentExample.Criteria criteria = platformDepartmentExample.createCriteria();
        criteria.andPidEqualTo(id);
            long flag=platformDepartmentMapper.countByExample(platformDepartmentExample);
            return  flag;
    }
    @Override
    public  long countaccountByExample(String name){
        PlatformDepartmentExample platformDepartmentExample = new PlatformDepartmentExample();
        PlatformDepartmentExample.Criteria criteria = platformDepartmentExample.createCriteria();
        criteria.andNameEqualTo(name);
        long flag=platformDepartmentMapper.countByExample(platformDepartmentExample);
        return  flag;
    }


    /**
     * 同步企业微信部门信息
     * @return
     */
    @Override
    public void  findwxdeptinfo(){

        JSONArray jsonArray = getSourceData(Platform3Util.SOURCE_TYPE);

        try{
            // TODO 同步部门
            AtomicInteger index= new AtomicInteger();
            jsonArray.forEach(t->{
                JSONObject jsonObject = (JSONObject) t;

                PlatformDepartment platformDepartment = new PlatformDepartment();
                platformDepartment=platformDepartmentMapper.selectByPrimaryKey(jsonObject.getInteger("id"));
                if (platformDepartment==null && !"离职隐藏".equals(jsonObject.getString("name")) && !"开发测试".equals(jsonObject.getString("name")) && StringUtils.isNotEmpty(jsonObject.getString("parentid"))){
                    platformDepartment = new PlatformDepartment();
                    platformDepartment.setId(jsonObject.getInteger("id"));
                    platformDepartment.setName(jsonObject.getString("name"));
                    platformDepartment.setPid(jsonObject.getString("parentid"));
                    platformDepartment.setNum(jsonObject.getString("order"));
                    platformDepartment.setStatus("1");
                    platformDepartment.setSynchronous("1");
                    platformDepartment.setOrdernum(jsonObject.getString("id"));
                    platformDepartment.setLevel(jsonObject.getString("level"));
                    platformDepartment.setBranchCompanyId(jsonObject.getString("branchCompanyId"));

                    //判断level
                    int pid=Integer.parseInt(platformDepartment.getPid());
                    PlatformDepartment  platformDepartment_parent=platformDepartmentMapper.selectByPrimaryKey(pid);
                    if (platformDepartment_parent!=null && StringUtils.isNotEmpty(platformDepartment_parent.getLevel())){
                        if ( ("0").equals(platformDepartment_parent.getLevel()) ){
                            platformDepartment.setLevel("1");
                        }else if (("1").equals(platformDepartment_parent.getLevel())){
                            platformDepartment.setLevel("2");
                        }else if (("2").equals(platformDepartment_parent.getLevel())){
                            platformDepartment.setLevel("3");
                        }else if (("3").equals(platformDepartment_parent.getLevel())){
                            platformDepartment.setLevel("4");
                        }else if (("4").equals(platformDepartment_parent.getLevel())){
                            platformDepartment.setLevel("5");
                        }
                    }

                    platformDepartment.setAddtime(DateUtil.getCurTime());
                    platformDepartmentMapper.insert(platformDepartment);
                index.getAndIncrement();
                log.info("第"+ index+"条数据同步完成");
                }else{
                    log.info("此部门本地已存在");
                }
            });
//            String errmsg = wxdeptinfo.getString("errmsg");
//            log.info("errmsg 为===" +errmsg);

            //插入更新记录
            Weixinuserupdateinfo weixinuserupdateinfo = new Weixinuserupdateinfo();
            weixinuserupdateinfo.setId(DateUtil.getNumberByDateTime());
            weixinuserupdateinfo.setUpdatetime(DateUtil.getCurTime());
            weixinuserupdateinfo.setCount(index.toString());
            weixinuserupdateinfo.setType("3");
            weixinuserupdateinfoMapper.insert(weixinuserupdateinfo);
            //遍历部门信息,跟新部门级别
//            DepartmentExample example=new DepartmentExample();
//            List<DepartmentPersonneDTO> deptlist=platformDepartmentMapper.getDepartmentPersonneDTOList(example);
//

        }catch(Exception e){
            e.printStackTrace();
        }
    }

    private JSONArray getSourceData(String sourceType) {

        JSONArray jsonArray = null;

        if(Platform3Util.SOURCE_TYPE_WECHAT.equals(sourceType)){
            JSONObject object = new JSONObject();
            String url = "https://qyapi.weixin.qq.com/cgi-bin/department/list?access_token="+ SpringUtil.getBean(ApiConfig.class).getAccessToken_Tx();
            log.info("构建URL为=="+url);

            JSONObject wxdeptinfo = httpAPIService.doPost(url,object.toString());
            jsonArray = wxdeptinfo.getJSONArray("department");
        }
        if(Platform3Util.SOURCE_TYPE_PLATFORM3.equals(sourceType)){

            JSONArray source = platform3Util.getOfficeList();
            //改结构
            jsonArray = platform3Util.convertOfficeList(source);
        }

        return jsonArray;
    }



    @Override
    public  void updatePlatformDepartmentFromweixin(String ChangeType,PlatformDepartment entity, String branchCompanyId){
        PlatformDepartment platformDepartment= platformDepartmentMapper.selectByPrimaryKey(entity.getId());
        if (ChangeType.equals("create_party")){
                this.findwxdeptinfo();
        }else if (ChangeType.equals("update_party") && platformDepartment!=null){

                if (StringUtils.isNotEmpty(entity.getName())){
                    platformDepartment.setName(entity.getName());
                }
                if (StringUtils.isNotEmpty(entity.getPid())){
                    PlatformDepartment  platformDepartment_parent=platformDepartmentMapper.selectByPrimaryKey(Integer.parseInt(entity.getPid()));
                    if (platformDepartment_parent!=null && StringUtils.isNotEmpty(platformDepartment_parent.getLevel())){
                        if ( ("0").equals(platformDepartment_parent.getLevel()) ){
                            platformDepartment.setLevel("1");
                        }else if (("1").equals(platformDepartment_parent.getLevel())){
                            platformDepartment.setLevel("2");
                        }else if (("2").equals(platformDepartment_parent.getLevel())){
                            platformDepartment.setLevel("3");
                        }else if (("3").equals(platformDepartment_parent.getLevel())){
                            platformDepartment.setLevel("4");
                        }else if (("4").equals(platformDepartment_parent.getLevel())){
                            platformDepartment.setLevel("5");
                        }
                    }
                    platformDepartment.setPid(entity.getPid());
                }
                platformDepartment.setAddtime(entity.getAddtime());
                if(StringUtils.isNotEmpty(branchCompanyId)) {
                    platformDepartment.setBranchCompanyId(branchCompanyId);
                }

                platformDepartmentMapper.updatePlatformDepartmentByPrimaryKeyFromweixin(platformDepartment);

        }else if (ChangeType.equals("delete_party") && platformDepartment!=null){
//                platformDepartmentMapper.deleteByPrimaryKey(entity.getId());
            platformDepartment.setStatus("0");
            if(StringUtils.isNotEmpty(branchCompanyId)) {
                platformDepartment.setBranchCompanyId(branchCompanyId);
            }
            platformDepartmentMapper.updatePlatformDepartmentStatusByPrimaryKeyFromweixin(platformDepartment);
        }


    }
}
