package com.metro.auth.platform.service;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.PageResult;
import com.metro.auth.platform.domain.auth.PlatformDepartment;
import com.metro.auth.platform.domain.auth.PlatformPersonnel;
import com.metro.auth.platform.domain.auth.PlatformPersonnelExample;
import com.metro.auth.platform.domain.dto.DepartmentPersonneDTO;
import com.metro.auth.platform.viewformat.DataDictClass;
import org.springframework.cache.annotation.CacheEvict;

import java.util.List;

public interface PlatformPersonnelService {

    List<PlatformPersonnel> getPlatformUserEntityAll();

    /**
     * 获得所有部门人员： http://ditie.wbb.aizhuanxing.com/index/jiekou/view_deptall/
     * @return
     */
    List<PlatformPersonnel> selectByExample();

    /**
     * 根据部门id查询用户信息：http://ditie.wbb.aizhuanxing.com/index/jiekou/personnel?dept=
     */


    /**
     *根据工号查询员工信息：http://ditie.wbb.aizhuanxing.com/index/jiekou/account_sel?account=1128
     */
    PlatformPersonnel selectByAccount(String account);
    List<PlatformPersonnel> getPlatformPersonnelBybirthday();
    /**
     *根据部门ID查询： http://ditie.wbb.aizhuanxing.com/index/jiekou/dept_user?id=8
     */


    /**
     * 查询所有员工接口 http://ditie.wbb.aizhuanxing.com/index/jiekou/users?page=1&limit=8000&state=1
     */

    PageInfo<PlatformPersonnel> pagedlist(PlatformPersonnel platformPersonnel, int pageNum, int pageSize,String token);
    PageInfo<PlatformPersonnel> pagedlistByToken(PlatformPersonnel platformPersonnel, int pageNum, int pageSize,String token);

    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    int delUser(String id);
    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    void delUsers(String ids);
    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    void updateUsersStatus(String status,String ids);
    /**
     * 功能描述: <br>保存用户信息
     * 〈〉
     * @Param: [platformPersonnel]
     * @Return: [platformPersonnel]
     * @Author: zhouy
     * @Date: 2019-09-11 18:26
     */
    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    int savaUser(PlatformPersonnel platformPersonnel);
    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    int savenopassword(PlatformPersonnel platformPersonnel);
    /**
     * 批量下载微信用户
     * @param deptid
     * @param fetch_child
     * @return
     */
    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    int getUserinfoListFromWeixin(String deptid,String fetch_child);

    List<PlatformPersonnel> getUserList();
    int synchronousAvatar();

    /**
     * 验证密码
     * @param password
     * @return
     */
    boolean checkpassword(String password,String token);

    boolean updatepassword(String password,String token);

    boolean updatePasswordByUserid(String password,String id);

    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    boolean updateUserinfoByUserid(String userid, String branchCompanyId);
    /**
     *
     * @return
     */
    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    boolean getweixinisleaderindeptByaccount();

   void getUserDepartmentStatus();

//    DepartmentPersonneDTO getDepartmentPersonneDTO2(String dept);

    DepartmentPersonneDTO getDepartmentPersonneDTO();

    /**
     * zhf
     * 20200402
     * 根据部门ID获取基础平台用户列表和微信的用户列表并且进行比较
     * @param deptid 部门id
     * @param fetch_child 是否递归获取子部门下面的成员：1-递归获取，0-只获取本部门
     * @return
     */
    @CacheEvict(value = "viewDeptall",key = "'tree'")//清除组织树结构的缓存
    PageInfo<PlatformPersonnel> getPlatformPersonnelpagedlist_Weixin(String deptid,String fetch_child,int pageNum, int pageSize);

    /**
     * zhf 20220128
     * 只是跟新用户头像
     */
     void avatarUpdate() throws Exception;

    PageInfo<PlatformPersonnel> getPlatformPersonnelpagedlist_WeixinDelete(String deptid,String fetch_child,int pageNum, int pageSize);
    /**
     * 根据同微信的对比，去更新用户或新增用户
     * @param list
     * @return
     */
    int updatePlatformpersonnel(List<PlatformPersonnel> list);
    int updatePlatformpersonnel_del(List<PlatformPersonnel> list);
    void wixinAvatar2loaclFileBatch();
    void updateMetroCenter();
    void insertWeixinUserUpdateInfo();
    /**
     * 根据userid查询用户信息
     * @return
     */
    PlatformPersonnel getPlatformPersonnelByUserid(int userid);

    /**
     * 企业微信异步请求，更新通讯录信息
     * //清除组织树结构的缓存
     */
    @CacheEvict(value = "viewDeptall",key = "'tree'")
    int updatePlatformpersonnelFromweixin(String UserID,String NewUserID,String ChangeType, Integer insertUserId, String branchCompanyId);
}
