package com.metro.auth.platform.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.util.StringUtil;
import com.metro.auth.platform.domain.auth.PlatformRecipes;
import com.metro.auth.platform.domain.auth.PlatformRecipesExample;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.mapper.PlatformRecipesMapper;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JwtUtils;
import com.metro.auth.platform.viewformat.DataDictClass;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Slf4j
@Service
public class PlatformRecipesServiceImpl implements PlatformRecipesService {
    @Resource
    private PlatformRecipesMapper platformRecipesMapper;
    private final JwtUtils jwtTokenUtil;

    public PlatformRecipesServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }

    @Resource
    public HttpAPIService httpAPIService;

    @Override
    @DataDictClass
    public List<PlatformRecipes> selectByExample(PlatformRecipes platformRecipes) {
        PlatformRecipesExample example = new PlatformRecipesExample();
        PlatformRecipesExample.Criteria criteria = example.createCriteria();
        if (!EmptyUtilHelper.isEmpty(platformRecipes.getDatetime())) {
            criteria.andDatetimeGreaterThanOrEqualTo(platformRecipes.getDatetime());
        }
        if (!EmptyUtilHelper.isEmpty(platformRecipes.getLine())) {
            criteria.andLineEqualTo(platformRecipes.getLine());
        }
        criteria.andStatusEqualTo("1");
        example.setOrderByClause(" datetime asc");

        return platformRecipesMapper.selectByExample(example);
    }

    @Override
    @DataDictClass
    public List<PlatformRecipes> selectByExampleForexcel(PlatformRecipes platformRecipes) {
        PlatformRecipesExample example = new PlatformRecipesExample();
        PlatformRecipesExample.Criteria criteria = example.createCriteria();
        if (!EmptyUtilHelper.isEmpty(platformRecipes.getDatetime())) {
            criteria.andDatetimeGreaterThanOrEqualTo(platformRecipes.getDatetime());
        }
        if (!EmptyUtilHelper.isEmpty(platformRecipes.getLine())) {
            criteria.andLineEqualTo(platformRecipes.getLine());
        }
//        criteria.andStatusEqualTo("1");
        example.setOrderByClause(" datetime asc");

        return platformRecipesMapper.selectByExample(example);
    }

    @Override
    public int savePlatformRecipes(PlatformRecipes entity) {
        int flag = 0;
        Date d = new Date();
        //获取最新id
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        entity.setId(uuid);
        if (StringUtil.isEmpty(entity.getStatus())) {
            entity.setStatus("1");
        }
        flag = platformRecipesMapper.insert(entity);
        return flag;
    }

    /**
     * @param entity
     * @return
     */
    @Override
    public int saveUpdatePlatformRecipes(PlatformRecipes entity) {
        int flag = 0;
        flag = platformRecipesMapper.updateByPrimaryKey(entity);
        return flag;
    }

    /**
     * @param id
     * @return
     */
    @Override
    public int delPlatformRecipes(String id) {
        int flag = platformRecipesMapper.deleteByPrimaryKey(id);

        return flag;
    }

    /**
     * 根据id更新启用状态
     *
     * @param entity
     * @return
     */
    @Override
    public int updatePlatformRecipesStatusById(PlatformRecipes entity) {
        int flag = 0;
        //更改状态
        flag = platformRecipesMapper.updateStatusByPrimaryKey(entity);
        return flag;
    }

    /**
     * @param platformRecipes
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
    @DataDictClass
    public PageInfo<PlatformRecipes> pagedlist(PlatformRecipes platformRecipes, int pageNum, int pageSize) {

        PageHelper.startPage(pageNum, pageSize);
        PlatformRecipesExample platformRecipesExample = new PlatformRecipesExample();
        PlatformRecipesExample.Criteria criteria = platformRecipesExample.createCriteria();
        //搜索
        if (platformRecipes != null) {
            if (!EmptyUtilHelper.isEmpty(platformRecipes.getTitle())) {
                criteria.andTitleLike("%" + platformRecipes.getTitle() + "%");
            }
            if (!EmptyUtilHelper.isEmpty(platformRecipes.getLine())) {
                criteria.andLineLike("%" + platformRecipes.getLine() + "%");
            }
            if (!EmptyUtilHelper.isEmpty(platformRecipes.getDatetime())) {
                criteria.andDatetimeEqualTo(platformRecipes.getDatetime());
            }
        }
        platformRecipesExample.setOrderByClause(" datetime desc");
        List<PlatformRecipes> list = platformRecipesMapper.selectByExample(platformRecipesExample);
        PageInfo<PlatformRecipes> pageInfo = new PageInfo<>(list);

        return pageInfo;
    }

    @Override
    public PlatformRecipes load(String id) {
        PlatformRecipes platformRecipes = platformRecipesMapper.selectByPrimaryKey(id);
        return platformRecipes;
    }

    /**
     * 批量启停，微信无操作
     *
     * @param status
     * @param ids
     */
    @Override
    public void updateRecipesStatus(String status, String ids) {

        String[] id = ids.split(",");
        for (int i = 0; i < id.length; i++) {
            PlatformRecipes platformRecipes = platformRecipesMapper.selectByPrimaryKey(id[i]);
            platformRecipes.setStatus(status);
            int flag = platformRecipesMapper.updateStatusByPrimaryKey(platformRecipes);

        }
    }

    @Override
    public PlatformRecipes loadByDateAndLine(Map params) {
        PlatformRecipes platformRecipes = platformRecipesMapper.loadByDateAndLine(params);
        return platformRecipes;
    }

    @Override
    @DataDictClass
    public PageInfo<PlatformRecipes> pagedlisthome(PlatformRecipes platformRecipes, int pageNum, int pageSize) {

        PageHelper.startPage(pageNum, pageSize);
        PlatformRecipesExample platformRecipesExample = new PlatformRecipesExample();
        PlatformRecipesExample.Criteria criteria = platformRecipesExample.createCriteria();
        //搜索
        if (platformRecipes != null) {
//            if (!EmptyUtilHelper.isEmpty(platformRecipes.getTitle())){
//                criteria.andTitleLike( "%"+platformRecipes.getTitle()+"%");
//            }
            if (!EmptyUtilHelper.isEmpty(platformRecipes.getDatetime())) {
                criteria.andDatetimeEqualTo(platformRecipes.getDatetime());
            }
            if (!EmptyUtilHelper.isEmpty(platformRecipes.getLine())) {
                criteria.andLineEqualTo(platformRecipes.getLine());
            }

        }
        criteria.andStatusEqualTo("1");
        platformRecipesExample.setOrderByClause(" datetime desc");
        List<PlatformRecipes> list = platformRecipesMapper.selectByExample(platformRecipesExample);
        PageInfo<PlatformRecipes> pageInfo = new PageInfo<>(list);

        return pageInfo;
    }

    /**
     * 查询所有线路
     */
    @Override
    public List<PlatformRecipes> selectLine() {
        return platformRecipesMapper.selectLine();
    }
}
