package com.metro.auth.platform.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.SysCodelist;
import com.metro.auth.platform.domain.auth.SysCodelistExample;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.mapper.SysCodelistMapper;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JwtUtils;
import com.metro.auth.platform.viewformat.DataDictClass;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Slf4j
@Service
public class SysCodelistServiceImpl implements SysCodelistService{
    @Resource
    private SysCodelistMapper sysCodelistMapper;
    private final JwtUtils jwtTokenUtil;
    public SysCodelistServiceImpl(JwtUtils jwtTokenUtil) {
        this.jwtTokenUtil = jwtTokenUtil;
    }
    @Resource
    public HttpAPIService httpAPIService;
    @Override
    public List<SysCodelist> selectByExample(SysCodelist sysCodelist) {
        SysCodelistExample example = new SysCodelistExample();
        SysCodelistExample.Criteria criteria=example.createCriteria();
        criteria.andKindcodeEqualTo(sysCodelist.getKindcode());
        criteria.andParentcodevalueNotEqualTo("-1");
        return sysCodelistMapper.selectByExample(example);
    }

    @Override
    public  int saveSysCodelist(SysCodelist entity){
        int flag=0;
        Date d = new Date();
       //获取最新id
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        entity.setCodelistid(uuid);
            flag=sysCodelistMapper.insert(entity);
        return flag;
        }
    /**
     *
     * @param entity
     * @return
     */
    @Override
    public  int saveUpdateSysCodelist(SysCodelist entity){
        int flag=0;
         flag=sysCodelistMapper.updateByPrimaryKey(entity);
        return flag;
    }

    /**
     *
     * @param id
     * @return
     */
        @Override
        public int delSysCodelist(String id){
            int flag=sysCodelistMapper.deleteByPrimaryKey(id);

            return flag;
            }

    /**
     *根据id更新启用状态
     * @param entity
     * @return
     */
    @Override
            public  int updateSysCodelistStatusById(SysCodelist entity){
            int flag=0;
                //更改状态
//               flag= sysCodelistMapper.updateStatusByPrimaryKey(entity);
            return  flag;
            }

    /**
     *
     * @param sysCodelist
     * @param pageNum
     * @param pageSize
     * @return
     */
    @Override
        public PageInfo<SysCodelist> pagedlist(SysCodelist sysCodelist, int pageNum, int pageSize) {

            PageHelper.startPage(pageNum, pageSize);
        SysCodelistExample sysCodelistExample = new SysCodelistExample();
        SysCodelistExample.Criteria criteria = sysCodelistExample.createCriteria();
            //搜索
            if (sysCodelist!=null){
                if (!EmptyUtilHelper.isEmpty(sysCodelist.getKindcode())){
                    criteria.andKindcodeEqualTo(sysCodelist.getKindcode());
                }
                if (!EmptyUtilHelper.isEmpty(sysCodelist.getKindname())){
                    criteria.andKindnameEqualTo(sysCodelist.getKindname());
                }
                if (!EmptyUtilHelper.isEmpty(sysCodelist.getCodename())){
                    criteria.andCodenameEqualTo(sysCodelist.getCodename());
                }
                if (!EmptyUtilHelper.isEmpty(sysCodelist.getCodevalue())){
                    criteria.andCodevalueEqualTo(sysCodelist.getCodevalue());
                }
                if (!EmptyUtilHelper.isEmpty(sysCodelist.getParentcodevalue())){
                    criteria.andParentcodevalueEqualTo(sysCodelist.getParentcodevalue());
                }

            }
            List<SysCodelist> list=sysCodelistMapper.selectByExample(sysCodelistExample);
        for (int i=0;i<list.size();i++ ) {
            SysCodelist entity=list.get(i);
            SysCodelist SysCodelist=new SysCodelist();
            SysCodelist.setParentcodevalue(entity.getCodelistid());
            SysCodelist= sysCodelistMapper.countchildBySysCodelist(SysCodelist);
            list.get(i).setExt1(SysCodelist.getExt1());
        }
            PageInfo<SysCodelist> pageInfo = new PageInfo<>(list);

            return pageInfo;
        }
        @Override
        public SysCodelist load(String id){
            SysCodelist sysCodelist=sysCodelistMapper.selectByPrimaryKey(id);
            return  sysCodelist;
        }
    /**
     * 批量启停，微信无操作
     * @param status
     * @param ids
     */
    @Override
    public void updateSysAdvStatus(String status,String ids) {

        String[] id = ids.split(",");
        for (int i=0;i<id.length;i++ ) {
            SysCodelist platformSysAdv=sysCodelistMapper.selectByPrimaryKey(id[i]);
//            platformSysAdv.setStatus(status);
//            int flag=sysCodelistMapper.updateStatusByPrimaryKey(platformSysAdv);

        }
    }
    @Override
    public  long countByExample(String id){
        //TODO
        SysCodelistExample sysCodelistExample = new SysCodelistExample();
        SysCodelistExample.Criteria criteria = sysCodelistExample.createCriteria();
        criteria.andParentcodevalueEqualTo(id);
        long flag=sysCodelistMapper.countByExample(sysCodelistExample);
        return  flag;
    }
}
