package com.metro.auth.platform.utils;

import com.alibaba.fastjson.JSON;
import com.metro.auth.platform.qyweixin.model.*;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;

/**
 * ΢�Ž���xml������CDATA��ʽ��
 * @author iYjrg_xiebin
 * @date 2015��11��26������10:18:07
 */
public class JdomParseXmlUtils {
	
	/**
	 * 1��ͳһ�µ���ȡ΢�ŷ���
	 * ������ʱ���Զ�ȥ��CDMA
	 * @param xml
	 */
	@SuppressWarnings("unchecked")
	public static UnifiedorderResult getUnifiedorderResult(String xml){
		UnifiedorderResult unifieorderResult = new UnifiedorderResult();
		try { 
			StringReader read = new StringReader(xml);
			// �����µ�����ԴSAX ��������ʹ�� InputSource ������ȷ����ζ�ȡ XML ����
			InputSource source = new InputSource(read);
			// ����һ���µ�SAXBuilder
			SAXBuilder sb = new SAXBuilder();
			// ͨ������Դ����һ��Document
			Document doc;
			doc = sb.build(source);

			Element root = doc.getRootElement();// ָ���ڵ�
			List<Element> list = root.getChildren();

			if(list!=null&&list.size()>0){
				for (Element element : list) {
					/*
					 * <xml>
						   <return_code><![CDATA[SUCCESS]]></return_code>
						   <return_msg><![CDATA[OK]]></return_msg>
						   <appid><![CDATA[wx2421b1c4370ec43b]]></appid>
						   <mch_id><![CDATA[10000100]]></mch_id>
						   <nonce_str><![CDATA[IITRi8Iabbblz1Jc]]></nonce_str>
						   <sign><![CDATA[7921E432F65EB8ED0CE9755F0E86D72F]]></sign>
						   <result_code><![CDATA[SUCCESS]]></result_code>
						   <prepay_id><![CDATA[wx201411101639507cbf6ffd8b0779950874]]></prepay_id>
						   <trade_type><![CDATA[JSAPI]]></trade_type>
						</xml>
					 */
					System.out.println("key"+element.getName()+"value"+element.getText());
					
					if("return_code".equals(element.getName())){
						unifieorderResult.setReturn_code(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						unifieorderResult.setReturn_msg(element.getText());
					}
					
					if("appid".equals(element.getName())){
						unifieorderResult.setAppid(element.getText());
					}
					
					
					if("mch_id".equals(element.getName())){
						unifieorderResult.setMch_id(element.getText());
					}
					
					if("nonce_str".equals(element.getName())){
						unifieorderResult.setNonce_str(element.getText());
					}
					
					if("sign".equals(element.getName())){
						unifieorderResult.setSign(element.getText());
					}
					
					if("result_code".equals(element.getName())){
						unifieorderResult.setResult_code(element.getText());
					}
					
					if("prepay_id".equals(element.getName())){
						unifieorderResult.setPrepay_id(element.getText());
					}
					
					if("trade_type".equals(element.getName())){
						unifieorderResult.setTrade_type(element.getText());
					}
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		}  catch (IOException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
		
		return unifieorderResult;
	}
	/**
	 * 将微信撤销订单返回报文转为撤销订单结果对象
	 * @author qijj
	 * @param xml
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static ReverseResult getWxReverseOrderResult(String xml)
	{
		ReverseResult reverseResult = new ReverseResult();
		try { 
			StringReader read = new StringReader(xml);
			InputSource source = new InputSource(read);
			SAXBuilder sb = new SAXBuilder();
			Document doc;
			doc = sb.build(source);
			Element root = doc.getRootElement();
			List<Element> list = root.getChildren();
			if(list!=null&&list.size()>0){
				for (Element element : list) {
					if("return_code".equals(element.getName())){
						reverseResult.setReturn_code(element.getText());
					}
					if("return_msg".equals(element.getName())){
						reverseResult.setReturn_msg(element.getText());
					}
					if("appid".equals(element.getName())){
						reverseResult.setAppid(element.getText());
					}
					if("mch_id".equals(element.getName())){
						reverseResult.setMch_id(element.getText());
					}
					if("nonce_str".equals(element.getName())){
						reverseResult.setNonce_str(element.getText());
					}
					if("sign".equals(element.getName())){
						reverseResult.setSign(element.getText());
					}
					if("result_code".equals(element.getName())){
						reverseResult.setResult_code(element.getText());
					}
					if("err_code".equals(element.getName())){
						reverseResult.setErr_code(element.getText());
					}
					if("err_code_des".equals(element.getName())){
						reverseResult.setErr_code_des(element.getText());
					}
					if("recall".equals(element.getName())){
						reverseResult.setRecall(element.getText());
					}
					
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		}  catch (IOException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
		
		return reverseResult;
	}
	/**
	 * 将微信订单查询返回报文转为微信订单查询结果对象
	 * @author qijj
	 * @param xml
	 * @return
	 */
	public static OrderQueryResult getWxOrderQueryResult(String xml)
	{
		OrderQueryResult orderQueryResult = new OrderQueryResult();
		try { 
			StringReader read = new StringReader(xml);
			InputSource source = new InputSource(read);
			SAXBuilder sb = new SAXBuilder();
			Document doc;
			doc = sb.build(source);
			Element root = doc.getRootElement();
			List<Element> list = root.getChildren();
			if(list!=null&&list.size()>0){
				for (Element element : list) {
					if("return_code".equals(element.getName())){
						orderQueryResult.setReturn_code(element.getText());
					}
					if("return_msg".equals(element.getName())){
						orderQueryResult.setReturn_msg(element.getText());
					}
					if("appid".equals(element.getName())){
						orderQueryResult.setAppid(element.getText());
					}
					if("mch_id".equals(element.getName())){
						orderQueryResult.setMch_id(element.getText());
					}
					
					if("nonce_str".equals(element.getName())){
						orderQueryResult.setNonce_str(element.getText());
					}
					if("sign".equals(element.getName())){
						orderQueryResult.setSign(element.getText());
					}
					if("result_code".equals(element.getName())){
						orderQueryResult.setResult_code(element.getText());
					}
					if("err_code".equals(element.getName())){
						orderQueryResult.setErr_code(element.getText());
					}
					if("err_code_des".equals(element.getName())){
						orderQueryResult.setErr_code_des(element.getText());
					}
					if("device_info".equals(element.getName())){
						orderQueryResult.setDevice_info(element.getText());
					}
					if("openid".equals(element.getName())){
						orderQueryResult.setOpenid(element.getText());
					}
					if("is_subscribe".equals(element.getName())){
						orderQueryResult.setIs_subscribe(element.getText());
					}
					if("trade_type".equals(element.getName())){
						orderQueryResult.setTrade_type(element.getText());
					}
					if("trade_state".equals(element.getName())){
						orderQueryResult.setTrade_state(element.getText());
					}
					if("bank_type".equals(element.getName())){
						orderQueryResult.setBank_type(element.getText());
					}
					if("total_fee".equals(element.getName())){
						orderQueryResult.setTotal_fee(element.getText());
					}
					if("settlement_total_fee".equals(element.getName())){
						orderQueryResult.setSettlement_total_fee(element.getText());
					}
					if("fee_type".equals(element.getName())){
						orderQueryResult.setFee_type(element.getText());
					}
					if("cash_fee".equals(element.getName())){
						orderQueryResult.setCash_fee(element.getText());
					}
					if("cash_fee_type".equals(element.getName())){
						orderQueryResult.setCash_fee_type(element.getText());
					}
					if("coupon_fee".equals(element.getName())){
						orderQueryResult.setCoupon_fee(element.getText());
					}
					if("coupon_count".equals(element.getName())){
						orderQueryResult.setCoupon_count(element.getText());
					}
					if("coupon_type_$n".equals(element.getName())){
						orderQueryResult.setCoupon_type_$n(element.getText());
					}
					if("coupon_id_$n".equals(element.getName())){
						orderQueryResult.setCoupon_id_$n(element.getText());
					}
					if("coupon_fee_$n".equals(element.getName())){
						orderQueryResult.setCoupon_fee_$n(element.getText());
					}
					if("transaction_id".equals(element.getName())){
						orderQueryResult.setTransaction_id(element.getText());
					}
					if("out_trade_no".equals(element.getName())){
						orderQueryResult.setOut_trade_no(element.getText());
					}
					if("attach".equals(element.getName())){
						orderQueryResult.setAttach(element.getText());
					}
					if("time_end".equals(element.getName())){
						orderQueryResult.setTime_end(element.getText());
					}
					if("trade_state_desc".equals(element.getName())){
						orderQueryResult.setTrade_state_desc(element.getText());
					}
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		}  catch (IOException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
		
		return orderQueryResult;
	}
	/**
	 * 将刷卡支付返回报文转为刷卡支付结果对象
	 * @author qijj
	 * @param xml
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static MicroPayResult getMicroPayResult(String xml){
		MicroPayResult microPayResult = new MicroPayResult();
		try { 
			StringReader read = new StringReader(xml);
			InputSource source = new InputSource(read);
			SAXBuilder sb = new SAXBuilder();
			Document doc;
			doc = sb.build(source);
			Element root = doc.getRootElement();
			List<Element> list = root.getChildren();
			if(list!=null&&list.size()>0){
				for (Element element : list) {
					if("return_code".equals(element.getName())){
						microPayResult.setReturn_code(element.getText());
					}
					if("return_msg".equals(element.getName())){
						microPayResult.setReturn_msg(element.getText());
					}
					if("appid".equals(element.getName())){
						microPayResult.setAppid(element.getText());
					}
					if("mch_id".equals(element.getName())){
						microPayResult.setMch_id(element.getText());
					}
					if("device_info".equals(element.getName())){
						microPayResult.setDevice_info(element.getText());
					}
					if("nonce_str".equals(element.getName())){
						microPayResult.setNonce_str(element.getText());
					}
					if("sign".equals(element.getName())){
						microPayResult.setSign(element.getText());
					}
					if("result_code".equals(element.getName())){
						microPayResult.setResult_code(element.getText());
					}
					if("err_code".equals(element.getName())){
						microPayResult.setErr_code(element.getText());
					}
					if("err_code_des".equals(element.getName())){
						microPayResult.setErr_code_des(element.getText());
					}
					if("openid".equals(element.getName())){
						microPayResult.setOpenid(element.getText());
					}
					if("is_subscribe".equals(element.getName())){
						microPayResult.setIs_subscribe(element.getText());
					}
					if("trade_type".equals(element.getName())){
						microPayResult.setTrade_type(element.getText());
					}
					if("bank_type".equals(element.getName())){
						microPayResult.setBank_type(element.getText());
					}
					if("fee_type".equals(element.getName())){
						microPayResult.setFee_type(element.getText());
					}
					if("total_fee".equals(element.getName())){
						microPayResult.setTotal_fee(element.getText());
					}
					if("settlement_total_fee".equals(element.getName())){
						microPayResult.setSettlement_total_fee(element.getText());
					}
					if("coupon_fee".equals(element.getName())){
						microPayResult.setCoupon_fee(element.getText());
					}
					if("cash_fee_type".equals(element.getName())){
						microPayResult.setCash_fee_type(element.getText());
					}
					if("cash_fee".equals(element.getName())){
						microPayResult.setCash_fee(element.getText());
					}
					if("transaction_id".equals(element.getName())){
						microPayResult.setTransaction_id(element.getText());
					}
					if("out_trade_no".equals(element.getName())){
						microPayResult.setOut_trade_no(element.getText());
					}
					if("attach".equals(element.getName())){
						microPayResult.setAttach(element.getText());
					}
					if("time_end".equals(element.getName())){
						microPayResult.setTime_end(element.getText());
					}
					if("promotion_detail".equals(element.getName())){
						microPayResult.setPromotion_detail(element.getText());
					}
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		}  catch (IOException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
		
		return microPayResult;
	}
	/**
	 * 2��΢�Żص���������
	 * ������ʱ���Զ�ȥ��CDMA
	 * @param xml
	 */
	@SuppressWarnings("unchecked")
	public static WXPayResult getWXPayResult(String xml){
		WXPayResult wXPayResult = new WXPayResult();
		try { 
			StringReader read = new StringReader(xml);
			// �����µ�����ԴSAX ��������ʹ�� InputSource ������ȷ����ζ�ȡ XML ����
			InputSource source = new InputSource(read);
			// ����һ���µ�SAXBuilder
			SAXBuilder sb = new SAXBuilder();
			// ͨ������Դ����һ��Document
			Document doc;
			doc = sb.build(source);

			Element root = doc.getRootElement();// ָ���ڵ�
			List<Element> list = root.getChildren();

			if(list!=null&&list.size()>0){
				for (Element element : list) {
					System.out.println("key:"+element.getName()+"value:"+element.getText());
					
					if("return_code".equals(element.getName())){
						wXPayResult.setReturn_code(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						wXPayResult.setReturn_msg(element.getText());
					}
					
					
					if("appid".equals(element.getName())){
						wXPayResult.setAppid(element.getText());
					}
					
					if("mch_id".equals(element.getName())){
						wXPayResult.setMch_id(element.getText());
					}
					
					if("nonce_str".equals(element.getName())){
						wXPayResult.setNonce_str(element.getText());
					}
					
					if("sign".equals(element.getName())){
						wXPayResult.setSign(element.getText());
					}
					
					if("result_code".equals(element.getName())){
						wXPayResult.setResult_code(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						wXPayResult.setReturn_msg(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						wXPayResult.setReturn_msg(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						wXPayResult.setReturn_msg(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						wXPayResult.setReturn_msg(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						wXPayResult.setReturn_msg(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						wXPayResult.setReturn_msg(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						wXPayResult.setReturn_msg(element.getText());
					}
					
					if("return_msg".equals(element.getName())){
						wXPayResult.setReturn_msg(element.getText());
					}
					
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		}  catch (IOException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
		
		return wXPayResult;
	}

	
	public static void main(String[] args) {
		String xml="<xml><return_code><![CDATA[SUCCESS]]></return_code><return_msg><![CDATA[OK]]></return_msg><appid><![CDATA[wxd6b686adcb8e8faf]]></appid><mch_id><![CDATA[1243918602]]></mch_id><nonce_str><![CDATA[XQiANg9RQqLMgpM6]]></nonce_str><sign><![CDATA[D2655EC8C1C2C86D54B197657F02BC5B]]></sign><result_code><![CDATA[FAIL]]></result_code><err_code><![CDATA[NOTENOUGH]]></err_code><err_code_des><![CDATA[交易未结算资金不足，请使用可用余额退款]]></err_code_des></xml>";
		WxRefundResult entity=getWxRefundResult(xml);
		System.out.println(JSON.toJSONString(entity));
	}
	
	/**
	 * 将微信退款返回报文转为微信退款结果对象
	 * @author 周海峰
	 * @param xml
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static WxRefundResult getWxRefundResult(String xml){
		WxRefundResult wxRefundResult = new WxRefundResult();
		try { 
			StringReader read = new StringReader(xml);
			InputSource source = new InputSource(read);
			SAXBuilder sb = new SAXBuilder();
			Document doc;
			doc = sb.build(source);
			Element root = doc.getRootElement();
			List<Element> list = root.getChildren();
			if(list!=null&&list.size()>0){
				for (Element element : list) {
					if("return_code".equals(element.getName())){
						wxRefundResult.setReturn_code(element.getText());
					}
					if("return_msg".equals(element.getName())){
						wxRefundResult.setReturn_msg(element.getText());
					}
					if("appid".equals(element.getName())){
						wxRefundResult.setAppid(element.getText());
					}
					if("mch_id".equals(element.getName())){
						wxRefundResult.setMch_id(element.getText());
					}
					if("nonce_str".equals(element.getName())){
						wxRefundResult.setNonce_str(element.getText());
					}
					if("sign".equals(element.getName())){
						wxRefundResult.setSign(element.getText());
					}
					if("result_code".equals(element.getName())){
						wxRefundResult.setResult_code(element.getText());
					}
					if("err_code".equals(element.getName())){
						wxRefundResult.setErr_code(element.getText());
					}
					if("err_code_des".equals(element.getName())){
						wxRefundResult.setErr_code_des(element.getText());
					}
					if("fee_type".equals(element.getName())){
						wxRefundResult.setFee_type(element.getText());
					}
					if("total_fee".equals(element.getName())){
						wxRefundResult.setTotal_fee(element.getText());
					}
					if("settlement_total_fee".equals(element.getName())){
						wxRefundResult.setSettlement_total_fee(element.getText());
					}
					if("cash_fee_type".equals(element.getName())){
						wxRefundResult.setCash_fee_type(element.getText());
					}
					if("cash_fee".equals(element.getName())){
						wxRefundResult.setCash_fee(element.getText());
					}
					if("transaction_id".equals(element.getName())){
						wxRefundResult.setTransaction_id(element.getText());
					}
					if("out_trade_no".equals(element.getName())){
						wxRefundResult.setOut_trade_no(element.getText());
					}
					if("out_refund_no".equals(element.getName())){
						wxRefundResult.setOut_trade_no(element.getText());
					}
					if("refund_id".equals(element.getName())){
						wxRefundResult.setOut_trade_no(element.getText());
					}
					if("refund_fee".equals(element.getName())){
						wxRefundResult.setOut_trade_no(element.getText());
					}
					if("settlement_refund_fee".equals(element.getName())){
						wxRefundResult.setOut_trade_no(element.getText());
					}
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		}  catch (IOException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
		
		return wxRefundResult;
	}
	
	/**
	 * 将微信退款查询返回报文转为微信退款查询结果对象
	 * @author 周海峰
	 * @param xml
	 * @return
	 */
	public static WxRefundOrderResult getWxRefundOrderResult(String xml)
	{
		WxRefundOrderResult wxRefundOrderResult = new WxRefundOrderResult();
		try { 
			StringReader read = new StringReader(xml);
			InputSource source = new InputSource(read);
			SAXBuilder sb = new SAXBuilder();
			Document doc;
			doc = sb.build(source);
			Element root = doc.getRootElement();
			List<Element> list = root.getChildren();
			if(list!=null&&list.size()>0){
				for (Element element : list) {
					if("return_code".equals(element.getName())){
						wxRefundOrderResult.setReturn_code(element.getText());
					}
					if("return_msg".equals(element.getName())){
						wxRefundOrderResult.setReturn_msg(element.getText());
					}
					if("appid".equals(element.getName())){
						wxRefundOrderResult.setAppid(element.getText());
					}
					if("mch_id".equals(element.getName())){
						wxRefundOrderResult.setMch_id(element.getText());
					}
					if("nonce_str".equals(element.getName())){
						wxRefundOrderResult.setNonce_str(element.getText());
					}
					if("sign".equals(element.getName())){
						wxRefundOrderResult.setSign(element.getText());
					}
					if("result_code".equals(element.getName())){
						wxRefundOrderResult.setResult_code(element.getText());
					}
					if("err_code".equals(element.getName())){
						wxRefundOrderResult.setErr_code(element.getText());
					}
					if("err_code_des".equals(element.getName())){
						wxRefundOrderResult.setErr_code_des(element.getText());
					}
					if("total_fee".equals(element.getName())){
						wxRefundOrderResult.setTotal_fee(element.getText());
					}
					if("transaction_id".equals(element.getName())){
						wxRefundOrderResult.setTransaction_id(element.getText());
					}
					if("out_trade_no".equals(element.getName())){
						wxRefundOrderResult.setOut_trade_no(element.getText());
					}
					if("out_refund_no_0".equals(element.getName())){
						wxRefundOrderResult.setOut_refund_no(element.getText());
					}
					if("refund_fee_0".equals(element.getName())){
						wxRefundOrderResult.setRefund_fee(element.getText());
					}
					if("refund_status_0".equals(element.getName())){
						wxRefundOrderResult.setRefund_status(element.getText());
					}
					
					if("refund_recv_accout".equals(element.getName())){
						wxRefundOrderResult.setRefund_count(element.getText());
					}
					if("refund_success_time".equals(element.getName())){
						wxRefundOrderResult.setRefund_success_time(element.getText());
					}
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		}  catch (IOException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
		
		return wxRefundOrderResult;
	}
	
	/**
	 * 将微信退款通知结果返回报文转为微信退款结果对象
	 * @author 周海峰
	 * @param xml
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static WxRefundNotifyResult getWxRefundNotifyResult(String xml){
		WxRefundNotifyResult wxRefundNotifyResult = new WxRefundNotifyResult();
		try { 
			StringReader read = new StringReader(xml);
			InputSource source = new InputSource(read);
			SAXBuilder sb = new SAXBuilder();
			Document doc;
			doc = sb.build(source);
			Element root = doc.getRootElement();
			List<Element> list = root.getChildren();
			if(list!=null&&list.size()>0){
				for (Element element : list) {
					if("return_code".equals(element.getName())){
						wxRefundNotifyResult.setReturn_code(element.getText());
					}
					if("return_msg".equals(element.getName())){
						wxRefundNotifyResult.setReturn_msg(element.getText());
					}
					if("appid".equals(element.getName())){
						wxRefundNotifyResult.setAppid(element.getText());
					}
					if("mch_id".equals(element.getName())){
						wxRefundNotifyResult.setMch_id(element.getText());
					}
					if("nonce_str".equals(element.getName())){
						wxRefundNotifyResult.setNonce_str(element.getText());
					}
					if("req_info".equals(element.getName())){
						wxRefundNotifyResult.setReq_info(element.getText());
					}
					if("req_info".equals(element.getName())){
						wxRefundNotifyResult.setRefund_status(element.getText());
					}
					if("out_refund_no".equals(element.getName())){
						wxRefundNotifyResult.setOut_refund_no(element.getText());
					}
					
					if("refund_status".equals(element.getName())){
						wxRefundNotifyResult.setRefund_status(element.getText());
					}
				}
			}

		} catch (JDOMException e) {
			e.printStackTrace();
		}  catch (IOException e) {
			e.printStackTrace();
		}catch (Exception e) {
			e.printStackTrace();
		}
		
		return wxRefundNotifyResult;
	}
	
}
