package com.metro.auth.platform.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.http.HttpResult;
import com.metro.auth.platform.redis.RedisUtils;
import com.metro.auth.platform.wxmessage.ApiConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.MultipartConfigElement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Component
public class Platform3Util {

	@Autowired
	private RedisUtils redisUtils;
	@Resource
	public HttpAPIService httpAPIService;

	@Value("${platform3.app_id}")
	private String appId;

	@Value("${platform3.secret}")
	private String secret;

	@Value("${platform3.token_url}")
	private String tokenUrl;

	@Value("${platform3.all_depart_url}")
	private String allDepartUrl;

	@Value("${platform3.userlist_by_officeid}")
	private String userListByOfficeIdUrl;

	@Value("${platform3.user_by_staffcode}")
	private String userByStaffcodeUrl;

	@Value("${platform3.user_depart_all}")
	private String userDepartAllUrl;

	public static final String SOURCE_TYPE = "platform3";
	public static final String SOURCE_TYPE_WECHAT = "wechat";
	public static final String SOURCE_TYPE_PLATFORM3 = "platform3";


	private String getPlatform3Token() {

		Object platform3TokenObj = redisUtils.get("platform3_token");
//		if(platform3TokenObj==null || StringUtils.isBlank(String.valueOf(platform3TokenObj))){

			JSONObject object = new JSONObject();
			object.put("appId", appId);
			object.put("secret", secret);

			JSONObject res = httpAPIService.doPost(tokenUrl, object.toString());
			JSONObject data = res.getJSONObject("data");
			String token = data.getString("token");
			if(StringUtils.isNotBlank(token)){
				redisUtils.set("platform3_token", token, 604000L, TimeUnit.SECONDS);
				return token;
			}
			return null;
//		}
//		return String.valueOf(platform3TokenObj);
	}

	public JSONArray getOfficeList() {

		String platform3Token = getPlatform3Token();
		String resStr = null;
		try {
			resStr = httpAPIService.doGetHeader(allDepartUrl, platform3Token);
		} catch (Exception e) {
			e.printStackTrace();
		}
		JSONObject res = JSONObject.parseObject(resStr);
		return res.getJSONArray("data");
	}

	public JSONArray convertOfficeList(JSONArray source) {

		JSONArray target = new JSONArray();

		for (Object o : source) {
			JSONObject sourceObject = (JSONObject) o;

			JSONObject targetObject = new JSONObject();
			targetObject.put("id", sourceObject.getString("id"));
			targetObject.put("name", sourceObject.getString("name") == null ? "" : sourceObject.getString("name"));
			targetObject.put("parentid", sourceObject.getString("parentId") == null ? "" : sourceObject.getString("parentId"));
			targetObject.put("order", sourceObject.getInteger("sort") == null ? "" : sourceObject.getInteger("sort"));
			targetObject.put("level", sourceObject.getInteger("level") == null ? "" : sourceObject.getInteger("level"));

			target.add(targetObject);
		}
		return target;
	}

	public JSONArray getUserListByOfficeId(String officeId, String fetchChild) {

		String platform3Token = getPlatform3Token();
		String resStr = null;
		try {
			Map<String, Object> param = new HashMap<>();
			param.put("deep", "1".equals(fetchChild) ? true : false);
			param.put("sync", true);
			resStr = httpAPIService.doGetHeader(userListByOfficeIdUrl + officeId, platform3Token, param);
		} catch (Exception e) {
			e.printStackTrace();
		}
		JSONObject res = JSONObject.parseObject(resStr);
		return res.getJSONArray("data");
	}

	public JSONArray convertUserList(JSONArray source) {

		JSONArray target = new JSONArray();

		for (Object o : source) {
			JSONObject sourceObject = (JSONObject) o;
			JSONObject targetObject = convertUser(sourceObject);

			target.add(targetObject);
		}
		return target;
	}

	public JSONObject convertUser(JSONObject sourceObject) {

		JSONObject targetObject = new JSONObject();

		targetObject.put("id", sourceObject.getString("id"));//id
		targetObject.put("userid", sourceObject.getString("staffCode"));//工号
		targetObject.put("name", sourceObject.getString("realName") == null ? "" : sourceObject.getString("realName"));
		targetObject.put("gender", sourceObject.getString("sex") == null ? "0" : sourceObject.getString("sex"));
		targetObject.put("mobile", sourceObject.getString("phoneNumber") == null ? "" : sourceObject.getString("phoneNumber"));
		targetObject.put("telephone", sourceObject.getString("telNumber") == null ? "" : sourceObject.getString("telNumber"));
		targetObject.put("email", sourceObject.getString("email") == null ? "" : sourceObject.getString("email"));
		targetObject.put("address", sourceObject.getString("address") == null ? "" : sourceObject.getString("address"));
		targetObject.put("position", sourceObject.getString("position") == null ? "" : sourceObject.getString("position"));

		String officeId = sourceObject.getString("departId");
		if(StringUtils.isNotBlank(officeId)){
			targetObject.put("department", officeId);
			targetObject.put("main_department", officeId);
		}else{
			targetObject.put("department", sourceObject.getString("centerId") == null ? "" : sourceObject.getString("centerId"));
			targetObject.put("main_department", sourceObject.getString("centerId") == null ? "" : sourceObject.getString("centerId"));
		}
//		targetObject.put("position", "");
		targetObject.put("is_leader_in_dept", sourceObject.getString("isleader") == null ? "" : sourceObject.getString("isleader"));
		targetObject.put("avatar", "".equals(sourceObject.getString("avatar")) ? null : sourceObject.getString("avatar"));

		String status = sourceObject.getString("status");
		String userStatus = sourceObject.getString("userStatus");
		String hide = sourceObject.getString("hide");

		if("0".equals(status) && "working".equals(userStatus) && "0".equals(hide)){
			targetObject.put("status", "1");
			targetObject.put("delstatus", "0");
		}else {
			targetObject.put("status", "0");
			targetObject.put("delstatus", "1");
		}

		targetObject.put("qr_code", sourceObject.getString("qrcode") == null ? "" : sourceObject.getString("qrcode"));
		targetObject.put("alias", sourceObject.getString("nickname") == null ? "" : sourceObject.getString("nickname"));

		return targetObject;
	}

	public JSONObject getUserByStaffCode(String account){

		String platform3Token = getPlatform3Token();
		String resStr = null;
		try {
			Map<String, Object> param = new HashMap<>();
			param.put("allUser", true);
			resStr = httpAPIService.doGetHeader(userByStaffcodeUrl + account, platform3Token, param);
		} catch (Exception e) {
			e.printStackTrace();
		}
		JSONObject res = JSONObject.parseObject(resStr);
		return res.getJSONObject("data");
	}

	/**
	 * @Author wuchao
	 * @Description 三年期平台拉取所有员工、部门信息
	 * @Date  2023-11-15
	 * @Param []
	 * @return com.alibaba.fastjson.JSONObject
	 **/
	public JSONObject getDepartUserAll(){

		String platform3Token = getPlatform3Token();
		String resStr = null;
		try {
			Map<String, Object> param = new HashMap<>();
			resStr = httpAPIService.doGetHeader(userDepartAllUrl, platform3Token, param);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return JSONObject.parseObject(resStr);
	}
}
