package com.metro.auth.platform.domain.dto;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * <p>
 * 平台部门表
 * </p>
 *
 * @author zjn
 * @since 2021-07-06
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class PlatformOfficeEntity implements Serializable {

    private static final long serialVersionUID = 1L;


    // 父id
    private String parentId;

    // 区域id
    private String areaId;

    // 部门名称
    private String name;

    // 部门编码
    private String code;

    // 排序
    private Integer sort;

    // 部门类型
    private String type;

    // 部门等级
    private Integer level;

    // 是否启用 启用：0，弃用：1
    private String status;

    // 是否隐藏 0否，1是
    private String hide;

    private String branchCompanyId;

    protected String id;
    protected String appId;
    protected String dataId;
    protected String delFlag;
    protected String createBy;
    protected Date createTime;
    protected String updateBy;
    protected Date updateTime;
    protected String remarks;

    private Set<String> parentLevel = new HashSet<>();

    private Set<String> childrenLevel = new HashSet<>();


}
