package com.metro.auth.platform.service;

import com.metro.auth.platform.domain.auth.PlatformUserFavoriteApps;

import java.util.List;

/**
 * 用户常用应用Service接口
 */
public interface PlatformUserFavoriteAppsService {

    /**
     * 获取用户的常用应用列表
     * @param userId 用户ID
     * @return 常用应用列表
     */
    List<PlatformUserFavoriteApps> getFavoriteAppsByUserId(String userId);

    /**
     * 获取用户未设置为常用的应用列表
     * @param userId 用户ID
     * @param keyword 搜索关键词（可选）
     * @return 未设置的应用列表
     */
    List<PlatformUserFavoriteApps> getUnfavoriteApps(String userId, String keyword);

    /**
     * 添加常用应用
     * @param userId 用户ID
     * @param appId 应用ID
     * @param sortOrder 排序顺序
     * @return 是否成功
     */
    boolean addFavoriteApp(String userId, Integer appId, Integer sortOrder);

    /**
     * 删除常用应用
     * @param userId 用户ID
     * @param appId 应用ID
     * @return 是否成功
     */
    boolean removeFavoriteApp(String userId, Integer appId);

    /**
     * 更新常用应用排序
     * @param userId 用户ID
     * @param appId 应用ID
     * @param sortOrder 排序值
     * @return 是否成功
     */
    boolean updateFavoriteSort(String userId, Integer appId, Integer sortOrder);
}
