package com.metro.auth.platform.service;

import com.metro.auth.platform.domain.auth.PlatformApplications;
import com.metro.auth.platform.domain.auth.PlatformUserFavoriteApps;
import com.metro.auth.platform.mapper.PlatformUserFavoriteAppsMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户常用应用Service实现类
 */
@Service
public class PlatformUserFavoriteAppsServiceImpl implements PlatformUserFavoriteAppsService {

    @Resource
    private PlatformUserFavoriteAppsMapper platformUserFavoriteAppsMapper;
    @Resource
    private PlatformRoleApplicationAppService platformRoleApplicationAppService;

    @Override
    public List<PlatformUserFavoriteApps> getFavoriteAppsByUserId(String userId) {
        return platformUserFavoriteAppsMapper.getFavoriteAppsByUserId(userId);
    }

    @Override
    public List<PlatformUserFavoriteApps> getUnfavoriteApps(String userId, String keyword) {
        // 首先获取用户有权限访问的所有应用
        List<PlatformApplications> platformApplicationsAppList = platformRoleApplicationAppService.getPlatformApplicationsAppListByUserid(userId);
        if (platformApplicationsAppList == null || platformApplicationsAppList.isEmpty()) {
            return new ArrayList<>();
        }
        List<Integer> collect = platformApplicationsAppList.stream()
                .filter(item-> !StringUtils.isEmpty(item.getGroupCode()))
                .map(PlatformApplications::getId).collect(Collectors.toList());
        List<PlatformUserFavoriteApps> unfavoriteApps = platformUserFavoriteAppsMapper.getUnfavoriteApps(userId, keyword);
        return unfavoriteApps.stream().filter(app -> collect.contains(app.getAppId())).collect(Collectors.toList());
    }

    @Override
    public boolean addFavoriteApp(String userId, Integer appId, Integer sortOrder) {
        try {
            // 检查是否已存在
            PlatformUserFavoriteApps existing = platformUserFavoriteAppsMapper.getFavoriteApp(userId, appId);
            if (existing != null) {
                return false; // 已存在
            }
            
            // 设置默认排序值
            if (sortOrder == null) {
                sortOrder = 0;
            }
            
            PlatformUserFavoriteApps favoriteApp = new PlatformUserFavoriteApps();
            favoriteApp.setUserId(userId);
            favoriteApp.setAppId(appId);
            favoriteApp.setSortOrder(sortOrder);
            
            int result = platformUserFavoriteAppsMapper.insertFavoriteApp(favoriteApp);
            return result > 0;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeFavoriteApp(String userId, Integer appId) {
        try {
            int result = platformUserFavoriteAppsMapper.deleteFavoriteApp(userId, appId);
            return result > 0;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean updateFavoriteSort(String userId, Integer appId, Integer sortOrder) {
        try {
            int result = platformUserFavoriteAppsMapper.updateSortOrder(userId, appId, sortOrder);
            return result > 0;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
