-- 用户常用应用功能相关SQL脚本
-- 创建用户常用应用关联表
CREATE TABLE IF NOT EXISTS `platform_user_favorite_apps` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  `user_id` varchar(50) NOT NULL COMMENT '用户ID',
  `app_id` int(11) NOT NULL COMMENT '应用ID',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序顺序',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uk_user_app` (`user_id`, `app_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_app_id` (`app_id`),
  CONSTRAINT `fk_favorite_app` FOREIGN KEY (`app_id`) REFERENCES `platform_applications` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='用户常用应用表';

-- 添加索引优化查询性能
CREATE INDEX idx_user_favorite_create_time ON platform_user_favorite_apps(create_time);
CREATE INDEX idx_user_favorite_sort_order ON platform_user_favorite_apps(sort_order);

-- 示例数据（可选）
-- 为用户1添加一些常用应用
-- INSERT INTO platform_user_favorite_apps (user_id, app_id, sort_order) VALUES ('1', 1, 1);
-- INSERT INTO platform_user_favorite_apps (user_id, app_id, sort_order) VALUES ('1', 2, 2);
-- INSERT INTO platform_user_favorite_apps (user_id, app_id, sort_order) VALUES ('1', 3, 3);

-- 回滚脚本（如果需要删除表）
-- DROP TABLE IF EXISTS platform_user_favorite_apps;
