package com.metro.auth.platform.domain.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.data.annotation.Transient;

import java.io.Serializable;
@Data
@ApiModel(description= "具体参数描述")
public class Todo implements Serializable {
    @ApiModelProperty(value = "主键")
    private String id;

    /**
     *   待办描述
     */
    @ApiModelProperty(value = "待办描述")
    private String memo;

    /**
     *   业务类型
     */
    @ApiModelProperty(value = "业务类型")
    private String type;

    /**
     *   业务id
     */
    @ApiModelProperty(value = "业务id")
    private String buid;

    /**
     *   待办人工号
     */
    @ApiModelProperty(value = "待办人工号")
    private String account;

    /**
     *   创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private String ctime;

    /**
     *   是否已处理（0否，1是）
     */
    @ApiModelProperty(value = "是否已处理（0否，1是）")
    private String status;

    /**
     *   处理时间
     */
    @ApiModelProperty(value = "处理时间")
    private String optime;

    /**
     *   跳转路由
     */
    @ApiModelProperty(value = "跳转路由")
    private String rounter;

    /**
     *   跳转路由
     */
    @Transient
    @ApiModelProperty(value = "跳转路由")
    private String typename;


    private static final long serialVersionUID = 1L;

}