package com.metro.auth.platform.service;

import com.metro.auth.platform.domain.auth.PlatformPersonnel;
import com.metro.auth.platform.domain.auth.ResponseUserToken;
import com.metro.auth.platform.domain.auth.UserDetail;

/**
 * @author: zhouy
 * createAt: 2019/8/1
 */
public interface AuthService {
    /**
     * 注册用户
     * @param userDetail
     * @return
     */
    UserDetail register(UserDetail userDetail);

    /**
     * 登陆
     * @param username
     * @param password
     * @return
     */
    ResponseUserToken login(String username, String password);

    /**
     * 登出
     * @param token
     */
    void logout(String token);

    /**
     * 刷新Token
     * @param oldToken
     * @return
     */
    ResponseUserToken refresh(String oldToken);

    /**
     * 根据Token获取用户信息
     * @param token
     * @return
     */
    UserDetail getUserByToken(String token);
    PlatformPersonnel getUserByUserid(int userid);
    /**
     * 功能描述: <br>根据用户account查询用户信息
     * 〈〉
     * @Param: []
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-10-23 12:02
     */
     PlatformPersonnel findUserInfoByaccount(String account);

    /**
     * 根据邮箱查询账户信息
     * @param email
     * @return
     */
    PlatformPersonnel findUserInfoByemail(String email);

    /**
     *
     * @param code
     * @return
     */
    PlatformPersonnel findUserInfoByCode(String code);

    int updateCodeByUserid(String account, String code);

    int updateCodeByEmail(String email, String code);
}
