package com.metro.auth.platform.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.PlatformApplications;
import com.metro.auth.platform.domain.auth.PlatformApplicationsExample;
import com.metro.auth.platform.domain.auth.PlatformSysRole;
import com.metro.auth.platform.domain.auth.PlatformSysRoleExample;
import com.metro.auth.platform.mapper.AuthMapper;
import com.metro.auth.platform.mapper.PlatformApplicationsMapper;
import com.metro.auth.platform.mapper.PlatformSysRoleMapper;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.StrUtil;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PlatformApplicationsServiceImpl implements PlatformApplicationsService {

    @Resource
    PlatformApplicationsMapper platformApplicationsMapper;
    @Resource
    PlatformSysRoleMapper platformSysRoleMapper;

    @Override
    public PageInfo<PlatformApplications> pagedlist(PlatformApplications platformApplications, int pageNum, int pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        PlatformApplicationsExample platformApplicationsExample = new PlatformApplicationsExample();

        if (platformApplications != null && !EmptyUtilHelper.isEmpty(platformApplications.getTitle())) {
            platformApplicationsExample.createCriteria().andTitleLike("%" + platformApplications.getTitle() + "%");

        }
        List<PlatformApplications> list = platformApplicationsMapper.selectByExample(platformApplicationsExample);

        PageInfo<PlatformApplications> pageInfo = new PageInfo<>(list);

        return pageInfo;
    }

    @Override
    public int savaApp(PlatformApplications platformApplications) throws Exception {

        // 判断待办唯一标识是否重复
        if ("1".equals(platformApplications.getOpenmail()) && StringUtils.isEmpty(platformApplications.getMailtype())) {
            throw new Exception("启用待办标识不能为空");
        }
        if (StringUtils.isNotEmpty(platformApplications.getMailtype())) {
            //所有应用
            List<PlatformApplications> attlist = platformApplicationsMapper.selectListByMailType(platformApplications.getMailtype(), platformApplications.getId());
            if (attlist.size() > 0) {
                throw new Exception("启用待办标识不能重复，请重新设置");
            }
        }


        int count = 0;
        if (platformApplications != null && !EmptyUtilHelper.isEmpty(platformApplications.getId())) {
            //更新
            PlatformApplicationsExample platformApplicationsExample = new PlatformApplicationsExample();
            platformApplicationsExample.createCriteria().andIdEqualTo(platformApplications.getId());
            count = platformApplicationsMapper.updateByExample(platformApplications, platformApplicationsExample);
        } else {
            //主键
//            platformApplications.setId(StrUtil.makePramykey());
//            platformApplications.setAppid(StrUtil.makePramykey());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            platformApplications.setAddtime(sdf.format(new Date()));
            count = platformApplicationsMapper.insert(platformApplications);
        }

        return count;
    }

    @Override
    public int deleApp(Integer id) {
        int count = platformApplicationsMapper.deleteByPrimaryKey(id);
        return count;
    }
    @Override
    public List<PlatformApplications> getPlatformApplicationsList() {
        return platformApplicationsMapper.getPlatformApplicationsList();
    }

    @Override
    public int updateOrder(List<PlatformApplications> list) {
        int updated = 0;
        if (list == null || list.isEmpty()) {
            return updated;
        }
        for (PlatformApplications item : list) {
            if (item.getId() != null) {
                PlatformApplications record = new PlatformApplications();
                record.setId(item.getId());
                record.setNum(item.getNum());
                updated += platformApplicationsMapper.updateByPrimaryKeySelective(record);
            }
        }
        return updated;
    }

    @Override
    public List<PlatformApplications> getPlatformApplicationsListByUserid(String userid) {
        // 1. 查询所有启用的应用
        PlatformApplicationsExample example = new PlatformApplicationsExample();
        example.createCriteria().andQyflagEqualTo("1");
        List<PlatformApplications> allApplications = platformApplicationsMapper.selectByExample(example);

        // 3. 安全地解析userid并查询用户角色
        Set<String> roleIds = new HashSet<>();
        int userIdInt = Integer.parseInt(userid);
        // 直接查询出角色ID列表，避免在Java代码中循环提取
        roleIds = platformSysRoleMapper.selectByUserId(userIdInt)
                .stream().map(PlatformSysRole::getId)
                .collect(Collectors.toSet());

        // 4. 根据角色ID列表查询可见应用
        List<PlatformApplications> visibleApplications;
        if (roleIds.isEmpty()) {
            visibleApplications = Collections.emptyList(); // 如果没有角色，则可见应用列表为空
        } else {
            visibleApplications = platformApplicationsMapper.getPlatformApplicationsListByRoleList(new ArrayList<>(roleIds));
        }

        // 提取可见应用的ID集合，用于快速判断
        Set<Integer> visibleAppIds = visibleApplications.stream()
                .map(PlatformApplications::getId)
                .collect(Collectors.toSet());

        // 遍历所有应用，根据其ID是否在可见应用ID集合中来更新状态
        allApplications.forEach(app -> {
            if (visibleAppIds.contains(app.getId())) {
                app.setRoleUseStatue(app.getId()); // 可见
            } else {
                app.setRoleUseStatue(0); // 不可见
            }
        });
        return allApplications.stream()
                .sorted(Comparator.comparing(app -> StringUtils.isEmpty(app.getNum()) ? 0 : Integer.parseInt(app.getNum())))
                .collect(Collectors.toList());

    }


    @Override
    public List<PlatformApplications> getPlatformApplicationsListByRole(String roleid) {
        PlatformApplicationsExample platformApplicationsExample = new PlatformApplicationsExample();
        //所有应用
        List<PlatformApplications> alllist = platformApplicationsMapper.selectByExample(platformApplicationsExample);
        //当前角色可见应用
        List<PlatformApplications> rolelist = platformApplicationsMapper.getPlatformApplicationsListByRole(roleid);
        if (rolelist != null && rolelist.size() > 0) {
            for (int i = 0; i < rolelist.size(); i++) {
                int finalI = i;
                alllist.stream().forEach(t -> {
                    if (t.getId().equals(rolelist.get(finalI).getId())) {
                        t.setRoleUseStatue(t.getId());
                    }
                });
            }
        } else {
            alllist.stream().forEach(t -> {
                t.setRoleUseStatue(0);
            });
        }
        return alllist;
    }

}
