package com.metro.auth.platform.viewformat;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@Slf4j
public class DateUtils {

    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    /**
     * 字符串、日期格式 转换日期
     * @param str 例如: "2019-12-03 23:21:24"
     */
    public static Date strToDate(String str) {
        if (!StringUtils.isEmpty(str)) {
            try {
                Date date = new SimpleDateFormat(DATE_TIME_FORMAT).parse(str);
                return date;
            } catch (ParseException e) {
                if (log.isWarnEnabled()) {
                    log.warn(e.getMessage());
                }
            }
        }
        return null;
    }
}
