package com.metro.auth.platform.wxmessage;

import com.alibaba.fastjson.JSONObject;
import com.metro.auth.platform.domain.auth.PlatformPersonnel;
import com.metro.auth.platform.http.HttpAPIService;
import com.metro.auth.platform.service.PlatformPersonnelService;
import com.metro.auth.platform.utils.EmptyUtilHelper;
import com.metro.auth.platform.utils.JSONUtil;
import com.metro.auth.platform.utils.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @ClassName: messagesend
 * @Description: ${description}  
 * @Authror zhouy
 * @Date 2019-07-22 15:58
 */

@Slf4j
@Component
public class Messagesend {

    @Value("${weixin-params.wx_sendmessage_url}")
    private String WX_SENDMESSAGE_URL;

    @Value("${weixin-params.wx_corpid}")
    private String WX_CORPID;

    @Value("${weixin-params.wx_agentid}")
    private String WX_AGENTID;

    @Resource
    private HttpAPIService httpAPIService;

    @Async
    public JSONObject messagesend(MessageSendType messageSendType){

        String access_token = SpringUtil.getBean(ApiConfig.class).getAccessToken();
        //1.获取json字符串：将message对象转换为json字符串
        String jsonstr = JSONUtil.toJson(this.getTextMessage(messageSendType));
        JSONObject httpResult = new JSONObject();
        log.info("推送消息"+jsonstr);
        try {
            String sendurl = WX_SENDMESSAGE_URL+access_token;
             httpResult= httpAPIService.doPost(sendurl,jsonstr);
            log.info("推送信息: "+httpResult.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return httpResult;
    }

    /**
     * 功能描述: <br>构建发送信息用户组
     * 〈〉
     * @Param: [list]
     * @Return: [list]
     * @Author: zhouy
     * @Date: 2019-07-24 20:45
     */

    private String buildUserids(List<PlatformPersonnel> list){
        String userids ="";
        if (list!=null&&list.size()>0){
            for (PlatformPersonnel platformPersonnel : list){
                userids+=platformPersonnel.getAccount();
                if(!EmptyUtilHelper.isEmpty(platformPersonnel.getAccount())){
                    userids=userids+"|";
                }
            }
            userids = userids.substring(0,userids.length()-1);
        }

        return userids;
    }

    /**
     * 功能描述: 构建消息体
     * 〈〉
     * @Param: []messageSendTyp
     * @Return: []
     * @Author: zhouy
     * @Date: 2019-08-02 16:47
     */
    private TextMessage getTextMessage(MessageSendType messageSendType){
        String toUserids="";
        if(!EmptyUtilHelper.isEmpty(messageSendType.getList())){//处理直接传递工号推送类型消息
            toUserids =this.buildUserids(messageSendType.getList());
        }

        TextMessage message=new TextMessage();
        message.setTouser(toUserids);
        message.setMsgtype("text");
        message.setAgentid(Integer.parseInt(WX_AGENTID));
        Text text=new Text();
        text.setContent(messageSendType.getDepiction());
        message.setText(text);
        return message;
    }

}
