package com.metro.auth.platform.controller;

import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformApplications;
import com.metro.auth.platform.service.PlatformRoleApplicationAppService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@RequestMapping("/PlatformRoleApplicationAppController")
public class PlatformRoleApplicationAppController {

    @Resource
    PlatformRoleApplicationAppService platformRoleApplicationAppService;

    @GetMapping("/platformapplications/listallApp")
    public ResultJson listallApp(){
        List<PlatformApplications> list =  platformRoleApplicationAppService.getPlatformApplicationsListApp();
        return ResultJson.ok(list);
    }

    @GetMapping("/platformapplications/listbyroleApp/{roleid}")
    public ResultJson listbyroleApp(@PathVariable String roleid){
        List<PlatformApplications> list =  platformRoleApplicationAppService.getPlatformApplicationsListByRoleApp(roleid);
        return ResultJson.ok(list);
    }
}
