package com.metro.auth.platform.controller;

/**
 * .::::.
 * .::::::::.
 * :::::::::::    佛主保佑、永无Bug
 * ..:::::::::::'
 * '::::::::::::'
 * .::::::::::
 * '::::::::::::::..
 * ..::::::::::::.
 * ``::::::::::::::::
 * ::::``:::::::::'        .:::.
 * ::::'   ':::::'       .::::::::.
 * .::::'      ::::     .:::::::'::::.
 * .:::'       :::::  .:::::::::' ':::::.
 * .::'        :::::.:::::::::'      ':::::.
 * .::'         ::::::::::::::'         ``::::.
 * ...:::           ::::::::::::'              ``::.
 * ```` ':.          ':::::::::'                  ::::..
 * '.:::::'                    ':'````..
 */

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformPersonnel;
import com.metro.auth.platform.domain.auth.PlatformSysRole;
import com.metro.auth.platform.domain.auth.PlatformSysUserRole;
import com.metro.auth.platform.outlineapi.PlatformUrlManager;
import com.metro.auth.platform.service.PlatformRoleUserService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

/**
 * @ClassName: PlatformRoleUserController
 * @Description: ${description}
 * @Authror zhouy
 * @Date 2019-09-11 17:17
 */

@RestController
@RequestMapping("/roleuser")
public class PlatformRoleUserController {

    @Resource
    PlatformRoleUserService platformRoleUserService;

    /**
     * 功能描述: <br>权限-用户列表
     * 〈〉
     *
     * @Param: [pageNum, pageSize, platformSysRole]
     * @Return: [pageNum, pageSize, platformSysRole]
     * @Author: zhouy
     * @Date: 2019-09-11 18:22
     */

    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required = true, value = "pageNum", defaultValue = "1") int pageNum,
                                @RequestParam(required = true, value = "pageSize", defaultValue = "15") int pageSize,
                                PlatformSysRole platformSysRole) {
        PageInfo<PlatformSysRole> page = platformRoleUserService.pageRoledlist(platformSysRole, pageNum, pageSize);
        return ResultJson.ok(page);
    }

    /**
     * 功能描述: <br>权限-用户列表
     * 〈〉
     *
     * @Param: [pageNum, pageSize, platformSysRole]
     * @Return: [pageNum, pageSize, platformSysRole]
     * @Author: zhouy
     * @Date: 2019-09-11 18:22
     */

    @GetMapping("/roleuserpagedlist")
    public ResultJson roleuserpagedlist(@RequestParam(required = true, value = "pageNum", defaultValue = "1") int pageNum,
                                        @RequestParam(required = true, value = "pageSize", defaultValue = "15") int pageSize,
                                        PlatformPersonnel platformPersonnel) {
        PageInfo<PlatformPersonnel> page = platformRoleUserService.roleuserpagedlist(platformPersonnel, pageNum, pageSize);
        return ResultJson.ok(page);
    }


    /**
     * 周海峰
     * 获取角色下的所有用户
     *
     * @param platformPersonnel
     * @return
     */
    @GetMapping("/roleuserlist")
    public ResultJson roleuserpagedlist(PlatformPersonnel platformPersonnel) {
        List<PlatformSysUserRole> page = platformRoleUserService.roleuserlist(platformPersonnel);
        return ResultJson.ok(page);
    }

    /**
     * 功能描述: <br>更新权限角色
     * 〈〉
     *
     * @Param: [platformSysRole]
     * @Return: [platformSysRole]
     * @Author: zhouy
     * @Date: 2019-09-12 14:09
     */

    @RequestMapping("/editroleuser")
    public ResultJson editroleuser(@RequestBody PlatformSysUserRole platformSysUserRole) {
        int count = platformRoleUserService.editroleuser(platformSysUserRole);
        if (count > 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }

    }

    @RequestMapping("/delUserRole")
    public ResultJson delUserRole(@RequestBody PlatformSysUserRole platformSysUserRole) {
        int count = platformRoleUserService.delUserRole(platformSysUserRole);
        if (count > 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }

    }

    @RequestMapping("/addroleuser")
    public ResultJson addroleuser(@RequestBody PlatformSysUserRole platformSysUserRole) {
        int count = platformRoleUserService.addroleuser(platformSysUserRole);
        if (count > 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }

    }

    /**
     * 周海峰20200307
     * 保存角色用户信息（单角色多用户）
     *
     * @param map
     * @return
     */
    @RequestMapping("/editUserRoleList")
    public ResultJson editUserRoleList(@RequestBody Map<String, String> map) {
        int count = platformRoleUserService.editUserRoleList(map);
        if (count > 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.SERVER_ERROR);
        }

    }

    /**
     * 给用户添加公告角色
     *
     * @param map 用户ID
     */
    @PostMapping("/addUserNoticeRole")
    public ResultJson addUserNoticeRole(@RequestBody Map<String, String> map) {
        String roleId = PlatformUrlManager.notice_role_id;
        String userId = map.get("userId");
        PlatformPersonnel req = new PlatformPersonnel();
        req.setId(Integer.parseInt(userId));
        List<PlatformSysUserRole> platformSysUserRoles = platformRoleUserService.userRoleList(req);
        List<String> collect = platformSysUserRoles.stream()
                .map(PlatformSysUserRole::getRoleId)
                .collect(Collectors.toList());
        if (!collect.isEmpty() && collect.contains(roleId)) {
            // 用户已拥有该角色，直接返回成功
            return ResultJson.ok();
        }
        String id = UUID.randomUUID().toString().replace("-", "");
        PlatformSysUserRole platformSysUserRole = new PlatformSysUserRole(id, Integer.parseInt(userId), roleId);
        int count = platformRoleUserService.addUserRole(platformSysUserRole);
        if (count > 0) {
            return ResultJson.ok();
        } else {
            return ResultJson.failure(ResultCode.SERVER_ERROR);
        }
    }
}
