package com.metro.auth.platform.service;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.auth.PlatformMetroworkMenu;
import com.metro.auth.platform.domain.auth.PlatformMetroworkMenuExample;
import com.metro.auth.platform.mapper.PlatformMetroworkMenuMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.UUID;

/**
 * 地铁工作菜单服务实现类
 */
@Service
public class PlatformMetroworkMenuServiceImpl implements PlatformMetroworkMenuService {

    @Autowired
    private PlatformMetroworkMenuMapper platformMetroworkMenuMapper;

    @Override
    public List<PlatformMetroworkMenu> getEnabledMenus() {
        PlatformMetroworkMenuExample example = new PlatformMetroworkMenuExample();
        example.createCriteria().andStatusEqualTo(1);
        example.setOrderByClause("sort_order asc");
        return platformMetroworkMenuMapper.selectByExample(example);
    }

    @Override
    public List<PlatformMetroworkMenu> getAllMenus() {
        PlatformMetroworkMenuExample example = new PlatformMetroworkMenuExample();
        example.setOrderByClause("sort_order asc");
        return platformMetroworkMenuMapper.selectByExample(example);
    }

    @Override
    public PlatformMetroworkMenu getMenuById(String id) {
        return platformMetroworkMenuMapper.selectByPrimaryKey(id);
    }

    @Override
    public void saveMenu(PlatformMetroworkMenu menu) {
        menu.setId(UUID.randomUUID().toString().replace("-", ""));
        menu.setCreateTime(new Date());
        menu.setUpdateTime(new Date());
        platformMetroworkMenuMapper.insertSelective(menu);
    }

    @Override
    public void updateMenu(PlatformMetroworkMenu menu) {
        menu.setUpdateTime(new Date());
        platformMetroworkMenuMapper.updateByPrimaryKeySelective(menu);
    }

    @Override
    public void deleteMenu(String id) {
        platformMetroworkMenuMapper.deleteByPrimaryKey(id);
    }

    @Override
    public void enableMenu(String id) {
        PlatformMetroworkMenu menu = new PlatformMetroworkMenu();
        menu.setId(id);
        menu.setStatus(1);
        menu.setUpdateTime(new Date());
        platformMetroworkMenuMapper.updateByPrimaryKeySelective(menu);
    }

    @Override
    public void disableMenu(String id) {
        PlatformMetroworkMenu menu = new PlatformMetroworkMenu();
        menu.setId(id);
        menu.setStatus(0);
        menu.setUpdateTime(new Date());
        platformMetroworkMenuMapper.updateByPrimaryKeySelective(menu);
    }

    @Override
    public PageInfo<PlatformMetroworkMenu> getMenusPaged(PlatformMetroworkMenu menu, int pageNum, int pageSize) {
        PageHelper.startPage(pageNum, pageSize);
        PlatformMetroworkMenuExample example = new PlatformMetroworkMenuExample();
        PlatformMetroworkMenuExample.Criteria criteria = example.createCriteria();

        // 添加查询条件
        if (StringUtils.hasText(menu.getName())) {
            criteria.andNameLike("%" + menu.getName() + "%");
        }
        if (StringUtils.hasText(menu.getCode())) {
            criteria.andCodeLike("%" + menu.getCode() + "%");
        }

        example.setOrderByClause("sort_order asc");
        List<PlatformMetroworkMenu> list = platformMetroworkMenuMapper.selectByExample(example);
        return new PageInfo<>(list);
    }
}
