package com.metro.auth.platform.controller;

import com.github.pagehelper.PageInfo;
import com.metro.auth.platform.domain.Pagination;
import com.metro.auth.platform.domain.ResultCode;
import com.metro.auth.platform.domain.ResultJson;
import com.metro.auth.platform.domain.auth.PlatformRecipes;
import com.metro.auth.platform.generallog.LogAnnotation;
import com.metro.auth.platform.service.PlatformRecipesService;
import com.metro.auth.platform.utils.DateUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/sysrecipes")
public class PlatformRecipesController {
    @Value("${jwt.header}")
    private String tokenHeader;
    @Resource
    private PlatformRecipesService platformRecipesService;

    /**
     * 查询列表
     * @param pageNum
     * @param pageSize
     * @param platformRecipes
     * @return
     */
    @GetMapping("/pagedlist")
    public ResultJson pagedlist(@RequestParam(required=true,value="pageNum",defaultValue="1") int pageNum,
                                @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformRecipes platformRecipes, HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        PageInfo<PlatformRecipes> page =  platformRecipesService.pagedlist(platformRecipes,pageNum,pageSize);
        return ResultJson.ok(page);
    }

    /**
     * 根据id更新实体
     * @param platformRecipes
     * @return
     */
    @LogAnnotation(operateContent="菜谱",operateType="更新")
    @PostMapping("/update")
    public  ResultJson update(@RequestBody PlatformRecipes platformRecipes){
        int flag=platformRecipesService.saveUpdatePlatformRecipes(platformRecipes);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 根据id更新实体
     * @param platformRecipes
     * @return
     */
    @LogAnnotation(operateContent="菜谱",operateType="新增")
    @PostMapping("/add")
    public  ResultJson add(@RequestBody PlatformRecipes platformRecipes){
        int flag=0;
        if (platformRecipes.getDatetime()!=null && !"".equals(platformRecipes.getDatetime()) && platformRecipes.getLine()!=null && !"".equals(platformRecipes.getLine())){
            //判断数据是否为空
            Map params = new HashMap<>();
            params.put("datetime",platformRecipes.getDatetime());
            params.put("line",platformRecipes.getLine());
            PlatformRecipes entity=platformRecipesService.loadByDateAndLine(params);
            if (entity!=null){
                 entity.setStatus("0");
                 entity.setAm_fs(platformRecipes.getAm_fs());
                 entity.setAm_qt(platformRecipes.getAm_qt());
                 entity.setAm_zs(platformRecipes.getAm_zs());
                 entity.setMemo(platformRecipes.getMemo());
                 entity.setPm_bc(platformRecipes.getPm_bc());
                 entity.setPm_fs(platformRecipes.getPm_fs());
                 entity.setPm_qt(platformRecipes.getPm_qt());
                 entity.setPm_zs(platformRecipes.getPm_zs());
                 entity.setSoup(platformRecipes.getSoup());
                 entity.setTitle(platformRecipes.getTitle());
                 entity.setWeekday(platformRecipes.getWeekday());
                flag=platformRecipesService.saveUpdatePlatformRecipes(entity);
            }else{
                flag=platformRecipesService.savePlatformRecipes(platformRecipes);
            }
        }
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id获取实体
     * @param id
     * @return
     */
    @GetMapping("/load")
    public  ResultJson load(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        PlatformRecipes platformRecipes=platformRecipesService.load(id);
        if (platformRecipes!=null){
            return  ResultJson.ok(platformRecipes);
        }else {
            return  ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     *根据id删除实体
     * @param id
     * @return
     */
    @LogAnnotation(operateContent="菜谱",operateType="删除")
    @PostMapping("/delete")
    public  ResultJson delete(@RequestParam(required = true,value = "id",defaultValue = "") String id){
        int flag=platformRecipesService.delPlatformRecipes(id);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }

    /**
     * 根据id更新部门启停状态
     * @return
     */
    @LogAnnotation(operateContent="菜谱",operateType="更新状态")
    @PostMapping("/updatestatus")
    public  ResultJson updatestatus(@RequestBody PlatformRecipes platformRecipes){
        int flag=platformRecipesService.updatePlatformRecipesStatusById(platformRecipes);
        if (flag>0){
            return ResultJson.ok(ResultCode.SUCCESS);
        }else{
            return ResultJson.failure(ResultCode.RESPONSE_ERROR);
        }
    }
    /**
     * 批量启停用
     * @param ids
     * @param status
     * @return
     */
    @LogAnnotation(operateContent="菜谱",operateType="批量更新")
    @PostMapping("/updateRecipesStatus")
    public ResultJson updateRecipesStatus(String ids,String status){
        platformRecipesService.updateRecipesStatus(status,ids);
        return ResultJson.ok();
    }
    /**
     * 接口:查询菜谱列表
     */
    @GetMapping("/getRecipesListByDatetime")
    public  ResultJson getRecipesListByTypeAndNum(String line){
        PlatformRecipes platformRecipes=new PlatformRecipes();
        platformRecipes.setDatetime(DateUtil.getCurTimeByFormatter("yyyy-MM-dd"));
        platformRecipes.setLine(line);
        List<PlatformRecipes> list=platformRecipesService.selectByExample(platformRecipes);
        return  ResultJson.ok(list);
    }

    @PostMapping("/saveexceldata")
    public  ResultJson saveexceldata(@RequestBody PlatformRecipes platformRecipes){
        platformRecipes.setDatetime(DateUtil.getCurTimeByFormatter("yyyy-MM-dd"));
        return  ResultJson.ok();
    }

    /**
     * 查询列表
     * @param pageIndex
     * @param pageSize
     * @param platformRecipes
     * @return
     */
    @GetMapping("/pagedlisthome")
    public ResultJson pagedlisthome(@RequestParam(required=true,value="pageIndex",defaultValue="1") int pageIndex,
                                    @RequestParam(required=true,value="pageSize",defaultValue="15") int pageSize,
                                PlatformRecipes platformRecipes, HttpServletRequest request){
        String token = request.getHeader(tokenHeader);
        PageInfo<PlatformRecipes> page =  platformRecipesService.pagedlisthome(platformRecipes,pageIndex,pageSize);
        Pagination pagination = new Pagination(page.getList(),new Long(page.getTotal()),pageSize,pageIndex);
        return ResultJson.ok(pagination);
    }

    /**
     * 查询所有线路
     */
    @GetMapping("/lineList")
    public ResultJson lineList(){
        return ResultJson.ok(platformRecipesService.selectLine());
    }
}
