package com.metro.auth.platform.http;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@Component
public class HttpAPIService {

    @Autowired
    private CloseableHttpClient httpClient;

    @Autowired
    private RequestConfig config;


    /**
     * 不带参数的get请求，如果状态码为200，则返回body，如果不为200，则返回null
     * @param url
     * @return
     * @throws Exception
     */
    public String doGet(String url) {

         try {
            // 声明 http get 请求
            HttpGet httpGet = new HttpGet(url);

    //        httpGet.setHeader("Authorization",getToken());
            // 装载配置信息
            httpGet.setConfig(config);

            // 发起请求
            CloseableHttpResponse response = this.httpClient.execute(httpGet);
            log.info("请求返回 -----------状态码："+response.getStatusLine().getStatusCode() );
            // 判断状态码是否为200
            if (response.getStatusLine().getStatusCode() == 200) {
                // 返回响应体的内容
               // System.out.println("返回值=="+EntityUtils.toString(response.getEntity(), "UTF-8"));
                return EntityUtils.toString(response.getEntity(), "UTF-8");
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public String doGetHeader(String url, String userid) throws Exception {
        // 声明 http get 请求
        HttpGet httpGet = new HttpGet(url);

        httpGet.setHeader("token",userid);
        httpGet.setHeader("Authorization",userid);
        // 装载配置信息
        httpGet.setConfig(config);

        // 发起请求
        CloseableHttpResponse response = this.httpClient.execute(httpGet);

        // 判断状态码是否为200
        if (response.getStatusLine().getStatusCode() == 200) {
            // 返回响应体的内容
            return EntityUtils.toString(response.getEntity(), "UTF-8");
        }
        return null;
    }

    public String doGetHeader(String url, String userid, Map<String, Object> param) throws Exception {

        URIBuilder uriBuilder = new URIBuilder(url);
        if (param != null) {
            // 遍历map,拼接请求参数
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                uriBuilder.setParameter(entry.getKey(), entry.getValue().toString());
            }
        }

        return doGetHeader(uriBuilder.build().toString(), userid);
    }

    /**
     * 带参数的get请求，如果状态码为200，则返回body，如果不为200，则返回null
     * 
     * @param url
     * @return
     * @throws Exception
     */
    public String doGet(String url, Map<String, Object> map) {

        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            if (map != null) {
                // 遍历map,拼接请求参数
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    uriBuilder.setParameter(entry.getKey(), entry.getValue().toString());
                }
            }
            // 调用不带参数的get请求
            return this.doGet(uriBuilder.build().toString());
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 带参数的post请求
     * 
     * @param url
     * @param map
     * @return
     * @throws Exception
     */
        public HttpResult doPost(String url, Map<String, Object> map, String userid) throws Exception {
        // 声明httpPost请求
        HttpPost httpPost = new HttpPost(url);
        // 加入配置信息
        httpPost.setConfig(config);
        httpPost.setHeader("token", userid);
        // 判断map是否为空，不为空则进行遍历，封装from表单对象
        if (map != null) {
            List<NameValuePair> list = new ArrayList<NameValuePair>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
            }
            // 构造from表单对象
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(list, "UTF-8");

            // 把表单放到post里
            httpPost.setEntity(urlEncodedFormEntity);
        }

        // 发起请求
        CloseableHttpResponse response = this.httpClient.execute(httpPost);
        return new HttpResult(response.getStatusLine().getStatusCode(), EntityUtils.toString(
                response.getEntity(), "UTF-8"));
    }

    /**
     * post请求
     * @param url
     * @param json
     * @return
     */
    public JSONObject doPost(String url,String json){
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        // 加入配置信息
        post.setConfig(config);
        JSONObject response = null;
        try {
            StringEntity s = new StringEntity(json, StandardCharsets.UTF_8);
            s.setContentType("application/json");//发送json数据需要设置contentType
            s.setContentEncoding("UTF-8");
            post.setEntity(s);
            CloseableHttpResponse res = httpclient.execute(post);
            if(res.getStatusLine().getStatusCode() == HttpStatus.SC_OK){
                String result = EntityUtils.toString(res.getEntity());// 返回json格式：
                response = JSONObject.parseObject(result);
                log.info("请求返回信息: "+response.toJSONString());
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }

    public JSONObject doPostHeader(String url, String json, String userid){
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(url);
        // 加入配置信息
        post.setConfig(config);
        post.setHeader("token", userid);
        JSONObject response = null;
        try {
            StringEntity s = new StringEntity(json, StandardCharsets.UTF_8);
            s.setContentType("application/json");//发送json数据需要设置contentType
            s.setContentEncoding("UTF-8");
            post.setEntity(s);
            CloseableHttpResponse res = httpclient.execute(post);
            if(res.getStatusLine().getStatusCode() == HttpStatus.SC_OK){
                String result = EntityUtils.toString(res.getEntity());// 返回json格式：
                response = JSONObject.parseObject(result);
                log.info("请求返回信息: "+response.toJSONString());
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }
}