package com.metro.auth.platform.mapper;

import com.metro.auth.platform.domain.auth.PlatformSysRole;
import com.metro.auth.platform.domain.auth.UserDetail;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author zhouy
 * createAt: 2019/8/1
 */
@Repository
public interface AuthMapper {
    /**
     * 根据用户名查找用户
     * @param account
     * @return
     */
    UserDetail findByUsername(@Param("account") String account);

    /**
     * 创建新用户
     * @param userDetail
     */
    void insert(UserDetail userDetail);

    /**
     * 创建用户角色
     * @param userId
     * @param roleId
     * @return
     */
    int insertRole(@Param("userId") long userId, @Param("roleId") String roleId);

    /**
     * 根据角色id查找角色
     * @param roleId
     * @return
     */
    PlatformSysRole findRoleById(@Param("roleId") String roleId);

    /**
     * 根据用户id查找该用户角色
     * @param userId
     * @return
     */
    PlatformSysRole findRoleByUserId(@Param("userId") long userId);

    List<PlatformSysRole> findRolelistByUserId(@Param("userId") long userId);
}
